/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LifecycleAware;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.common.Assert;
import org.axonframework.common.caching.Cache;
import org.axonframework.disruptor.commandhandling.CommandHandlingEntry;
import org.axonframework.disruptor.commandhandling.FirstLevelCache;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.AggregateCacheEntry;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.modelling.command.ConflictingAggregateVersionException;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandlerInvoker
implements EventHandler<CommandHandlingEntry>,
LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(CommandHandlerInvoker.class);
    private static final ThreadLocal<CommandHandlerInvoker> CURRENT_INVOKER = new ThreadLocal();
    private final Map<Class<?>, DisruptorRepository<?>> repositories = new ConcurrentHashMap();
    private final Cache cache;
    private final int segmentId;

    public static <T> DisruptorRepository<T> getRepository(Class<?> type) {
        CommandHandlerInvoker invoker = CURRENT_INVOKER.get();
        Assert.state((invoker != null ? 1 : 0) != 0, () -> "The repositories of a DisruptorCommandBus are only available in the invoker thread");
        return invoker.repositories.get(type);
    }

    public CommandHandlerInvoker(Cache cache, int segmentId) {
        this.cache = cache;
        this.segmentId = segmentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(CommandHandlingEntry entry, long sequence, boolean endOfBatch) {
        if (entry.isRecoverEntry()) {
            this.removeEntry(entry.getAggregateIdentifier());
        } else if (entry.getInvokerId() == this.segmentId) {
            entry.start();
            try {
                Object result = entry.getInvocationInterceptorChain().proceed();
                entry.setResult(GenericCommandResultMessage.asCommandResultMessage((Object)result));
            }
            catch (Exception throwable) {
                entry.setResult(GenericCommandResultMessage.asCommandResultMessage((Throwable)throwable));
            }
            finally {
                entry.pause();
            }
        }
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(eventStore, null, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClass((Class)aggregateFactory.getAggregateType()));
    }

    public <T> Repository<T> createRepository(EventStore eventStore, RepositoryProvider repositoryProvider, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return this.repositories.computeIfAbsent(aggregateFactory.getAggregateType(), k -> new DisruptorRepository(aggregateFactory, this.cache, eventStore, parameterResolverFactory, handlerDefinition, snapshotTriggerDefinition, repositoryProvider));
    }

    private void removeEntry(String aggregateIdentifier) {
        for (DisruptorRepository<?> repository : this.repositories.values()) {
            ((DisruptorRepository)repository).removeFromCache(aggregateIdentifier);
        }
        this.cache.remove((Object)aggregateIdentifier);
    }

    public void onStart() {
        CURRENT_INVOKER.set(this);
    }

    public void onShutdown() {
        CURRENT_INVOKER.remove();
    }

    static final class DisruptorRepository<T>
    implements Repository<T> {
        private final EventStore eventStore;
        private final RepositoryProvider repositoryProvider;
        private final SnapshotTriggerDefinition snapshotTriggerDefinition;
        private final AggregateFactory<T> aggregateFactory;
        private final FirstLevelCache<T> firstLevelCache = new FirstLevelCache();
        private final Cache cache;
        private final AggregateModel<T> model;

        private DisruptorRepository(AggregateFactory<T> aggregateFactory, Cache cache, EventStore eventStore, ParameterResolverFactory parameterResolverFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
            this.aggregateFactory = aggregateFactory;
            this.cache = cache;
            this.eventStore = eventStore;
            this.snapshotTriggerDefinition = snapshotTriggerDefinition;
            this.model = AnnotatedAggregateMetaModelFactory.inspectAggregate((Class)aggregateFactory.getAggregateType(), (ParameterResolverFactory)parameterResolverFactory);
            this.repositoryProvider = repositoryProvider;
        }

        private DisruptorRepository(AggregateFactory<T> aggregateFactory, Cache cache, EventStore eventStore, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
            this.aggregateFactory = aggregateFactory;
            this.cache = cache;
            this.eventStore = eventStore;
            this.snapshotTriggerDefinition = snapshotTriggerDefinition;
            this.model = AnnotatedAggregateMetaModelFactory.inspectAggregate((Class)aggregateFactory.getAggregateType(), (ParameterResolverFactory)parameterResolverFactory, (HandlerDefinition)handlerDefinition);
            this.repositoryProvider = repositoryProvider;
        }

        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            ((CommandHandlingEntry)CurrentUnitOfWork.get()).registerAggregateIdentifier(aggregateIdentifier);
            Aggregate<T> aggregate = this.load(aggregateIdentifier);
            if (expectedVersion != null && aggregate.version() > expectedVersion) {
                throw new ConflictingAggregateVersionException(aggregateIdentifier, expectedVersion.longValue(), aggregate.version().longValue());
            }
            return aggregate;
        }

        public Aggregate<T> load(String aggregateIdentifier) {
            Object cachedItem;
            ((CommandHandlingEntry)CurrentUnitOfWork.get()).registerAggregateIdentifier(aggregateIdentifier);
            EventSourcedAggregate aggregateRoot = this.firstLevelCache.get(aggregateIdentifier);
            if (aggregateRoot == null && (cachedItem = this.cache.get((Object)aggregateIdentifier)) instanceof AggregateCacheEntry) {
                EventSourcedAggregate cachedAggregate = ((AggregateCacheEntry)cachedItem).recreateAggregate(this.model, this.eventStore, this.repositoryProvider, this.snapshotTriggerDefinition);
                aggregateRoot = (EventSourcedAggregate)cachedAggregate.invoke(r -> {
                    if (this.aggregateFactory.getAggregateType().isInstance(r)) {
                        return cachedAggregate;
                    }
                    return null;
                });
            }
            if (aggregateRoot == null) {
                logger.debug("Aggregate {} not in first level cache, loading fresh one from Event Store", (Object)aggregateIdentifier);
                DomainEventStream eventStream = this.eventStore.readEvents(aggregateIdentifier);
                SnapshotTrigger trigger = this.snapshotTriggerDefinition.prepareTrigger(this.aggregateFactory.getAggregateType());
                if (!eventStream.hasNext()) {
                    throw new AggregateNotFoundException(aggregateIdentifier, "The aggregate was not found in the event store");
                }
                aggregateRoot = EventSourcedAggregate.initialize((Object)this.aggregateFactory.createAggregateRoot(aggregateIdentifier, eventStream.peek()), this.model, (EventBus)this.eventStore, (RepositoryProvider)this.repositoryProvider, (SnapshotTrigger)trigger);
                aggregateRoot.initializeState(eventStream);
                this.firstLevelCache.put(aggregateRoot.identifierAsString(), aggregateRoot);
                this.cache.put((Object)aggregateIdentifier, (Object)new AggregateCacheEntry(aggregateRoot));
            }
            return aggregateRoot;
        }

        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            SnapshotTrigger trigger = this.snapshotTriggerDefinition.prepareTrigger(this.aggregateFactory.getAggregateType());
            EventSourcedAggregate aggregate = EventSourcedAggregate.initialize(factoryMethod, this.model, (EventBus)this.eventStore, (RepositoryProvider)this.repositoryProvider, (SnapshotTrigger)trigger);
            if (aggregate.identifierAsString() != null) {
                this.firstLevelCache.put(aggregate.identifierAsString(), aggregate);
                this.cache.put((Object)aggregate.identifierAsString(), (Object)new AggregateCacheEntry(aggregate));
            }
            return aggregate;
        }

        public Aggregate<T> loadOrCreate(String aggregateIdentifier, Callable<T> factoryMethod) throws Exception {
            try {
                return this.load(aggregateIdentifier);
            }
            catch (AggregateNotFoundException ex) {
                Aggregate<T> newInstance = this.newInstance(factoryMethod);
                this.firstLevelCache.put(aggregateIdentifier, (EventSourcedAggregate)newInstance);
                this.cache.put((Object)aggregateIdentifier, (Object)new AggregateCacheEntry((EventSourcedAggregate)newInstance));
                return newInstance;
            }
            catch (Exception e) {
                logger.debug("Exception occurred while trying to load/create an aggregate. ", (Throwable)e);
                throw e;
            }
        }

        private void removeFromCache(String aggregateIdentifier) {
            EventSourcedAggregate<T> removed = this.firstLevelCache.remove(aggregateIdentifier);
            if (removed != null) {
                logger.debug("Aggregate {} removed from first level cache for recovery purposes.", (Object)aggregateIdentifier);
            }
        }

        public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
            if (this.canResolve(scopeDescription)) {
                String aggregateIdentifier = ((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString();
                this.load(aggregateIdentifier).handle(message);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor && Objects.equals(this.model.type(), ((AggregateScopeDescriptor)scopeDescription).getType());
        }
    }
}

