/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.client.services;

import java.util.List;

import org.springframework.stereotype.Service;

import lombok.extern.slf4j.Slf4j;
import org.autumnframework.service.queue.api.client.listener.CrudQueueListener;
import org.autumnframework.service.queue.api.client.listener.batch.CrudQueueBatchListener;
import org.autumnframework.service.test.api.PersonDTO;
import org.autumnframework.service.test.api.PersonMessage;

/**
 * @author Timon Veenstra
 */
@Slf4j
@Service
public class PersonMessageListener implements CrudQueueListener<PersonDTO, PersonMessage>, CrudQueueBatchListener<PersonDTO, PersonMessage> {
    @Override
    public void handleCreate(PersonMessage message) {
        log.trace("handleCreate {}: {}", message, message.getPayload());
    }

    @Override
    public void handleUpdate(PersonMessage message) {
        log.trace("handleUpdate {}: {}", message, message.getPayload());
    }

    @Override
    public void handleDelete(PersonMessage message) {
        log.trace("handleUpdate {}: {}", message, message.getPayload());
    }
    
    @Override
    public void handleCreateList(List<PersonMessage> messages) {
        log.trace("handleCreateList size{}, some messages {}", messages.size(), messages);
    }

    @Override
    public void handleUpdateList(List<PersonMessage> messages) {
        log.trace("handleUpdateList size{}, some messages {}", messages.size(), messages);
    }

    @Override
    public void handleDeleteList(List<PersonMessage> messages) {
        log.trace("handleDeleteList size{}, some messages {}", messages.size(), messages);
    }
}
