/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.test.queue.client.configuration;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.autumnframework.service.queue.client.config.QueueClientConfig;
import org.autumnframework.service.rabbit.api.properties.RabbitMQApiProperties;

/**
 * @author Timon Veenstra
 */
@Configuration
@Import({QueueClientConfig.class})
@EnableConfigurationProperties({RabbitMQApiProperties.class})
public class TestQueueClientConfiguration {

    @Bean
    public MeterRegistry meterRegistry(){
        return new SimpleMeterRegistry();
    }
}
