/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.graphql.pageable;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Order;

import lombok.Data;

/**
 * 
 */
@Data
public class PageableDTO {
    
	private int page = 0;
	
	private int size = 20;
	
	private String[] sort;
	
	/**
	 * @return
	 */
	public Pageable toPageable() {
		List<Order> orders = new ArrayList<>();
		if (ArrayUtils.isNotEmpty(sort)) {
			for (String field : sort) {
				if (field != null) {
					String name = field.split(":")[0];
					boolean asc = field.indexOf(":") < 0 || "ASC".equalsIgnoreCase(field.split(":")[1]);
					Order o = asc ? Order.asc(name) : Order.desc(name);		
					orders.add(o);
				}
			}
		}
		if (CollectionUtils.isNotEmpty(orders)) {
			return PageRequest.of(page, size).withSort(Sort.by(orders));
		} else {
			return Pageable.ofSize(size).withPage(page);
		}
	}
}
