/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.graphql.geojson;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

import org.autumnframework.service.graphql.geojson.scalars.GeoJSONCoordinatesScalarConverter;
import org.autumnframework.service.graphql.geojson.scalars.GeoJsonScalarConverter;
import org.autumnframework.service.graphql.geojson.scalars.GeometryScalarConverter;
import org.autumnframework.service.graphql.geojson.scalars.JSONNodeScalarConverter;
import org.autumnframework.service.graphql.geojson.scalars.JSONObjectScalarConverter;
import org.autumnframework.service.graphql.geojson.scalars.PointScalarConverter;

/**
 * 
 */
@Configuration
@ComponentScan
public class GeoJsonGraphqlConfig {
    
    /**
     * @return
     */
    @Bean
    public RuntimeWiringConfigurer geoJsonRuntimeWiringConfigurer() {
        return wiringBuilder -> wiringBuilder
                .scalar(GeoJsonScalarConverter.INSTANCE)
                .scalar(GeometryScalarConverter.INSTANCE)
                .scalar(PointScalarConverter.INSTANCE)
                .scalar(JSONNodeScalarConverter.INSTANCE)
                .scalar(GeoJSONCoordinatesScalarConverter.INSTANCE)
                .scalar(JSONObjectScalarConverter.INSTANCE);
    }
}
