/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.handler.db;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.audit4j.core.exception.HandlerException;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.util.Log;
import org.audit4j.handler.db.AuditLogDao;
import org.audit4j.handler.db.AuditLogDaoImpl;
import org.audit4j.handler.db.ConnectionFactory;
import org.audit4j.handler.db.ConnectionType;
import org.audit4j.handler.db.EmbededDBServer;
import org.audit4j.handler.db.HSQLEmbededDBServer;
import org.audit4j.handler.db.Utils;

public class DatabaseAuditHandler
extends Handler {
    private static final long serialVersionUID = -4994028889410866952L;
    private static final String DEFAULT_TABLE_NAME = "audit";
    private final LoadingCache<String, AuditLogDao> daos = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AuditLogDao>(){

        public AuditLogDao load(String tableName) throws HandlerException {
            return new AuditLogDaoImpl(tableName, DatabaseAuditHandler.this.schema);
        }
    });
    private String embedded;
    private String db_driver;
    private String db_url;
    private String db_user;
    private String db_password;
    private String db_connection_type;
    private String db_datasourceClass;
    private String db_jndi_datasource;
    private boolean db_pool_autoCommit = true;
    private Long db_pool_connectionTimeout;
    private Integer db_pool_idleTimeout;
    private Integer db_pool_maxLifetime;
    private Integer db_pool_minimumIdle;
    private Integer db_pool_maximumPoolSize;
    private static final String POOLED_CONNECTION = "pooled";
    private static final String JNDI_CONNECTION = "jndi";
    private EmbededDBServer server;
    private ConnectionFactory factory;
    private boolean separate = false;
    private DataSource dataSource;
    private String table_prefix;
    private String table_suffix = "audit";
    private String default_table_name = "audit";
    private String schema;

    public void init() throws InitializationException {
        if (null == this.embedded || "true".equalsIgnoreCase(this.embedded)) {
            Log.warn((Object)"Audit4j Database Handler runs on embedded mode. See http://audit4j.org/errors#embeddeddb for further details.");
            this.server = HSQLEmbededDBServer.getInstance();
            this.db_driver = this.server.getDriver();
            this.db_url = this.server.getNetworkProtocol() + ":file:audit4jdb";
            if (this.db_user == null) {
                this.db_user = "audit4jdbuser";
            }
            if (this.db_password == null) {
                this.db_password = "audit4jdbpassword";
            }
            this.server.setUname(this.db_user);
            this.server.setPassword(this.db_password);
            this.server.start();
        }
        this.factory = ConnectionFactory.getInstance();
        this.factory.setDataSource(this.dataSource);
        this.factory.setDriver(this.getDb_driver());
        this.factory.setUrl(this.getDb_url());
        this.factory.setUser(this.getDb_user());
        this.factory.setPassword(this.getDb_password());
        this.factory.setDataSourceClass(this.db_datasourceClass);
        this.factory.setAutoCommit(this.db_pool_autoCommit);
        if (this.db_pool_connectionTimeout != null) {
            this.factory.setConnectionTimeout(this.db_pool_connectionTimeout);
        }
        if (this.db_pool_idleTimeout != null) {
            this.factory.setIdleTimeout(this.db_pool_idleTimeout);
        }
        if (this.db_pool_maximumPoolSize != null) {
            this.factory.setMaximumPoolSize(this.db_pool_maximumPoolSize);
        }
        if (this.db_pool_maxLifetime != null) {
            this.factory.setMaxLifetime(this.db_pool_maxLifetime);
        }
        if (this.db_pool_minimumIdle != null) {
            this.factory.setMinimumIdle(this.db_pool_minimumIdle);
        }
        if (this.getDb_connection_type() != null && this.getDb_connection_type().equals(POOLED_CONNECTION)) {
            this.factory.setConnectionType(ConnectionType.POOLED);
        } else if (this.getDb_connection_type() != null && this.getDb_connection_type().equals(JNDI_CONNECTION)) {
            this.factory.setConnectionType(ConnectionType.JNDI);
            this.factory.setJndiDataSource(this.getDb_jndi_datasource());
        } else {
            this.factory.setConnectionType(ConnectionType.SINGLE);
        }
        this.factory.init();
        try {
            this.getDaoForTable(this.default_table_name);
        }
        catch (HandlerException e) {
            throw new InitializationException("Unable to create tables", (Throwable)e);
        }
    }

    public void handle() throws HandlerException {
        String repository = this.getAuditEvent().getRepository();
        boolean writeInDefaultTable = !this.separate || repository == null;
        String tableName = writeInDefaultTable ? this.default_table_name : this.generateTableName(repository);
        this.getDaoForTable(tableName).writeEvent(this.getAuditEvent());
    }

    public void stop() {
        this.factory.stop();
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private String generateTableName(String repository) {
        if (this.table_prefix == null) {
            return repository + "_" + this.table_suffix;
        }
        return this.table_prefix + "_" + repository + "_" + this.table_suffix;
    }

    private AuditLogDao getDaoForTable(String tableName) throws HandlerException {
        try {
            return (AuditLogDao)this.daos.get((Object)tableName);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), HandlerException.class);
            throw new HandlerException("Execution Exception", DatabaseAuditHandler.class, (Throwable)e);
        }
    }

    public String getDb_connection_type() {
        return this.db_connection_type;
    }

    public void setDb_connection_type(String db_connection_type) {
        this.db_connection_type = db_connection_type;
    }

    public String getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(String embedded) {
        this.embedded = embedded;
    }

    public String getDb_driver() {
        return this.db_driver;
    }

    public void setDb_driver(String db_driver) {
        this.db_driver = db_driver;
    }

    public String getDb_url() {
        return this.db_url;
    }

    public void setDb_url(String db_url) {
        this.db_url = db_url;
    }

    public String getDb_user() {
        return this.db_user;
    }

    public void setDb_user(String db_user) {
        this.db_user = db_user;
    }

    public String getDb_password() {
        return this.db_password;
    }

    public void setDb_password(String db_password) {
        this.db_password = db_password;
    }

    public String getDb_jndi_datasource() {
        return this.db_jndi_datasource;
    }

    public void setDb_jndi_datasource(String db_jndi_datasource) {
        this.db_jndi_datasource = db_jndi_datasource;
    }

    public void setSeparate(boolean separate) {
        this.separate = separate;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTable_prefix(String table_prefix) {
        this.table_prefix = table_prefix;
    }

    public void setTable_suffix(String table_suffix) {
        this.table_suffix = table_suffix;
    }

    public void setDefault_table_name(String default_table_name) {
        this.default_table_name = Utils.checkNotEmpty(default_table_name, "Table name must not be empty");
    }

    public void setDb_pool_autoCommit(boolean db_pool_autoCommit) {
        this.db_pool_autoCommit = db_pool_autoCommit;
    }

    public void setDb_pool_connectionTimeout(Long db_pool_connectionTimeout) {
        this.db_pool_connectionTimeout = db_pool_connectionTimeout;
    }

    public void setDb_pool_idleTimeout(Integer db_pool_idleTimeout) {
        this.db_pool_idleTimeout = db_pool_idleTimeout;
    }

    public void setDb_pool_maxLifetime(Integer db_pool_maxLifetime) {
        this.db_pool_maxLifetime = db_pool_maxLifetime;
    }

    public void setDb_pool_minimumIdle(Integer db_pool_minimumIdle) {
        this.db_pool_minimumIdle = db_pool_minimumIdle;
    }

    public void setDb_pool_maximumPoolSize(Integer db_pool_maximumPoolSize) {
        this.db_pool_maximumPoolSize = db_pool_maximumPoolSize;
    }

    public void setDb_datasourceClass(String db_datasourceClass) {
        this.db_datasourceClass = db_datasourceClass;
    }

    public String getTable_suffix() {
        return this.table_suffix;
    }

    public String getTable_prefix() {
        return this.table_prefix;
    }

    public String getDefault_table_name() {
        return this.default_table_name;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean getSeparate() {
        return this.separate;
    }

    public boolean getDb_pool_autoCommit() {
        return this.db_pool_autoCommit;
    }

    public Long getDb_pool_connectionTimeout() {
        return this.db_pool_connectionTimeout;
    }

    public Integer getDb_pool_idleTimeout() {
        return this.db_pool_idleTimeout;
    }

    public Integer getDb_pool_maxLifetime() {
        return this.db_pool_maxLifetime;
    }

    public Integer getDb_pool_minimumIdle() {
        return this.db_pool_minimumIdle;
    }

    public Integer getDb_pool_maximumPoolSize() {
        return this.db_pool_maximumPoolSize;
    }

    public String getDb_datasourceClass() {
        return this.db_datasourceClass;
    }
}

