/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.handler.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.audit4j.core.exception.InitializationException;
import org.audit4j.core.util.Log;
import org.audit4j.handler.db.ConnectionType;

final class ConnectionFactory {
    static final String SINGLE_CONNECTION = "single";
    static final String POOLED_CONNECTION = "pooled";
    private String driver = "org.hsqldb.jdbcDriver";
    private String dataSourceClass = "org.hsqldb.jdbc.JDBCDataSource";
    private String url = "jdbc:hsqldb:hsql://localhost/audit4j";
    private String jndiDataSource;
    private String user = "audit4juser";
    private String password = "audit4jpassword";
    private ConnectionType connectionType;
    private HikariDataSource ds;
    private boolean autoCommit = true;
    private Long connectionTimeout;
    private Integer idleTimeout;
    private Integer maxLifetime;
    private Integer minimumIdle;
    private Integer maximumPoolSize = 100;
    private static final String CONNECTION_POOL_NAME = "Audit4j-DB";
    private static ConnectionFactory instance;
    private DataSource dataSource;

    private ConnectionFactory() {
    }

    Connection getConnection() {
        if (this.dataSource == null) {
            return this.getSingleConnection();
        }
        return this.getDataSourceConnection();
    }

    Connection getSingleConnection() {
        Connection connection = null;
        try {
            Class.forName(this.driver);
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            throw new InitializationException("Could not initialize the connection", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException("Could not find the driver class", (Throwable)e);
        }
        return connection;
    }

    Connection getDataSourceConnection() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new InitializationException("Could not obtain the db connection: Cannot get connection", (Throwable)ex);
        }
        return connection;
    }

    void init() {
        if (this.dataSource == null) {
            if (this.connectionType.equals((Object)ConnectionType.POOLED)) {
                HikariConfig config = new HikariConfig();
                config.setMaximumPoolSize(this.maximumPoolSize.intValue());
                config.setDataSourceClassName(this.dataSourceClass);
                config.addDataSourceProperty("url", (Object)this.url);
                config.addDataSourceProperty("user", (Object)this.user);
                config.addDataSourceProperty("password", (Object)this.password);
                config.setPoolName(CONNECTION_POOL_NAME);
                config.setAutoCommit(this.autoCommit);
                config.setMaximumPoolSize(this.maximumPoolSize.intValue());
                if (this.connectionTimeout != null) {
                    config.setConnectionTimeout(this.connectionTimeout.longValue());
                }
                if (this.idleTimeout != null) {
                    config.setIdleTimeout((long)this.idleTimeout.intValue());
                }
                if (this.maxLifetime != null) {
                    config.setMaxLifetime((long)this.maxLifetime.intValue());
                }
                if (this.minimumIdle != null) {
                    config.setMinimumIdle(this.minimumIdle.intValue());
                }
                this.ds = new HikariDataSource(config);
                this.dataSource = this.ds;
            } else if (this.connectionType.equals((Object)ConnectionType.JNDI)) {
                if (null == this.jndiDataSource) {
                    throw new InitializationException("Could not obtain the db connection: jndi data source is null");
                }
                String DATASOURCE_CONTEXT = this.jndiDataSource;
                try {
                    InitialContext initialContext = new InitialContext();
                    this.dataSource = (DataSource)initialContext.lookup(DATASOURCE_CONTEXT);
                    if (this.dataSource == null) {
                        Log.error((Object)"Failed to lookup datasource.");
                        throw new InitializationException("Could not obtain the db connection: Failed to lookup datasource: " + this.jndiDataSource);
                    }
                }
                catch (NamingException ex) {
                    throw new InitializationException("Could not obtain the db connection: jndi lookup failed", (Throwable)ex);
                }
            }
        }
    }

    void stop() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    void setDriver(String driver) {
        this.driver = driver;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setUser(String user) {
        this.user = user;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public void setJndiDataSource(String jndiDataSource) {
        this.jndiDataSource = jndiDataSource;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setMinimumIdle(int minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setDataSourceClass(String dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConnectionFactory getInstance() {
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (instance == null) {
                instance = new ConnectionFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

