/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.gwt.server.AtmosphereGwtHandler;
import org.atmosphere.gwt.server.GwtAtmosphereResource;
import org.atmosphere.gwt.server.GwtResponseWriter;
import org.atmosphere.gwt.server.SerializationException;
import org.atmosphere.gwt.server.impl.GwtResponseWriterImpl;
import org.atmosphere.gwt.server.impl.HTTPRequestResponseWriter;
import org.atmosphere.gwt.server.impl.IEHTMLFileResponseWriter;
import org.atmosphere.gwt.server.impl.IEXDomainRequestResponseWriter;
import org.atmosphere.gwt.server.impl.IFrameResponseWriter;
import org.atmosphere.gwt.server.impl.OperaEventSourceResponseWriter;
import org.atmosphere.gwt.server.impl.WebsocketResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtAtmosphereResourceImpl
implements GwtAtmosphereResource {
    public static final String HEARTBEAT_MESSAGE = "4dc5bdb9-edc8-4edf-8833-ab478326d8c9";
    private static final long WARMUP_TIME = 10000L;
    private long startTime = System.currentTimeMillis();
    private final GwtResponseWriterImpl writer;
    private AtmosphereResource atmResource;
    private final int heartBeatInterval;
    AtmosphereGwtHandler atmosphereHandler;
    private boolean suspended = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Runnable heartBeatTask = new Runnable(){

        @Override
        public void run() {
            if (GwtAtmosphereResourceImpl.this.isAlive()) {
                GwtAtmosphereResourceImpl.this.post(GwtAtmosphereResourceImpl.HEARTBEAT_MESSAGE);
            }
        }
    };
    private final Serializer serializer = new Serializer(){

        public void write(OutputStream out, Object o) throws IOException {
            if (o instanceof List) {
                List list = (List)o;
                if (list.size() > 0) {
                    if (!(list.get(0) instanceof Serializable)) {
                        throw new IOException("Failed to write a list of objects that are not serializable");
                    }
                    try {
                        GwtAtmosphereResourceImpl.this.writer.write((List)o);
                    }
                    catch (SerializationException ex) {
                        throw new IOException(ex);
                    }
                }
            } else if (o instanceof Serializable) {
                try {
                    GwtAtmosphereResourceImpl.this.writer.write((Serializable)o);
                }
                catch (IOException e) {
                    if (GwtAtmosphereResourceImpl.this.writer.isTerminated()) {
                        GwtAtmosphereResourceImpl.this.logger.debug("broadcast failed, connection terminated:" + e.getMessage(), (Throwable)e);
                    }
                    throw e;
                }
                catch (SerializationException e) {
                    throw new IOException(e);
                }
            } else {
                GwtAtmosphereResourceImpl.this.logger.warn("Failed to write an object that is not serializable");
            }
        }
    };
    private final AtmosphereResourceEventListener eventListener = new AtmosphereResourceEventListenerAdapter(){

        public void onPreSuspend(AtmosphereResourceEvent arg0) {
        }

        public void onSuspend(AtmosphereResourceEvent are) {
            GwtAtmosphereResourceImpl.this.suspended = true;
        }

        public void onResume(AtmosphereResourceEvent event) {
            GwtAtmosphereResourceImpl.this.suspended = false;
            GwtAtmosphereResourceImpl.this.writer.setTerminated(false);
        }

        public void onDisconnect(AtmosphereResourceEvent event) {
            GwtAtmosphereResourceImpl.this.suspended = false;
            GwtAtmosphereResourceImpl.this.writer.setTerminated(false);
        }
    };

    public GwtAtmosphereResourceImpl(AtmosphereResource resource, AtmosphereGwtHandler servlet, int heartBeatInterval) throws IOException {
        this(resource, servlet, heartBeatInterval, true);
    }

    public GwtAtmosphereResourceImpl(AtmosphereResource resource, AtmosphereGwtHandler servlet, int heartBeatInterval, boolean escapeText) throws IOException {
        this.atmosphereHandler = servlet;
        this.atmResource = resource;
        this.heartBeatInterval = heartBeatInterval;
        this.writer = this.createResponseWriter();
        this.writer.escapeText(escapeText);
        resource.getRequest().setAttribute(GwtAtmosphereResource.class.getName(), (Object)this);
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.atmResource.getBroadcaster();
    }

    @Override
    public ServletContext getServletContext() {
        return this.atmosphereHandler.getServletContext();
    }

    @Override
    public HttpSession getSession() {
        return this.atmResource.session();
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.atmResource.session() != null) {
            return this.atmResource.session();
        }
        if (this.atmResource.getRequest() != null) {
            return this.atmResource.getRequest().getSession(create);
        }
        return null;
    }

    GwtResponseWriter getResponseWriter() {
        return this.writer;
    }

    @Override
    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void post(Object message) {
        this.getBroadcaster().broadcast(message, this.atmResource);
    }

    @Override
    public void post(List<?> messages) {
        this.getBroadcaster().broadcast(messages, this.atmResource);
    }

    @Override
    public AtmosphereResource getAtmosphereResource() {
        return this.atmResource;
    }

    @Override
    public boolean isAlive() {
        if (this.writer.isTerminated()) {
            return false;
        }
        if (System.currentTimeMillis() - this.startTime < 10000L) {
            return true;
        }
        if (this.atmResource.getBroadcaster() == null) {
            return false;
        }
        Collection res = this.atmResource.getBroadcaster().getAtmosphereResources();
        for (AtmosphereResource ar : res) {
            if (ar != this.atmResource) continue;
            return true;
        }
        return this.suspended;
    }

    @Override
    public boolean isSystemMessage(Serializable message) {
        return HEARTBEAT_MESSAGE.equals(message);
    }

    long getStartTime() {
        return this.startTime;
    }

    @Override
    public AtmosphereRequest getRequest() {
        return this.atmResource.getRequest();
    }

    @Override
    public AtmosphereResponse getResponse() {
        return this.atmResource.getResponse();
    }

    @Override
    public String getConnectionUUID() {
        return this.atmResource.uuid();
    }

    public void suspend() throws IOException {
        this.suspend(-1);
    }

    public void suspend(int timeout) throws IOException {
        if (!this.suspended) {
            this.atmResource.setSerializer(this.serializer).addEventListener(this.eventListener);
            this.writer.suspend();
            this.atmResource.suspend((long)timeout);
        }
    }

    public void resume() {
        this.atmResource.resume();
    }

    void resumeAfterDeath() {
        if (this.atmosphereHandler != null) {
            this.atmosphereHandler.execute(new Runnable(){

                @Override
                public void run() {
                    GwtAtmosphereResourceImpl.this.atmResource.resume();
                }
            });
        }
    }

    @Override
    public <T> void setAttribute(String name, T value) {
        this.atmResource.getRequest().setAttribute(name, value);
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)this.atmResource.getRequest().getAttribute(name);
    }

    public GwtResponseWriterImpl getWriterImpl() {
        return this.writer;
    }

    @Override
    public void sendError(int statusCode, String message) {
        try {
            this.writer.sendError(statusCode, message);
        }
        catch (IOException ex) {
            this.logger.error("Failed to send error to client", (Throwable)ex);
        }
    }

    ScheduledFuture<?> scheduleHeartbeat() {
        return this.getBroadcaster().getBroadcasterConfig().getScheduledExecutorService().schedule(this.heartBeatTask, (long)this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    void terminate(boolean serverInitiated) {
        AtmosphereGwtHandler s = this.atmosphereHandler;
        if (s != null) {
            this.atmosphereHandler = null;
            if (this.suspended) {
                this.atmResource.resume();
            }
            s.cometTerminated(this, serverInitiated);
        }
    }

    private GwtResponseWriterImpl createResponseWriter() throws IOException {
        String transport = this.atmResource.getRequest().getParameter("tr");
        if (transport == null || transport.isEmpty()) {
            throw new IllegalStateException("Failed to determine transport");
        }
        if ("WebSocket".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using websocket");
            return new WebsocketResponseWriter(this);
        }
        if ("HTTPRequest".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using XMLHttpRequest");
            return new HTTPRequestResponseWriter(this);
        }
        if ("IFrame".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using streaming IFrame");
            return new IFrameResponseWriter(this);
        }
        if ("OperaEventSource".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using Opera EventSource");
            return new OperaEventSourceResponseWriter(this);
        }
        if ("IEXDomainRequest".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using IE XDomainRequest");
            return new IEXDomainRequestResponseWriter(this);
        }
        if ("IEHTMLFile".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using IE html file iframe");
            return new IEHTMLFileResponseWriter(this);
        }
        throw new IllegalStateException("Failed to determine responsewriter for transport: " + transport);
    }
}

