/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.deflate;

import java.io.IOException;
import java.io.OutputStream;

public final class Deflater {
    private int[] window;
    private int windowPtr;
    private int windowState;
    private int recentBytes;
    private char[] windowLink;
    private char[] hashTable;
    private byte[] ucBuffer;
    private int ucBufferPtr;
    private int seqLen;
    private int seqPtr;
    private int seqDist;
    private int maxChainLengthTriplet;
    private int maxDistanceTriplet;
    private int maxChainLengthSeq1;
    private int maxDistanceSeq1;
    private int goodSequenceLength;
    private int maxLazyLength;
    private int maxChainLengthSeq2;
    private int maxDistanceSeq2;
    private boolean huffOnly;
    private int[] buffer;
    private int bufferPtr;
    private OutputStream out;
    private int outByte;
    private int outPtr;
    private byte[] outBuf;
    private int outBufPtr;
    private boolean noOutput;
    public static final int HUFF = 1;
    public static final int SPEED = 2;
    public static final int MEDIUM = 3;
    public static final int COMPACT = 4;
    private static final int[] FIXED_LIT_CODE;
    private static final int[] FIXED_DIST_CODE;
    static final int[] LENGTH;
    static final int[] LENGTH_ENUM;
    static final int[] DIST;
    static final int[] DIST_ENUM;
    static final int[] PERM_CT;

    public Deflater() {
        this(0, 15);
    }

    public Deflater(int level) {
        this(level, 15);
    }

    public Deflater(int level, int windowBits) {
        if (windowBits < 9 || windowBits > 15) {
            throw new IllegalArgumentException("invalid LZ77 window bit length: " + windowBits);
        }
        int bufferLen = 16384;
        int windowLen = 1 << windowBits;
        this.window = new int[windowLen];
        this.windowLink = new char[windowLen];
        this.hashTable = new char[windowLen];
        this.maxDistanceTriplet = windowLen - 261;
        this.maxDistanceSeq1 = windowLen - 261;
        this.maxDistanceSeq2 = windowLen - 261;
        if (level == 0) {
            level = 3;
        }
        switch (level) {
            case 2: {
                this.maxChainLengthTriplet = 16;
                this.maxChainLengthSeq1 = 8;
                this.goodSequenceLength = 8;
                this.maxLazyLength = 4;
                this.maxChainLengthSeq2 = 4;
                break;
            }
            case 3: {
                this.maxChainLengthTriplet = 128;
                this.maxChainLengthSeq1 = 128;
                this.goodSequenceLength = 64;
                this.maxLazyLength = 64;
                this.maxChainLengthSeq2 = 32;
                break;
            }
            case 4: {
                this.maxChainLengthTriplet = 1024;
                this.maxChainLengthSeq1 = 1024;
                this.goodSequenceLength = 258;
                this.maxLazyLength = 258;
                this.maxChainLengthSeq2 = 1024;
                break;
            }
            case 1: {
                this.huffOnly = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compression level: " + level);
            }
        }
        this.buffer = new int[bufferLen];
        this.ucBuffer = new byte[4 * bufferLen + 258];
        this.outBuf = new byte[4096];
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    private static int makeCopySymbol(int len, int dist) {
        int edist;
        int symdist;
        int elen;
        int symlen;
        if (len <= 10) {
            symlen = 254 + len;
            elen = 0;
        } else if (len == 258) {
            symlen = 285;
            elen = 0;
        } else {
            int i;
            for (i = 9; i < 29 && LENGTH[i] <= len; ++i) {
            }
            symlen = 256 + i;
            elen = len - LENGTH[i - 1];
        }
        if (dist <= 4) {
            symdist = dist - 1;
            edist = 0;
        } else {
            int i;
            for (i = 5; i < 30 && DIST[i] <= dist; ++i) {
            }
            symdist = i - 1;
            edist = dist - DIST[i - 1];
        }
        return symlen + (elen << 9) + (symdist << 14) + (edist << 19);
    }

    private static int findPreviousSequence(int[] win, int winMask, char[] wlink, int orig, int dist, int len, int end, int maxLen, int maxDist) {
        int n = orig;
        int chainLength = maxLen;
        block4: while (chainLength-- > 0) {
            int tm;
            char d = wlink[n];
            if (d == '\u0000') {
                return 0;
            }
            if ((dist += d) > maxDist) {
                return 0;
            }
            n = n - d & winMask;
            int j = orig;
            int k = n;
            if (tm >= 3) {
                for (tm = len; tm >= 3; tm -= 3) {
                    if (win[j] != win[k]) continue block4;
                    j = j + 3 & winMask;
                    k = k + 3 & winMask;
                }
                switch (tm) {
                    case 1: {
                        j = j - 2 & winMask;
                        k = k - 2 & winMask;
                        if (win[j] != win[k]) continue block4;
                        k = k + 3 & winMask;
                        break;
                    }
                    case 2: {
                        j = j - 1 & winMask;
                        k = k - 1 & winMask;
                        if (win[j] != win[k]) continue block4;
                        k = k + 3 & winMask;
                    }
                }
            } else {
                if (win[j] != win[k]) continue;
                k = k + tm & winMask;
            }
            if (win[k] != end) continue;
            return dist;
        }
        return 0;
    }

    private void updateUCBuffer(byte[] buf, int off1, int off2) {
        int uLen = this.ucBuffer.length;
        int sInc = uLen >>> 1;
        while (off1 < off2) {
            int free = uLen - this.ucBufferPtr;
            int tc = off2 - off1;
            if (tc > sInc) {
                tc = sInc;
            }
            if (tc > free) {
                System.arraycopy(buf, off1, this.ucBuffer, this.ucBufferPtr, free);
                System.arraycopy(buf, off1 + free, this.ucBuffer, 0, tc - free);
                this.ucBufferPtr = tc - free;
            } else {
                System.arraycopy(buf, off1, this.ucBuffer, this.ucBufferPtr, tc);
                this.ucBufferPtr += tc;
            }
            off1 += tc;
        }
    }

    public void process(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int origOff = off;
        if (this.huffOnly) {
            int[] sb = this.buffer;
            int sbPtr = this.bufferPtr;
            int sbLen = sb.length;
            while (len-- > 0) {
                int bv = buf[off++] & 0xFF;
                sb[sbPtr++] = bv;
                if (sbPtr != sbLen) continue;
                this.updateUCBuffer(buf, origOff, off);
                origOff = off;
                this.endBlock(false, sbPtr);
                sbPtr = 0;
            }
            this.bufferPtr = sbPtr;
            this.updateUCBuffer(buf, origOff, off);
            return;
        }
        if (this.windowState < 2) {
            int bv = buf[off++] & 0xFF;
            --len;
            if (this.windowState == 0) {
                this.recentBytes = bv;
                this.seqLen = 1;
                if (len == 0) {
                    this.updateUCBuffer(buf, origOff, off);
                    return;
                }
                bv = buf[off++] & 0xFF;
                --len;
            }
            this.recentBytes = this.recentBytes << 8 | bv;
            this.windowState = 2;
            this.seqLen = 2;
            if (len == 0) {
                this.updateUCBuffer(buf, origOff, off);
                return;
            }
        }
        int[] win = this.window;
        int winMask = win.length - 1;
        int winPtr = this.windowPtr;
        int recent = this.recentBytes;
        char[] wlink = this.windowLink;
        char[] ht = this.hashTable;
        int htMask = ht.length - 1;
        int sLen = this.seqLen;
        int sPtr = this.seqPtr;
        int sDist = this.seqDist;
        int[] sb = this.buffer;
        int sbPtr = this.bufferPtr;
        int sbLen = sb.length;
        int maxCL0 = this.maxChainLengthTriplet;
        int maxDistCL0 = this.maxDistanceTriplet;
        int maxCL1 = this.maxChainLengthSeq1;
        int maxDistCL1 = this.maxDistanceSeq1;
        int goodSLen = this.goodSequenceLength;
        int maxLLen = this.maxLazyLength;
        int maxCL2 = this.maxChainLengthSeq2;
        int maxDistCL2 = this.maxDistanceSeq2;
        while (len-- > 0) {
            int pv;
            int ph;
            int b0 = buf[off++] & 0xFF;
            int triplet = recent << 8 | b0;
            recent = triplet & 0xFFFF;
            win[winPtr] = triplet;
            int h = triplet + (triplet >>> 4) + (triplet >>> 8) + (triplet >>> 9) - (triplet >>> 16) & htMask;
            int link = ht[h] - '\u0001';
            int dist = link < 0 ? 0 : ((ph = (pv = win[link]) + (pv >>> 4) + (pv >>> 8) + (pv >>> 9) - (pv >>> 16) & htMask) == h ? winPtr - link & winMask : 0);
            ht[h] = (char)(winPtr + 1);
            wlink[winPtr] = (char)dist;
            int thisPtr = winPtr;
            winPtr = winPtr + 1 & winMask;
            if (sLen < 2) {
                ++sLen;
                continue;
            }
            if (sLen == 2) {
                block28: {
                    if (dist == 0) {
                        sb[sbPtr++] = triplet >>> 16;
                        if (sbPtr != sbLen) continue;
                        this.updateUCBuffer(buf, origOff, off);
                        origOff = off;
                        this.endBlock(false, sbPtr);
                        sbPtr = 0;
                        continue;
                    }
                    sDist = dist;
                    int n = link;
                    int chainLen = maxCL0;
                    while (chainLen-- > 0) {
                        if (win[n] != triplet) {
                            char d = wlink[n];
                            if (d == '\u0000' || (sDist += d) > maxDistCL0) break;
                            n = n - d & winMask;
                            continue;
                        }
                        break block28;
                    }
                    sDist = 0;
                }
                if (sDist == 0) {
                    sb[sbPtr++] = triplet >>> 16;
                    if (sbPtr != sbLen) continue;
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                    continue;
                }
                sPtr = thisPtr - sDist & winMask;
                sLen = 3;
                if (sPtr != winPtr) continue;
                sb[sbPtr++] = Deflater.makeCopySymbol(sLen, sDist);
                if (sbPtr == sbLen) {
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                }
                sLen = 0;
                continue;
            }
            if (win[thisPtr - sDist & winMask] == triplet) {
                if (sPtr != winPtr && ++sLen != 258) continue;
                sb[sbPtr++] = Deflater.makeCopySymbol(sLen, sDist);
                if (sbPtr == sbLen) {
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                }
                sLen = 0;
                continue;
            }
            int sDistNew = Deflater.findPreviousSequence(win, winMask, wlink, sPtr, sDist, sLen - 2, triplet, sLen > goodSLen ? maxCL1 >>> 2 : maxCL1, maxDistCL1);
            if (sDistNew > 0) {
                sDist = sDistNew;
                sPtr = thisPtr - (sLen - 2) - sDistNew & winMask;
                if (sPtr != winPtr && ++sLen != 258) continue;
                sb[sbPtr++] = Deflater.makeCopySymbol(sLen, sDist);
                if (sbPtr == sbLen) {
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                }
                sLen = 0;
                continue;
            }
            if (sLen <= maxLLen) {
                int refPtr = thisPtr - (sLen - 2) + 1 & winMask;
                int mdc = maxDistCL2;
                if (mdc > sDist) {
                    mdc = sDist;
                }
                if ((sDistNew = Deflater.findPreviousSequence(win, winMask, wlink, refPtr, 0, sLen - 3, triplet, maxCL2, mdc)) > 0) {
                    sb[sbPtr++] = win[sPtr] >>> 16;
                    if (sbPtr == sbLen) {
                        this.updateUCBuffer(buf, origOff, off);
                        origOff = off;
                        this.endBlock(false, sbPtr);
                        sbPtr = 0;
                    }
                    sDist = sDistNew;
                    sPtr = refPtr - sDistNew & winMask;
                    if (sPtr != winPtr) continue;
                    sb[sbPtr++] = Deflater.makeCopySymbol(sLen, sDist);
                    if (sbPtr == sbLen) {
                        this.updateUCBuffer(buf, origOff, off);
                        origOff = off;
                        this.endBlock(false, sbPtr);
                        sbPtr = 0;
                    }
                    sLen = 0;
                    continue;
                }
            }
            if (sLen == 3 && sDist > 6144) {
                int ot = win[sPtr];
                for (int k = 16; k >= 0; k -= 8) {
                    sb[sbPtr++] = ot >>> k & 0xFF;
                    if (sbPtr != sbLen) continue;
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                }
            } else {
                sb[sbPtr++] = Deflater.makeCopySymbol(sLen, sDist);
                if (sbPtr == sbLen) {
                    this.updateUCBuffer(buf, origOff, off);
                    origOff = off;
                    this.endBlock(false, sbPtr);
                    sbPtr = 0;
                }
            }
            sLen = 1;
        }
        this.windowPtr = winPtr;
        this.recentBytes = recent;
        this.seqLen = sLen;
        this.seqPtr = sPtr;
        this.seqDist = sDist;
        this.bufferPtr = sbPtr;
        this.updateUCBuffer(buf, origOff, off);
    }

    private void prepareFlush() throws IOException {
        switch (this.seqLen) {
            case 0: {
                break;
            }
            case 1: {
                this.buffer[this.bufferPtr++] = this.recentBytes & 0xFF;
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
                break;
            }
            case 2: {
                this.buffer[this.bufferPtr++] = this.recentBytes >>> 8 & 0xFF;
                if (this.bufferPtr == this.buffer.length) {
                    this.endBlock(false, this.bufferPtr);
                }
                this.buffer[this.bufferPtr++] = this.recentBytes & 0xFF;
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
                break;
            }
            default: {
                this.buffer[this.bufferPtr++] = Deflater.makeCopySymbol(this.seqLen, this.seqDist);
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
            }
        }
        this.seqLen = 0;
    }

    private static void heapSort(int[] val, int off, int len) {
        int i;
        if (len <= 1) {
            return;
        }
        int corr = off - 1;
        for (i = 2; i <= len; ++i) {
            int k;
            int f;
            int j = i;
            int v = val[corr + j];
            while (j > 1 && (f = val[corr + (k = j >>> 1)]) <= v) {
                val[corr + j] = f;
                val[corr + k] = v;
                j = k;
            }
        }
        block2: for (i = len; i > 1; --i) {
            int v = val[corr + i];
            val[corr + i] = val[corr + 1];
            val[corr + 1] = v;
            int j = 1;
            while (true) {
                int sv;
                int si;
                int kl = j << 1;
                int kr = kl + 1;
                if (kl >= i) continue block2;
                if (kr >= i) {
                    si = kl;
                    sv = val[corr + kl];
                } else {
                    int cl = val[corr + kl];
                    int cr = val[corr + kr];
                    if (cl > cr) {
                        si = kl;
                        sv = cl;
                    } else {
                        si = kr;
                        sv = cr;
                    }
                }
                if (v > sv) continue block2;
                val[corr + j] = sv;
                val[corr + si] = v;
                j = si;
            }
        }
    }

    private static int[] makeHuffmanCodes(int[] freq, int maxCodeLen) {
        int freqTmpPtr;
        int alphLen = freq.length;
        int[] freqTmp = new int[alphLen];
        for (int i = 0; i < alphLen; ++i) {
            freqTmp[i] = i + 512 + (freq[i] << 10);
        }
        Deflater.heapSort(freqTmp, 0, alphLen);
        for (freqTmpPtr = 0; freqTmpPtr < alphLen && freqTmp[freqTmpPtr] >>> 10 == 0; ++freqTmpPtr) {
        }
        if (freqTmpPtr == alphLen) {
            return new int[alphLen];
        }
        if (freqTmpPtr == alphLen - 1) {
            int[] clen = new int[alphLen];
            clen[freqTmp[freqTmpPtr] & 0x1FF] = 1;
            return clen;
        }
        int[] fifo = new int[alphLen - 1];
        int fifoHead = 0;
        int fifoRear = 0;
        int[] tree = new int[alphLen - 1];
        int treePtr = 0;
        while (true) {
            int n1;
            int n0;
            if (freqTmpPtr == alphLen && fifoRear == fifoHead + 1) break;
            if (fifoRear == fifoHead) {
                n0 = freqTmp[freqTmpPtr++];
                n1 = freqTmp[freqTmpPtr++];
            } else if (freqTmpPtr == alphLen) {
                n0 = fifo[fifoHead++];
                n1 = fifo[fifoHead++];
            } else {
                int f = fifo[fifoHead];
                int q = freqTmp[freqTmpPtr];
                if (f < q) {
                    n0 = f;
                    ++fifoHead;
                } else {
                    n0 = q;
                    ++freqTmpPtr;
                }
                if (fifoHead == fifoRear) {
                    n1 = freqTmp[freqTmpPtr++];
                } else if (freqTmpPtr == alphLen) {
                    n1 = fifo[fifoHead++];
                } else {
                    f = fifo[fifoHead];
                    q = freqTmp[freqTmpPtr];
                    if (f < q) {
                        n1 = f;
                        ++fifoHead;
                    } else {
                        n1 = q;
                        ++freqTmpPtr;
                    }
                }
            }
            int ni = (n0 & 0xFFFFFC00) + (n1 & 0xFFFFFC00) + treePtr;
            fifo[fifoRear++] = ni;
            int nv = (n0 & 0x3FF) + ((n1 & 0x3FF) << 10);
            tree[treePtr++] = nv;
        }
        int rootIndex = fifo[fifoHead] & 0x1FF;
        int[] blCount = new int[maxCodeLen + 1];
        int overdeep = Deflater.getCodeLengths(tree, rootIndex, 0, blCount, maxCodeLen);
        int dpi = maxCodeLen;
        while (overdeep-- > 0) {
            if (dpi == maxCodeLen) {
                while (blCount[--dpi] == 0) {
                }
            }
            int n = dpi++;
            blCount[n] = blCount[n] - 1;
            int n2 = dpi;
            blCount[n2] = blCount[n2] + 2;
        }
        int[] codeLen = new int[alphLen];
        int p = 0;
        while (freqTmp[p] >>> 10 == 0) {
            ++p;
        }
        for (int bits = maxCodeLen; bits > 0; --bits) {
            for (int k = blCount[bits]; k > 0; --k) {
                int sym = freqTmp[p++] & 0x1FF;
                codeLen[sym] = bits;
            }
        }
        return codeLen;
    }

    private static int getCodeLengths(int[] tree, int idx, int depth, int[] blCount, int maxCodeLen) {
        int s;
        if ((idx & 0x200) != 0) {
            if (depth > maxCodeLen) {
                return 1;
            }
            int n = depth;
            blCount[n] = blCount[n] + 1;
            return 0;
        }
        if (depth == maxCodeLen) {
            int n = maxCodeLen;
            blCount[n] = blCount[n] + 1;
            s = -1;
        } else {
            s = 0;
        }
        int n = tree[idx];
        int l = n & 0x3FF;
        int r = n >>> 10 & 0x3FF;
        s += Deflater.getCodeLengths(tree, l, depth + 1, blCount, maxCodeLen);
        return s += Deflater.getCodeLengths(tree, r, depth + 1, blCount, maxCodeLen);
    }

    private static int[] compressTrees(int[] tree1, int tree1len, int[] tree2, int tree2len, int[] freq) {
        int inLen = tree1len + tree2len;
        int[] in = new int[inLen];
        System.arraycopy(tree1, 0, in, 0, tree1len);
        System.arraycopy(tree2, 0, in, tree1len, tree2len);
        int ptr = 0;
        int[] ct = new int[inLen];
        int ctPtr = 0;
        block9: while (ptr < inLen) {
            int r;
            int v;
            if ((v = in[ptr++]) == 0) {
                for (r = 1; r < 138 && ptr < inLen && in[ptr] == 0; ++r, ++ptr) {
                }
                switch (r) {
                    case 1: {
                        ct[ctPtr++] = 0;
                        freq[0] = freq[0] + 1;
                        break;
                    }
                    case 2: {
                        ct[ctPtr++] = 0;
                        ct[ctPtr++] = 0;
                        freq[0] = freq[0] + 2;
                        break;
                    }
                    default: {
                        if (r <= 10) {
                            ct[ctPtr++] = 17 + (r - 3 << 5);
                            freq[17] = freq[17] + 1;
                            break;
                        }
                        ct[ctPtr++] = 18 + (r - 11 << 5);
                        freq[18] = freq[18] + 1;
                        break;
                    }
                }
                continue;
            }
            for (r = 0; r < 6 && ptr < inLen && in[ptr] == v; ++r, ++ptr) {
            }
            ct[ctPtr++] = v;
            int n = v;
            freq[n] = freq[n] + 1;
            switch (r) {
                case 0: {
                    continue block9;
                }
                case 1: {
                    ct[ctPtr++] = v;
                    int n2 = v;
                    freq[n2] = freq[n2] + 1;
                    continue block9;
                }
                case 2: {
                    ct[ctPtr++] = v;
                    ct[ctPtr++] = v;
                    int n3 = v;
                    freq[n3] = freq[n3] + 2;
                    continue block9;
                }
            }
            ct[ctPtr++] = 16 + (r - 3 << 5);
            freq[16] = freq[16] + 1;
        }
        int[] res = new int[ctPtr];
        System.arraycopy(ct, 0, res, 0, ctPtr);
        return res;
    }

    private void writeBits(int val, int num) throws IOException {
        if (num == 0) {
            return;
        }
        while (true) {
            int fs = 8 - this.outPtr;
            int v = this.outByte | val << this.outPtr;
            if (fs > num) {
                this.outByte = v;
                this.outPtr += num;
                return;
            }
            if (fs == num) {
                this.outBuf[this.outBufPtr++] = (byte)v;
                if (this.outBufPtr == this.outBuf.length) {
                    this.out.write(this.outBuf);
                    this.outBufPtr = 0;
                }
                this.outByte = 0;
                this.outPtr = 0;
                return;
            }
            this.outBuf[this.outBufPtr++] = (byte)v;
            if (this.outBufPtr == this.outBuf.length) {
                this.out.write(this.outBuf);
                this.outBufPtr = 0;
            }
            val >>>= fs;
            num -= fs;
            this.outByte = 0;
            this.outPtr = 0;
        }
    }

    private void sendBuffered() throws IOException {
        if (this.outBufPtr > 0) {
            this.out.write(this.outBuf, 0, this.outBufPtr);
            this.outBufPtr = 0;
        }
    }

    private void endBlock(boolean fin, int sbPtr) throws IOException {
        int uRealLen;
        if (this.noOutput) {
            this.bufferPtr = 0;
            return;
        }
        int[] sb = this.buffer;
        int[] freqLit = new int[286];
        int[] freqDist = new int[30];
        freqLit[256] = 1;
        int csU = 0;
        for (int i = 0; i < sbPtr; ++i) {
            int dist;
            int sym;
            int val = sb[i];
            int n = sym = val & 0x1FF;
            freqLit[n] = freqLit[n] + 1;
            if (sym < 256) {
                csU += 8;
                continue;
            }
            csU += 8 * (LENGTH[sym - 257] + (val >>> 9 & 0x1F));
            int n2 = dist = val >>> 14 & 0x1F;
            freqDist[n2] = freqDist[n2] + 1;
        }
        int csUextra = 0;
        for (int t = 0; t < csU; t += 65535) {
            if (t == 0) {
                if (this.outPtr > 5) {
                    csUextra = 48 - this.outPtr;
                    continue;
                }
                csUextra = 40 - this.outPtr;
                continue;
            }
            csUextra += 40;
        }
        int uDataLen = csU >>> 3;
        Huff huff = new Huff(freqLit, freqDist);
        int csD = huff.getDynamicBitLength();
        int csF = huff.getFixedBitLength();
        if ((csU += csUextra) <= csF && csU <= csD) {
            this.writeBits(fin ? 1 : 0, 3);
            if (this.outPtr > 0) {
                this.writeBits(0, 8 - this.outPtr);
            }
            this.writeBits(uDataLen | ~uDataLen << 16, 32);
            this.sendBuffered();
            this.out.write(this.ucBuffer, 0, uDataLen);
        } else if (csF <= csD) {
            this.writeBits(fin ? 3 : 2, 3);
            for (int i = 0; i < sbPtr; ++i) {
                int val = this.buffer[i];
                int sym = val & 0x1FF;
                if (sym < 256) {
                    this.writeBits(FIXED_LIT_CODE[sym], sym < 144 ? 8 : 9);
                    continue;
                }
                this.writeBits(FIXED_LIT_CODE[sym], sym < 280 ? 7 : 8);
                int eLenNum = LENGTH_ENUM[sym - 257];
                if (eLenNum > 0) {
                    this.writeBits(val >>> 9 & 0x1F, eLenNum);
                }
                int dist = val >>> 14 & 0x1F;
                this.writeBits(FIXED_DIST_CODE[dist], 5);
                int eDistNum = DIST_ENUM[dist];
                if (eDistNum <= 0) continue;
                this.writeBits(val >>> 19, eDistNum);
            }
            this.writeBits(FIXED_LIT_CODE[256], 7);
        } else {
            int i;
            int[] litCode = huff.getLitCode();
            int[] litCodeLen = huff.getLitCodeLen();
            int[] distCode = huff.getDistCode();
            int[] distCodeLen = huff.getDistCodeLen();
            int[] compTrees = huff.getCompTrees();
            int compTreesLen = compTrees.length;
            int[] ctCode = huff.getCTCode();
            int[] ctCodeLen = huff.getCTCodeLen();
            int[] permCT = huff.getPermCT();
            int permCTLen = permCT.length;
            this.writeBits(fin ? 5 : 4, 3);
            this.writeBits(litCode.length - 257, 5);
            this.writeBits(distCode.length - 1, 5);
            this.writeBits(permCTLen - 4, 4);
            for (i = 0; i < permCTLen; ++i) {
                this.writeBits(permCT[i], 3);
            }
            block9: for (i = 0; i < compTreesLen; ++i) {
                int ebits;
                int v = compTrees[i];
                int s = v & 0x1F;
                this.writeBits(ctCode[s], ctCodeLen[s]);
                switch (s) {
                    case 16: {
                        ebits = 2;
                        break;
                    }
                    case 17: {
                        ebits = 3;
                        break;
                    }
                    case 18: {
                        ebits = 7;
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                this.writeBits(v >>> 5, ebits);
            }
            for (i = 0; i < sbPtr; ++i) {
                int val = this.buffer[i];
                int sym = val & 0x1FF;
                this.writeBits(litCode[sym], litCodeLen[sym]);
                if (sym < 256) continue;
                int eLenNum = LENGTH_ENUM[sym - 257];
                if (eLenNum > 0) {
                    this.writeBits(val >>> 9 & 0x1F, eLenNum);
                }
                int dist = val >>> 14 & 0x1F;
                this.writeBits(distCode[dist], distCodeLen[dist]);
                int eDistNum = DIST_ENUM[dist];
                if (eDistNum <= 0) continue;
                this.writeBits(val >>> 19, eDistNum);
            }
            this.writeBits(litCode[256], litCodeLen[256]);
        }
        this.sendBuffered();
        this.bufferPtr = 0;
        int uLen = this.ucBuffer.length;
        for (uRealLen = this.ucBufferPtr; uRealLen < uDataLen; uRealLen += uLen) {
        }
        if (uDataLen < uRealLen) {
            int tm = uRealLen - uDataLen;
            if (tm > 258) {
                throw new Error("too much data: " + tm);
            }
            if (tm <= this.ucBufferPtr) {
                System.arraycopy(this.ucBuffer, this.ucBufferPtr - tm, this.ucBuffer, 0, tm);
            } else {
                int fpl = tm - this.ucBufferPtr;
                System.arraycopy(this.ucBuffer, 0, this.ucBuffer, fpl, this.ucBufferPtr);
                System.arraycopy(this.ucBuffer, uLen - fpl, this.ucBuffer, 0, fpl);
            }
        }
        this.ucBufferPtr = uRealLen - uDataLen;
    }

    private void writeEmptySH(boolean fin) throws IOException {
        this.writeBits(fin ? 3 : 2, 10);
    }

    private void writeEmptyUD(boolean fin, boolean wd) throws IOException {
        this.writeBits(fin ? 1 : 0, 3);
        if (this.outPtr > 0) {
            this.writeBits(0, 8 - this.outPtr);
        }
        if (wd) {
            this.writeBits(-65536, 32);
        }
    }

    public void terminate() throws IOException {
        this.prepareFlush();
        if (this.bufferPtr == 0) {
            this.writeEmptySH(true);
        } else {
            this.endBlock(true, this.bufferPtr);
        }
        if (this.outPtr > 0) {
            this.writeBits(0, 8 - this.outPtr);
        }
        this.sendBuffered();
    }

    public void flushSync(boolean withData) throws IOException {
        this.prepareFlush();
        if (this.bufferPtr != 0) {
            this.endBlock(false, this.bufferPtr);
        }
        this.writeEmptyUD(false, withData);
        this.sendBuffered();
    }

    static int[] makeCanonicalHuff(int[] codeLen, int maxCodeLen) {
        int alphLen = codeLen.length;
        int actualAlphLen = 0;
        int[] blCount = new int[maxCodeLen + 1];
        for (int n = 0; n < alphLen; ++n) {
            int len = codeLen[n];
            if (len < 0 || len > maxCodeLen) {
                return null;
            }
            if (len <= 0) continue;
            actualAlphLen = n + 1;
            int n2 = len;
            blCount[n2] = blCount[n2] + 1;
        }
        int[] nextCode = new int[maxCodeLen + 1];
        int codeVal = 0;
        for (int bits = 1; bits <= maxCodeLen; ++bits) {
            nextCode[bits] = codeVal = codeVal + blCount[bits - 1] << 1;
        }
        int[] code = new int[actualAlphLen];
        for (int n = 0; n < actualAlphLen; ++n) {
            int len = codeLen[n];
            if (len == 0) continue;
            int w = nextCode[len];
            if (w >= 1 << len) {
                return null;
            }
            code[n] = Deflater.reverse(w, len);
            nextCode[len] = w + 1;
        }
        return code;
    }

    private static int reverse(int cc, int q) {
        int v = 0;
        while (q-- > 0) {
            v <<= 1;
            if ((cc & 1) != 0) {
                ++v;
            }
            cc >>>= 1;
        }
        return v;
    }

    static {
        int i;
        int[] fixedLitCodeLen = new int[288];
        for (i = 0; i < 144; ++i) {
            fixedLitCodeLen[i] = 8;
        }
        for (i = 144; i < 256; ++i) {
            fixedLitCodeLen[i] = 9;
        }
        for (i = 256; i < 280; ++i) {
            fixedLitCodeLen[i] = 7;
        }
        for (i = 280; i < 288; ++i) {
            fixedLitCodeLen[i] = 8;
        }
        FIXED_LIT_CODE = Deflater.makeCanonicalHuff(fixedLitCodeLen, 15);
        int[] fixedDistCodeLen = new int[32];
        for (i = 0; i < 32; ++i) {
            fixedDistCodeLen[i] = 5;
        }
        FIXED_DIST_CODE = Deflater.makeCanonicalHuff(fixedDistCodeLen, 15);
        LENGTH_ENUM = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
        LENGTH = new int[29];
        Deflater.LENGTH[0] = 3;
        int l = 3;
        for (i = 1; i < 28; ++i) {
            Deflater.LENGTH[i] = l += 1 << LENGTH_ENUM[i - 1];
        }
        Deflater.LENGTH[28] = 258;
        DIST_ENUM = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
        DIST = new int[30];
        Deflater.DIST[0] = 1;
        int d = 1;
        for (i = 1; i < 30; ++i) {
            Deflater.DIST[i] = d += 1 << DIST_ENUM[i - 1];
        }
        PERM_CT = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    }

    private static class Huff {
        private int[] litCode;
        private int[] litCodeLen;
        private int[] distCode;
        private int[] distCodeLen;
        private int[] compTrees;
        private int[] ctCode;
        private int[] ctCodeLen;
        private int[] permCT;
        private int csD = 17;
        private int csF = 3;

        private Huff(int[] freqLit, int[] freqDist) {
            int f;
            int i;
            this.litCodeLen = Deflater.makeHuffmanCodes(freqLit, 15);
            this.distCodeLen = Deflater.makeHuffmanCodes(freqDist, 15);
            for (i = 0; i < this.litCodeLen.length; ++i) {
                f = freqLit[i];
                int elen = i >= 257 ? LENGTH_ENUM[i - 257] : 0;
                this.csD += (this.litCodeLen[i] + elen) * f;
                int fcl = i < 256 ? (i < 144 ? 8 : 9) : (i < 280 ? 7 : 8);
                this.csF += (fcl + elen) * f;
            }
            for (i = 0; i < this.distCodeLen.length; ++i) {
                f = freqDist[i];
                int edist = DIST_ENUM[i];
                this.csD += (this.distCodeLen[i] + edist) * f;
                this.csF += (5 + edist) * f;
            }
            this.litCode = Deflater.makeCanonicalHuff(this.litCodeLen, 15);
            this.distCode = Deflater.makeCanonicalHuff(this.distCodeLen, 15);
            if (this.distCode.length == 0) {
                this.distCode = new int[1];
            }
            int[] freqCT = new int[19];
            this.compTrees = Deflater.compressTrees(this.litCodeLen, this.litCode.length, this.distCodeLen, this.distCode.length, freqCT);
            this.ctCodeLen = Deflater.makeHuffmanCodes(freqCT, 7);
            this.ctCode = Deflater.makeCanonicalHuff(this.ctCodeLen, 7);
            for (int i2 = 0; i2 < 19; ++i2) {
                int ccl = this.ctCodeLen[i2];
                switch (i2) {
                    case 16: {
                        ccl += 2;
                        break;
                    }
                    case 17: {
                        ccl += 3;
                        break;
                    }
                    case 18: {
                        ccl += 7;
                    }
                }
                this.csD += freqCT[i2] * ccl;
            }
            int[] permCTtmp = new int[19];
            int permCTLen = 0;
            for (int i3 = 0; i3 < 19; ++i3) {
                int len = this.ctCodeLen[PERM_CT[i3]];
                if (len > 0) {
                    permCTLen = i3 + 1;
                }
                permCTtmp[i3] = len;
            }
            this.permCT = new int[permCTLen];
            System.arraycopy(permCTtmp, 0, this.permCT, 0, permCTLen);
            this.csD += 3 * permCTLen;
        }

        private int[] getLitCode() {
            return this.litCode;
        }

        private int[] getLitCodeLen() {
            return this.litCodeLen;
        }

        private int[] getDistCode() {
            return this.distCode;
        }

        private int[] getDistCodeLen() {
            return this.distCodeLen;
        }

        private int[] getCompTrees() {
            return this.compTrees;
        }

        private int[] getCTCode() {
            return this.ctCode;
        }

        private int[] getCTCodeLen() {
            return this.ctCodeLen;
        }

        private int[] getPermCT() {
            return this.permCT;
        }

        private int getDynamicBitLength() {
            return this.csD;
        }

        private int getFixedBitLength() {
            return this.csF;
        }
    }
}

