/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.GwtResponseWriterImpl;
import org.atmosphere.gwt.server.impl.HTTPRequestResponseWriter;

public class OperaEventSourceResponseWriter
extends GwtResponseWriterImpl {
    public OperaEventSourceResponseWriter(GwtAtmosphereResourceImpl resource, SerializationPolicy serializationPolicy, ClientOracle clientOracle) {
        super(resource, serializationPolicy, clientOracle);
    }

    @Override
    public void initiate() throws IOException {
        this.getResponse().setContentType("application/x-dom-event-stream");
        super.initiate();
        this.writer.append("Event: c\ndata: c").append(String.valueOf(this.resource.getHeartBeatInterval())).append(':').append(String.valueOf(this.connectionID)).append("\n\n");
    }

    @Override
    protected void doSendError(int statusCode, String message) throws IOException {
        this.getResponse().setContentType("application/x-dom-event-stream");
        this.writer.append("Event: c\ndata: e").append(String.valueOf(statusCode));
        if (message != null) {
            this.writer.append(' ').append(HTTPRequestResponseWriter.escape(message));
        }
        this.writer.append("\n\n");
    }

    @Override
    protected void doSuspend() throws IOException {
    }

    @Override
    protected void doWrite(List<? extends Serializable> messages) throws IOException {
        for (Serializable serializable : messages) {
            char event;
            CharSequence string;
            if (serializable instanceof CharSequence) {
                string = HTTPRequestResponseWriter.escape((CharSequence)((Object)serializable));
                event = 's';
            } else {
                string = this.serialize(serializable);
                event = 'o';
            }
            this.writer.append("Event: ").append(event).append('\n');
            this.writer.append("data: ").append(string).append("\n\n");
        }
    }

    @Override
    protected void doHeartbeat() throws IOException {
        this.writer.append("Event: c\ndata: h\n\n");
    }

    @Override
    public void doTerminate() throws IOException {
        this.writer.append("Event: c\ndata: d\n\n");
    }
}

