/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.atmosphere.gwt.server.impl.CountOutputStream;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.GwtResponseWriterImpl;

public abstract class ManagedStreamResponseWriter
extends GwtResponseWriterImpl {
    private CountOutputStream countOutputStream;
    private boolean refresh;
    protected Integer length;
    protected final boolean chrome;

    public ManagedStreamResponseWriter(GwtAtmosphereResourceImpl resource, SerializationPolicy serializationPolicy, ClientOracle clientOracle) {
        super(resource, serializationPolicy, clientOracle);
        String userAgent = resource.getAtmosphereResource().getRequest().getHeader("User-Agent");
        this.chrome = userAgent != null && userAgent.contains("Chrome");
    }

    @Override
    protected OutputStream getOutputStream(OutputStream outputStream) {
        this.countOutputStream = new CountOutputStream(outputStream);
        return this.countOutputStream;
    }

    @Override
    protected void doSuspend() throws IOException {
        String paddingParameter = this.getRequest().getParameter("padding");
        int paddingRequired = paddingParameter != null ? Integer.parseInt(paddingParameter) : this.getPaddingRequired();
        String lengthParameter = this.getRequest().getParameter("length");
        if (lengthParameter != null) {
            this.length = Integer.parseInt(lengthParameter);
        }
        if (paddingRequired > 0) {
            CharSequence padding;
            this.countOutputStream.setIgnoreFlush(true);
            this.writer.flush();
            int written = this.countOutputStream.getCount();
            if (paddingRequired > written && (padding = this.getPadding(paddingRequired - written)) != null) {
                this.writer.append(padding);
            }
            this.countOutputStream.setIgnoreFlush(false);
        }
    }

    @Override
    public synchronized void write(List<? extends Serializable> messages, boolean flush) throws IOException {
        super.write(messages, flush);
        this.checkLength();
    }

    @Override
    public synchronized void heartbeat() throws IOException {
        super.heartbeat();
        this.checkLength();
    }

    private void checkLength() throws IOException {
        int count = this.countOutputStream.getCount();
        if (this.chrome) {
            count = 2 * count;
        }
        if (!this.refresh && this.isOverRefreshLength(count)) {
            this.refresh = true;
            this.doRefresh();
        }
    }

    protected abstract void doRefresh() throws IOException;

    protected abstract int getPaddingRequired();

    protected abstract CharSequence getPadding(int var1);

    protected abstract boolean isOverRefreshLength(int var1);
}

