/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.atmosphere.gwt.server.impl.GwtAtmosphereResourceImpl;
import org.atmosphere.gwt.server.impl.ManagedStreamResponseWriter;

public abstract class StreamingProtocolResponseWriter
extends ManagedStreamResponseWriter {
    private static final int MAX_PADDING_REQUIRED = 2048;
    private static final String PADDING_STRING;

    public StreamingProtocolResponseWriter(GwtAtmosphereResourceImpl resource, SerializationPolicy serializationPolicy, ClientOracle clientOracle) {
        super(resource, serializationPolicy, clientOracle);
    }

    abstract String getContentType();

    @Override
    public void initiate() throws IOException {
        this.getResponse().setContentType(this.getContentType());
        String origin = this.getRequest().getHeader("Origin");
        if (origin != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Origin: " + origin);
            }
            this.getResponse().setHeader("Access-Control-Allow-Origin", origin);
        }
        super.initiate();
        this.writer.append('!').append(String.valueOf(this.resource.getHeartBeatInterval())).append(':');
        this.writer.append(String.valueOf(this.connectionID)).append('\n');
    }

    static CharSequence escape(CharSequence string) {
        int i;
        int length = string != null ? string.length() : 0;
        block7: for (i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\n': 
                case '\\': {
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        if (i == length) {
            return string;
        }
        StringBuilder str = new StringBuilder(string.length() * 2);
        str.append(string, 0, i);
        while (i < length) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\\': {
                    str.append("\\\\");
                    break;
                }
                case '\n': {
                    str.append("\\n");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str;
    }

    @Override
    protected CharSequence getPadding(int padding) {
        if (padding > PADDING_STRING.length() - 1) {
            StringBuilder result = new StringBuilder(padding);
            while (padding > 0) {
                if (padding > PADDING_STRING.length() - 1) {
                    result.append(PADDING_STRING);
                    padding -= PADDING_STRING.length() - 1;
                    continue;
                }
                result.append(PADDING_STRING.substring(PADDING_STRING.length() - 1 - padding));
                padding = 0;
            }
            return result.toString();
        }
        return PADDING_STRING.substring(PADDING_STRING.length() - padding - 1);
    }

    @Override
    protected void doSendError(int statusCode, String message) throws IOException {
        this.getResponse().setStatus(statusCode);
        if (message != null) {
            this.writer.append(message);
        }
    }

    @Override
    protected void doWrite(List<? extends Serializable> messages) throws IOException {
        for (Serializable serializable : messages) {
            CharSequence string;
            if (serializable instanceof CharSequence) {
                string = StreamingProtocolResponseWriter.escape((CharSequence)((Object)serializable));
                if (string == serializable) {
                    this.writer.append('|');
                } else {
                    this.writer.append(']');
                }
            } else {
                string = this.serialize(serializable);
            }
            this.writer.append(string).append('\n');
        }
    }

    @Override
    protected boolean isOverRefreshLength(int written) {
        if (this.length != null) {
            return written > this.length;
        }
        return written > 0x500000;
    }

    @Override
    protected void doHeartbeat() throws IOException {
        this.writer.append("#\n");
    }

    @Override
    protected void doTerminate() throws IOException {
        this.writer.append("?\n");
    }

    @Override
    protected void doRefresh() throws IOException {
        this.writer.append("@\n");
    }

    static {
        char[] padding = new char[2049];
        for (int i = 0; i < padding.length - 1; ++i) {
            padding[i] = 42;
        }
        padding[padding.length - 1] = 10;
        PADDING_STRING = new String(padding);
    }
}

