/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.deflate;

import java.io.IOException;
import java.io.OutputStream;
import org.atmosphere.gwt.server.deflate.Deflater;

public class DeflaterOutputStream
extends OutputStream {
    private Deflater deflater;

    public DeflaterOutputStream(OutputStream out) throws IOException {
        this(out, 3);
    }

    public DeflaterOutputStream(OutputStream out, int level) throws IOException {
        this.deflater = new Deflater(level);
        this.deflater.setOut(out);
    }

    @Override
    public void close() throws IOException {
        this.deflater.terminate();
        this.deflater.getOut().close();
    }

    @Override
    public void flush() throws IOException {
        this.deflater.flushSync(true);
        this.deflater.getOut().flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.deflater.process(buf, off, len);
    }
}

