/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live;

import java.io.Serializable;
import org.asteriskjava.util.AstUtil;

public class CallerId
implements Serializable {
    private static final long serialVersionUID = 6498024163374551005L;
    private final String name;
    private final String number;

    public CallerId(String name, String number) {
        this.name = AstUtil.isNull(name) ? null : name;
        this.number = AstUtil.isNull(number) ? null : number;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public static CallerId valueOf(String s) {
        String[] parsedCallerId = AstUtil.parseCallerId(s);
        return new CallerId(parsedCallerId[0], parsedCallerId[1]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("\"");
            sb.append(this.name);
            sb.append("\"");
            if (this.number != null) {
                sb.append(" ");
            }
        }
        if (this.number != null) {
            sb.append("<");
            sb.append(this.number);
            sb.append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallerId callerId = (CallerId)o;
        if (this.name != null ? !this.name.equals(callerId.name) : callerId.name != null) {
            return false;
        }
        return !(this.number != null ? !this.number.equals(callerId.number) : callerId.number != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.number != null ? this.number.hashCode() : 0);
        return result;
    }
}

