/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.internal;

import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;

public final class Maps {
    private static final Maps INSTANCE = new Maps();
    private Failures failures = Failures.instance();

    private Maps() {
    }

    public static Maps instance() {
        return INSTANCE;
    }

    public <K, V> void assertContainsAnyOf(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        Maps.failIfNull(entries);
        this.assertNotNull(info, actual);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        for (Tuple2<K, V> entry : entries) {
            if (!this.containsEntry(actual, entry)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf(actual, entries));
    }

    public <K, V> void assertContains(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        Maps.failIfNull(entries);
        this.assertNotNull(info, actual);
        if (actual.isEmpty() && entries.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        Set notFound = (Set)Array.of((Object[])entries).foldLeft((Object)HashSet.empty(), (set, tuple) -> {
            if (actual.contains(tuple)) {
                return set;
            }
            return set.add(tuple);
        });
        if (!notFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContain.shouldContain(actual, entries, (Object)notFound));
        }
    }

    public <K, V> void assertDoesNotContain(AssertionInfo info, Map<K, V> actual, Tuple2<K, V>[] entries) {
        Maps.failIfNullOrEmpty(entries);
        this.assertNotNull(info, actual);
        CommonValidations.failIfEmptySinceActualIsNotEmpty((Object[])entries);
        Set found = (Set)Array.of((Object[])entries).foldLeft((Object)HashSet.empty(), (set, tuple) -> {
            if (actual.contains(tuple)) {
                return set.add(tuple);
            }
            return set;
        });
        if (!found.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, entries, (Object)found));
        }
    }

    private <K, V> boolean containsEntry(Map<K, V> actual, Tuple2<? extends K, ? extends V> entry) {
        Preconditions.checkNotNull(entry, (String)"Entries to look for should not be null");
        return actual.containsKey(entry._1) && Objects.areEqual((Object)actual.get(entry._1).get(), (Object)entry._2);
    }

    private static <K, V> void failIfEmpty(Tuple2<? extends K, ? extends V>[] entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (String)"The array of entries to look for should not be empty", (Object[])new Object[0]);
    }

    private static <K, V> void failIfNullOrEmpty(Tuple2<? extends K, ? extends V>[] entries) {
        Maps.failIfNull(entries);
        Maps.failIfEmpty(entries);
    }

    private static <K, V> void failIfNull(Tuple2<? extends K, ? extends V>[] entries) {
        Preconditions.checkNotNull(entries, (String)"The array of entries to look for should not be null");
    }

    private void assertNotNull(AssertionInfo info, Map<?, ?> actual) {
        org.assertj.core.internal.Objects.instance().assertNotNull(info, actual);
    }
}

