/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Validation;
import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.ValidationShouldBeInvalid;
import org.assertj.vavr.api.ValidationShouldBeValid;
import org.assertj.vavr.api.ValidationShouldContain;
import org.assertj.vavr.api.ValidationShouldContainInstanceOf;

abstract class AbstractValidationAssert<SELF extends AbstractValidationAssert<SELF, INVALID, VALID>, INVALID, VALID>
extends AbstractAssert<SELF, Validation<INVALID, VALID>> {
    private ComparisonStrategy validationValueComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractValidationAssert(Validation<INVALID, VALID> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isInvalid() {
        this.assertIsInvalid();
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF isValid() {
        this.assertIsValid();
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsValid(VALID expectedValue) {
        this.assertIsValid();
        if (!this.validationValueComparisonStrategy.areEqual(((Validation)this.actual).get(), expectedValue)) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContain.shouldContainValid((Validation)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsInvalid(INVALID expectedErrorValue) {
        this.assertIsInvalid();
        this.checkNotNull(expectedErrorValue);
        if (!this.validationValueComparisonStrategy.areEqual(((Validation)this.actual).getError(), expectedErrorValue)) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContain.shouldContainInvalid((Validation)this.actual, expectedErrorValue));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsValidSame(VALID expectedValue) {
        this.assertIsValid();
        if (((Validation)this.actual).get() != expectedValue) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContain.shouldContainValidSame((Validation)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsInvalidSame(VALID expectedErrorValue) {
        this.assertIsInvalid();
        this.checkNotNull(expectedErrorValue);
        if (((Validation)this.actual).getError() != expectedErrorValue) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContain.shouldContainInvalidSame((Validation)this.actual, expectedErrorValue));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsValidInstanceOf(Class<?> clazz) {
        this.assertIsValid();
        if (!clazz.isInstance(((Validation)this.actual).get())) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContainInstanceOf.shouldContainValidInstanceOf(this.actual, clazz));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    public SELF containsInvalidInstanceOf(Class<?> clazz) {
        this.assertIsInvalid();
        if (!clazz.isInstance(((Validation)this.actual).getError())) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldContainInstanceOf.shouldContainInvalidInstanceOf(this.actual, clazz));
        }
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingValueComparator(Comparator<?> customComparator) {
        this.validationValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingFieldByFieldValueComparator() {
        return this.usingValueComparator((Comparator<?>)new FieldByFieldComparator());
    }

    @CheckReturnValue
    public SELF usingDefaultRightValueComparator() {
        this.validationValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((Object)((AbstractValidationAssert)this.myself));
    }

    private void assertIsInvalid() {
        this.isNotNull();
        if (((Validation)this.actual).isValid()) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldBeInvalid.shouldBeInvalid((Validation)this.actual));
        }
    }

    private void assertIsValid() {
        this.isNotNull();
        if (((Validation)this.actual).isInvalid()) {
            this.throwAssertionError((ErrorMessageFactory)ValidationShouldBeValid.shouldBeValid((Validation)this.actual));
        }
    }

    private void checkNotNull(Object expectedValue) {
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (String)"The expected value should not be <null>.", (Object[])new Object[0]);
    }
}

