/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.matcher.JButtonMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JOptionPaneMessageQuery;
import org.assertj.swing.driver.JOptionPaneMessageTypeQuery;
import org.assertj.swing.driver.JOptionPaneMessageTypes;
import org.assertj.swing.driver.JOptionPaneOptionsQuery;
import org.assertj.swing.driver.JOptionPaneTitleQuery;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JOptionPaneDriver
extends JComponentDriver {
    private static final String MESSAGE_PROPERTY = "message";
    private static final String MESSAGE_TYPE_PROPERTY = "messageType";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String TITLE_PROPERTY = "title";

    public JOptionPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nullable String title) {
        ((TextAssert)TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY))).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY))).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public String title(@Nonnull JOptionPane optionPane) {
        return JOptionPaneTitleQuery.titleOf(optionPane);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nullable Object message) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        if (message instanceof String && actual != null) {
            this.requireMessage(optionPane, (String)message, actual.toString());
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)actual).as(this.messageProperty(optionPane))).isEqualTo(message);
    }

    @RunsInEDT
    private void requireMessage(@Nonnull JOptionPane optionPane, @Nullable String expected, @Nullable String actual) {
        ((TextAssert)TextAssert.verifyThat(actual).as(this.messageProperty(optionPane))).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        String s = actual == null ? null : actual.toString();
        ((TextAssert)TextAssert.verifyThat(s).as(this.messageProperty(optionPane))).matches(pattern);
    }

    private Description messageProperty(@Nonnull JOptionPane optionPane) {
        return JOptionPaneDriver.propertyName(optionPane, MESSAGE_PROPERTY);
    }

    @RunsInEDT
    public void requireOptions(@Nonnull JOptionPane optionPane, @Nonnull Object[] options) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])JOptionPaneOptionsQuery.optionsOf(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, OPTIONS_PROPERTY))).isEqualTo((Object)options);
    }

    @Nonnull
    @RunsInEDT
    public JButton okButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.okButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.cancelButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton yesButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.yesButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton noButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.noButtonText");
    }

    @Nonnull
    @RunsInEDT
    private JButton buttonWithTextFromUIManager(@Nonnull JOptionPane optionPane, @Nonnull String key) {
        return this.buttonWithText(optionPane, (String)Preconditions.checkNotNull((Object)UIManager.getString(key)));
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nullable String text) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(text).andShowing());
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(pattern).andShowing());
    }

    @RunsInEDT
    public void requireErrorMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 0);
    }

    @RunsInEDT
    public void requireInformationMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 1);
    }

    @RunsInEDT
    public void requireWarningMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 2);
    }

    @RunsInEDT
    public void requireQuestionMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 3);
    }

    @RunsInEDT
    public void requirePlainMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, -1);
    }

    @RunsInEDT
    private void assertEqualMessageType(@Nonnull JOptionPane optionPane, int expected) {
        String actualType = this.actualMessageTypeAsText(optionPane);
        ((AbstractStringAssert)Assertions.assertThat((String)actualType).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_TYPE_PROPERTY))).isEqualTo((Object)JOptionPaneMessageTypes.messageTypeAsText(expected));
    }

    @RunsInEDT
    private String actualMessageTypeAsText(@Nonnull JOptionPane optionPane) {
        return JOptionPaneMessageTypes.messageTypeAsText(JOptionPaneMessageTypeQuery.messageTypeOf(optionPane));
    }
}

