/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.guava.error.MultisetShouldContainAtLeastTimes;
import org.assertj.guava.error.MultisetShouldContainAtMostTimes;
import org.assertj.guava.error.MultisetShouldContainTimes;

public class MultisetAssert<T>
extends AbstractIterableAssert<MultisetAssert<T>, Multiset<? extends T>, T, ObjectAssert<T>> {
    protected MultisetAssert(Multiset<? extends T> actual) {
        super(actual, MultisetAssert.class);
    }

    public MultisetAssert<T> contains(int expectedCount, T expected) {
        this.isNotNull();
        Preconditions.checkArgument((expectedCount >= 0 ? 1 : 0) != 0, (Object)"The expected count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount != expectedCount) {
            throw this.assertionError(MultisetShouldContainTimes.shouldContainTimes((Multiset)this.actual, expected, expectedCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    public MultisetAssert<T> containsAtLeast(int minimumCount, T expected) {
        this.isNotNull();
        Preconditions.checkArgument((minimumCount >= 0 ? 1 : 0) != 0, (Object)"The minimum count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount < minimumCount) {
            throw this.assertionError(MultisetShouldContainAtLeastTimes.shouldContainAtLeastTimes((Multiset)this.actual, expected, minimumCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    public MultisetAssert<T> containsAtMost(int maximumCount, T expected) {
        this.isNotNull();
        Preconditions.checkArgument((maximumCount >= 0 ? 1 : 0) != 0, (Object)"The maximum count should not be negative.");
        int actualCount = ((Multiset)this.actual).count(expected);
        if (actualCount > maximumCount) {
            throw this.assertionError(MultisetShouldContainAtMostTimes.shouldContainAtMostTimes((Multiset)this.actual, expected, maximumCount, actualCount));
        }
        return (MultisetAssert)this.myself;
    }

    protected ObjectAssert<T> toAssert(T value, String description) {
        return null;
    }

    protected MultisetAssert<T> newAbstractIterableAssert(Iterable<? extends T> iterable) {
        HashMultiset filtered = HashMultiset.create();
        iterable.forEach(arg_0 -> ((Multiset)filtered).add(arg_0));
        return new MultisetAssert<T>(filtered);
    }
}

