/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.ShouldContainKeys;
import org.assertj.guava.error.ShouldContainValues;
import org.assertj.guava.util.ExceptionUtils;

public class MultimapAssert<K, V>
extends AbstractAssert<MultimapAssert<K, V>, Multimap<K, V>> {
    @VisibleForTesting
    Failures failures = Failures.instance();

    protected MultimapAssert(Multimap<K, V> actual) {
        super(actual, MultimapAssert.class);
    }

    protected Multimap<K, V> getActual() {
        return (Multimap)this.actual;
    }

    public MultimapAssert<K, V> containsKeys(K ... keys) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys == null, "The keys to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys.length == 0, "The keys to look for should not be empty", new Object[0]);
        LinkedHashSet keysNotFound = Sets.newLinkedHashSet();
        for (K key : keys) {
            if (((Multimap)this.actual).containsKey(key)) continue;
            keysNotFound.add(key);
        }
        if (!keysNotFound.isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldContainKeys.shouldContainKeys(this.actual, keys, keysNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    public MultimapAssert<K, V> contains(MapEntry ... entries) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries == null, "The entries to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries.length == 0, "The entries to look for should not be empty", new Object[0]);
        ArrayList entriesNotFound = Lists.newArrayList();
        for (MapEntry entry : entries) {
            if (((Multimap)this.actual).containsEntry(entry.key, entry.value)) continue;
            entriesNotFound.add(entry);
        }
        if (!entriesNotFound.isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldContain.shouldContain((Object)this.actual, (Object)entries, (Object)entriesNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    public MultimapAssert<K, V> containsValues(V ... values) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values == null, "The values to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values.length == 0, "The values to look for should not be empty", new Object[0]);
        LinkedHashSet valuesNotFound = Sets.newLinkedHashSet();
        for (V value : values) {
            if (((Multimap)this.actual).containsValue(value)) continue;
            valuesNotFound.add(value);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldContainValues.shouldContainValues(this.actual, values, valuesNotFound));
        }
        return (MultimapAssert)this.myself;
    }

    public void isEmpty() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Multimap)this.actual).isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public void isNotEmpty() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Multimap)this.actual).isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public MultimapAssert<K, V> hasSize(int expectedSize) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        int sizeOfActual = ((Multimap)this.actual).size();
        if (sizeOfActual == expectedSize) {
            return this;
        }
        throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSize.shouldHaveSize((Object)this.actual, (int)sizeOfActual, (int)expectedSize));
    }
}

