/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.Visibility;
import org.assertj.assertions.generator.util.ClassUtil;

public class FieldDescription
extends DataDescription
implements Comparable<FieldDescription> {
    public FieldDescription(Field field, TypeToken<?> owningType) {
        this(field, Visibility.PUBLIC, owningType);
    }

    public FieldDescription(Field field, Visibility visibility, TypeToken<?> owningType) {
        super(ClassUtil.propertyNameOf(field), field, visibility, owningType.resolveType(field.getGenericType()), owningType);
    }

    @Override
    public int compareTo(FieldDescription other) {
        return super.compareTo(other);
    }

    @Override
    public Field getOriginalMember() {
        return (Field)super.getOriginalMember();
    }

    @Override
    public String toString() {
        return "FieldDescription[originalMember=" + String.valueOf(this.originalMember) + ", valueType=" + String.valueOf(this.valueType) + ", visibility=" + String.valueOf((Object)this.visibility) + "]";
    }

    @Override
    public boolean isPredicate() {
        return ClassUtil.isBoolean(this.valueType);
    }

    @Override
    public String getPredicate() {
        return this.hasNegativePredicate() ? this.originalMember.getName() : "is" + StringUtils.capitalize((String)this.originalMember.getName());
    }

    @Override
    public String getNegativePredicate() {
        return !this.hasNegativePredicate() ? "isNot" + StringUtils.capitalize((String)this.originalMember.getName()) : super.getNegativePredicate();
    }
}

