/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.description.Visibility;
import org.assertj.assertions.generator.util.ClassUtil;
import org.assertj.assertions.generator.util.StringUtil;

public abstract class DataDescription {
    private static final Map<String, String> PREDICATE_PREFIXES_FOR_JAVADOC = new ImmutableMap.Builder().put((Object)"is", (Object)"is").put((Object)"isNot", (Object)"is not").put((Object)"was", (Object)"was").put((Object)"wasNot", (Object)"was not").put((Object)"can", (Object)"can").put((Object)"canBe", (Object)"can be").put((Object)"cannot", (Object)"cannot").put((Object)"cannotBe", (Object)"cannot be").put((Object)"should", (Object)"should").put((Object)"shouldBe", (Object)"should be").put((Object)"shouldNot", (Object)"should not").put((Object)"shouldNotBe", (Object)"should not be").put((Object)"has", (Object)"has").put((Object)"doesNotHave", (Object)"does not have").put((Object)"will", (Object)"will").put((Object)"willBe", (Object)"will be").put((Object)"willNot", (Object)"will not").put((Object)"willNotBe", (Object)"will not be").build();
    private static final Map<String, String> PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1 = new ImmutableMap.Builder().put((Object)"is", (Object)"is").put((Object)"isNot", (Object)"is not").put((Object)"was", (Object)"was").put((Object)"wasNot", (Object)"was not").put((Object)"can", (Object)"can").put((Object)"canBe", (Object)"can be").put((Object)"cannot", (Object)"cannot").put((Object)"cannotBe", (Object)"cannot be").put((Object)"should", (Object)"should").put((Object)"shouldBe", (Object)"should be").put((Object)"shouldNot", (Object)"should not").put((Object)"shouldNotBe", (Object)"should not be").put((Object)"has", (Object)"has").put((Object)"doesNotHave", (Object)"does not have").put((Object)"will", (Object)"will").put((Object)"willBe", (Object)"will be").put((Object)"willNot", (Object)"will not").put((Object)"willNotBe", (Object)"will not be").build();
    private static final Map<String, String> PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2 = new ImmutableMap.Builder().put((Object)"is", (Object)"is not").put((Object)"isNot", (Object)"is").put((Object)"was", (Object)"was not").put((Object)"wasNot", (Object)"was").put((Object)"can", (Object)"cannot").put((Object)"canBe", (Object)"is not").put((Object)"cannot", (Object)"can").put((Object)"cannotBe", (Object)"is not").put((Object)"should", (Object)"should not").put((Object)"shouldBe", (Object)"is not").put((Object)"shouldNot", (Object)"should").put((Object)"shouldNotBe", (Object)"should be").put((Object)"has", (Object)"does not have").put((Object)"doesNotHave", (Object)"has").put((Object)"will", (Object)"will not").put((Object)"willBe", (Object)"will not be").put((Object)"willNot", (Object)"will").put((Object)"willNotBe", (Object)"will be").build();
    private static final Ordering<String> BY_BIGGER_LENGTH_ORDERING = new Ordering<String>(){

        public int compare(String left, String right) {
            return -Ints.compare((int)left.length(), (int)right.length());
        }
    };
    private final String name;
    final Member originalMember;
    final TypeToken<?> valueType;
    private final TypeToken<?> owningType;
    protected final Visibility visibility;

    DataDescription(String name, Member originalMember, Visibility visibility, TypeToken<?> type, TypeToken<?> owningType) {
        this.name = name;
        this.originalMember = originalMember;
        this.visibility = visibility;
        this.valueType = type;
        this.owningType = owningType;
    }

    public String getName() {
        return this.name;
    }

    public Member getOriginalMember() {
        return this.originalMember;
    }

    TypeToken<?> getValueType() {
        return this.valueType;
    }

    public String getTypeName() {
        String typeName = this.getFullyQualifiedTypeName();
        return this.removeOwningTypePackageNameIn(typeName);
    }

    public String getFullyQualifiedTypeName() {
        return ClassUtil.getTypeDeclaration(this.valueType);
    }

    public boolean isIterableType() {
        return this.valueType.isSubtypeOf(Iterable.class);
    }

    public boolean isArrayType() {
        return this.valueType.isArray();
    }

    public boolean isPrimitiveType() {
        return this.valueType.isPrimitive();
    }

    public boolean isRealNumberType() {
        TypeToken unwrapped = this.valueType.unwrap();
        return unwrapped.isSubtypeOf(Double.TYPE) || unwrapped.isSubtypeOf(Float.TYPE);
    }

    public boolean isWholeNumberType() {
        TypeToken unwrapped = this.valueType.unwrap();
        return unwrapped.isSubtypeOf(Integer.TYPE) || unwrapped.isSubtypeOf(Long.TYPE) || unwrapped.isSubtypeOf(Byte.TYPE) || unwrapped.isSubtypeOf(Short.TYPE);
    }

    public boolean isCharType() {
        TypeToken unwrapped = this.valueType.unwrap();
        return unwrapped.isSubtypeOf(Character.TYPE);
    }

    public boolean isPrimitiveWrapperType() {
        return Primitives.isWrapperType((Class)this.valueType.getRawType());
    }

    public abstract boolean isPredicate();

    public String getPredicate() {
        return this.originalMember.getName();
    }

    public String getNegativePredicate() {
        return ClassUtil.getNegativePredicateFor(this.originalMember.getName());
    }

    boolean hasNegativePredicate() {
        return ClassUtil.getNegativePredicateFor(this.originalMember.getName()) != null;
    }

    public String getElementTypeName() {
        String elementTypeName = null;
        if (this.valueType.isArray()) {
            elementTypeName = ClassUtil.getTypeDeclaration(this.valueType.getComponentType());
        } else if (this.valueType.isSubtypeOf(Iterable.class)) {
            TypeToken componentType = this.valueType.resolveType(Iterable.class.getTypeParameters()[0]);
            elementTypeName = ClassUtil.getTypeDeclaration(componentType);
            elementTypeName = RegExUtils.removeAll((String)elementTypeName, (String)"\\? extends").trim();
        }
        return this.removeOwningTypePackageNameIn(elementTypeName);
    }

    public String getElementAssertTypeName() {
        String packageName = this.owningTypePackageName();
        TypeToken elementType = this.valueType.getComponentType();
        return elementType == null ? null : ClassUtil.getAssertType(elementType, packageName);
    }

    public String getAssertTypeName(String packageName) {
        return ClassUtil.getAssertType(this.valueType, packageName);
    }

    public String getPredicateForJavadoc() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_JAVADOC.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getNegativePredicateForJavadoc() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_JAVADOC.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getPredicateForErrorMessagePart1() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getPredicateForErrorMessagePart2() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2.get(predicatePrefix);
    }

    public String getNegativePredicateForErrorMessagePart1() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getNegativePredicateForErrorMessagePart2() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2.get(predicatePrefix);
    }

    private String readablePropertyName() {
        ImmutableList prefixesSortedByBiggerLength = BY_BIGGER_LENGTH_ORDERING.immutableSortedCopy(PREDICATE_PREFIXES_FOR_JAVADOC.keySet());
        for (String predicatePrefix : prefixesSortedByBiggerLength) {
            if (!this.originalMember.getName().startsWith(predicatePrefix)) continue;
            String propertyName = StringUtils.removeStart((String)this.originalMember.getName(), (String)predicatePrefix);
            return StringUtil.camelCaseToWords(propertyName);
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataDescription that = (DataDescription)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.originalMember, that.originalMember) && Objects.equals(this.valueType, that.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.originalMember, this.valueType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", valueType=" + String.valueOf(this.valueType) + ", member=" + String.valueOf(this.originalMember) + "]";
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    int compareTo(DataDescription other) {
        int cmp = this.getName().compareTo(other.getName());
        if (cmp == 0) {
            cmp = this.getOriginalMember().getName().compareTo(other.getOriginalMember().getName());
        }
        return cmp;
    }

    private String owningTypePackageName() {
        return ClassUtil.safePackageName(this.owningType);
    }

    private String removeOwningTypePackageNameIn(String value) {
        String owningTypePackageName = this.owningTypePackageName();
        return owningTypePackageName.isEmpty() ? value : RegExUtils.removeAll((String)value, (String)ClassUtil.packageNameRegex(owningTypePackageName));
    }
}

