/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.DataType;
import org.assertj.db.type.lettercase.LetterCase;

public class Request
extends AbstractDbData<Request> {
    private final String request;
    private final Object[] parameters;

    private Request(ConnectionProvider connectionProvider, String request, Object[] parameters, String[] pksName) {
        super(Request.class, DataType.REQUEST, connectionProvider);
        if (request == null) {
            throw new IllegalArgumentException("request can not be null");
        }
        if (pksName != null) {
            super.setPksNameList(new ArrayList<String>(Arrays.asList(pksName)));
        }
        this.request = request;
        this.parameters = parameters;
    }

    private Request() {
        super(Request.class, DataType.REQUEST);
        this.request = null;
        this.parameters = null;
    }

    @Override
    public String getRequest() {
        return this.request;
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            return new Object[0];
        }
        return (Object[])this.parameters.clone();
    }

    private void collectColumnsNameFromResultSet(ResultSet resultSet) throws SQLException {
        LetterCase letterCase = this.getColumnLetterCase();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> columnsNameList = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i);
            columnsNameList.add(letterCase.convert(columnName));
        }
        this.setColumnsNameList(columnsNameList);
        this.controlIfAllThePksNameExistInTheColumns();
    }

    @Override
    protected void loadImpl(Connection connection) throws SQLException {
        if (this.request == null) {
            throw new NullPointerException("request can not be null");
        }
        try (PreparedStatement statement = connection.prepareStatement(this.request);){
            for (int i = 0; i < this.parameters.length; ++i) {
                statement.setObject(i + 1, this.parameters[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                this.collectColumnsNameFromResultSet(resultSet);
                this.collectRowsFromResultSet(resultSet);
            }
        }
    }

    public static class Builder {
        private final ConnectionProvider connectionProvider;
        private final String request;
        private Object[] parameters = new Object[0];
        private String[] pksName = null;

        Builder(ConnectionProvider connectionProvider, String request) {
            this.connectionProvider = connectionProvider;
            this.request = request;
        }

        public Builder parameters(Object ... parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder pksName(String ... pksName) {
            this.pksName = pksName;
            return this;
        }

        public Request build() {
            return new Request(this.connectionProvider, this.request, this.parameters, this.pksName);
        }
    }
}

