/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import java.util.List;
import org.assertj.db.navigation.Position;
import org.assertj.db.navigation.element.ColumnElement;
import org.assertj.db.output.AbstractColumnValueOutputter;
import org.assertj.db.output.AbstractDbOutputter;
import org.assertj.db.output.AbstractRowOutputter;
import org.assertj.db.output.AbstractRowValueOutputter;
import org.assertj.db.output.AbstractSubOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.Column;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public abstract class AbstractColumnOutputter<D extends AbstractDbData<D>, A extends AbstractDbOutputter<D, A, C, CV, R, RV>, C extends AbstractColumnOutputter<D, A, C, CV, R, RV>, CV extends AbstractColumnValueOutputter<D, A, C, CV, R, RV>, R extends AbstractRowOutputter<D, A, C, CV, R, RV>, RV extends AbstractRowValueOutputter<D, A, C, CV, R, RV>>
extends AbstractSubOutputter<D, A, C, CV, C, CV, R, RV>
implements ColumnElement {
    protected final Position<C, CV, Value> valuePosition;
    private final Column column;

    AbstractColumnOutputter(A originalDbOutputter, Class<C> selfType, Class<CV> valueType, Column column) {
        super(originalDbOutputter, selfType);
        this.column = column;
        this.valuePosition = new Position<C, CV, Value>((AbstractColumnOutputter)selfType.cast(this), valueType){

            @Override
            protected String getDescription(int index) {
                return AbstractColumnOutputter.this.getValueDescription(index);
            }
        };
    }

    @Override
    protected String getValueDescription(int index) {
        return Descriptions.getColumnValueDescription(this.info, index);
    }

    @Override
    protected Position<C, CV, Value> getValuePosition() {
        return this.valuePosition;
    }

    @Override
    protected List<Value> getValuesList() {
        return this.column.getValuesList();
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getColumnOutput(this.info, this.column);
    }
}

