/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.navigation;

import java.lang.reflect.Constructor;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.type.DbElement;
import org.assertj.db.util.Proxies;

public abstract class PositionWithPoints<E extends AbstractElement<E>, N extends AbstractElement<N>, D extends DbElement> {
    private final E myself;
    private final Class<N> elementClass;
    private final Class<D> pointClass;
    private final D atStartPoint;
    private final D atEndPoint;
    private N instanceAtStartPoint;
    private N instanceAtEndPoint;

    public PositionWithPoints(E myself, Class<N> elementClass, Class<D> pointClass, D atStartPoint, D atEndPoint) {
        this.myself = myself;
        this.elementClass = elementClass;
        this.pointClass = pointClass;
        this.atStartPoint = atStartPoint;
        this.atEndPoint = atEndPoint;
    }

    public N getInstanceAtStartPoint() {
        if (this.instanceAtStartPoint == null) {
            this.instanceAtStartPoint = this.getInstance(this.atStartPoint);
            ((AbstractElement)this.instanceAtStartPoint).as(this.getDescriptionAtStartPoint(), new Object[0]);
        }
        return this.instanceAtStartPoint;
    }

    public N getInstanceAtEndPoint() {
        if (this.instanceAtEndPoint == null) {
            this.instanceAtEndPoint = this.getInstance(this.atEndPoint);
            ((AbstractElement)this.instanceAtEndPoint).as(this.getDescriptionAtEndPoint(), new Object[0]);
        }
        return this.instanceAtEndPoint;
    }

    protected N getInstance(D element) {
        try {
            Class<?> clazz = Proxies.unProxy(this.myself.getClass());
            Constructor<N> constructor = this.elementClass.getDeclaredConstructor(clazz, this.pointClass);
            return (N)((AbstractElement)constructor.newInstance(this.myself, element));
        }
        catch (Exception e) {
            throw new AssertJDBException(String.format("There is an exception '" + e.getMessage() + "'%n\t in the instantiation of the element " + this.elementClass.getName() + "%n\t on " + this.pointClass + " with " + this.myself.getClass() + ".%n It is normally impossible.%n That means there is a big mistake in the development of AssertJDB.%n Please write an issue for that if you meet this problem.", new Object[0]), new Object[0]);
        }
    }

    protected abstract String getDescriptionAtStartPoint();

    protected abstract String getDescriptionAtEndPoint();
}

