/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.util;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Request;
import org.assertj.db.type.Table;
import org.assertj.db.type.Value;

public class Descriptions {
    private Descriptions() {
    }

    public static String getDescription(Table table) {
        return table.getName() + " table";
    }

    public static String getDescription(Request request) {
        String sql = request.getRequest();
        if (sql.length() > 30) {
            sql = sql.substring(0, 30) + "...";
        }
        return "'" + sql + "' request";
    }

    public static String getDescription(Changes changes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (changes.getTablesList() != null) {
            List<Table> tablesList = changes.getTablesList();
            if (tablesList.size() == 1) {
                Table table = tablesList.get(0);
                stringBuilder.append("Changes on ").append(table.getName()).append(" table");
            } else {
                stringBuilder.append("Changes on tables");
            }
        } else {
            Request request = changes.getRequest();
            if (request != null) {
                String sql = request.getRequest();
                if (sql.length() > 30) {
                    sql = sql.substring(0, 30) + "...";
                }
                stringBuilder.append("Changes on '").append(sql).append("' request");
            } else {
                stringBuilder.append("Changes");
            }
        }
        stringBuilder.append(" of '").append(changes.getConnectionProvider().toString()).append("'");
        return stringBuilder.toString();
    }

    public static String getRowDescription(WritableAssertionInfo info, int index) {
        return "Row at index " + index + " of " + info.descriptionText();
    }

    public static String getRowAtStartPointDescription(WritableAssertionInfo info) {
        return "Row at start point of " + info.descriptionText();
    }

    public static String getRowAtEndPointDescription(WritableAssertionInfo info) {
        return "Row at end point of " + info.descriptionText();
    }

    public static String getColumnDescription(WritableAssertionInfo info, int index, String columnName) {
        return "Column at index " + index + " (column name : " + columnName + ") of " + info.descriptionText();
    }

    public static String getColumnValueDescription(WritableAssertionInfo info, int index) {
        return "Value at index " + index + " of " + info.descriptionText();
    }

    public static String getColumnValueAtStartPointDescription(WritableAssertionInfo info) {
        return "Value at start point of " + info.descriptionText();
    }

    public static String getColumnValueAtEndPointDescription(WritableAssertionInfo info) {
        return "Value at end point of " + info.descriptionText();
    }

    public static String getRowValueDescription(WritableAssertionInfo info, int index, String columnName) {
        return "Value at index " + index + " (column name : " + columnName + ") of " + info.descriptionText();
    }

    private static StringBuilder getStringBuilderAboutChangeTypeAndTableName(ChangeType changeType, String tableName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (changeType != null || tableName != null) {
            stringBuilder.append(" (only");
            if (changeType != null) {
                stringBuilder.append(" ");
                stringBuilder.append(changeType.name().toLowerCase());
            }
            stringBuilder.append(" ");
            stringBuilder.append("changes");
            if (tableName != null) {
                stringBuilder.append(" on ");
                stringBuilder.append(tableName);
                stringBuilder.append(" table");
            }
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    public static String getChangesDescription(WritableAssertionInfo info, ChangeType changeType, String tableName) {
        return info.descriptionText() + Descriptions.getStringBuilderAboutChangeTypeAndTableName(changeType, tableName);
    }

    public static String getChangeDescription(WritableAssertionInfo info, Changes changes, Change change, int index, ChangeType changeType, String tableName) {
        boolean havePksValues;
        StringBuilder stringBuilder = new StringBuilder("Change at index " + index);
        List<Value> pksValueList = change.getPksValueList();
        boolean isAChangeOnATableAmongOtherTables = changes.getTablesList() != null && changes.getTablesList().size() > 1;
        boolean bl = havePksValues = !pksValueList.isEmpty();
        if (isAChangeOnATableAmongOtherTables || havePksValues) {
            stringBuilder.append(" (");
            if (isAChangeOnATableAmongOtherTables) {
                stringBuilder.append("on table : ").append(change.getDataName());
            }
            if (isAChangeOnATableAmongOtherTables && havePksValues) {
                stringBuilder.append(" and ");
            }
            if (havePksValues) {
                ArrayList<Object> objectsList = new ArrayList<Object>();
                for (Value value : pksValueList) {
                    objectsList.add(value.getValue());
                }
                stringBuilder.append("with primary key : ").append(objectsList);
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" of ").append(info.descriptionText());
        stringBuilder.append((CharSequence)Descriptions.getStringBuilderAboutChangeTypeAndTableName(changeType, tableName));
        return stringBuilder.toString();
    }
}

