/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.DataType;
import org.assertj.db.type.SchemaMetadata;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.util.NameComparator;

public class Table
extends AbstractDbData<Table> {
    private String name;
    private List<String> columnsList;
    private String[] columnsToCheck;
    private String[] columnsToExclude;
    private Order[] columnsToOrder;
    private Character startDelimiter = null;
    private Character endDelimiter = null;

    private Table(ConnectionProvider connectionProvider, String name, Character startDelimiter, Character endDelimiter, Order[] columnsToOrder, String[] columnsToCheck, String[] columnsToExclude) {
        super(Table.class, DataType.TABLE, connectionProvider);
        this.setName(name);
        this.setStartDelimiter(startDelimiter);
        this.setEndDelimiter(endDelimiter);
        this.setColumnsToOrder(columnsToOrder);
        this.setColumnsToCheck(columnsToCheck);
        this.setColumnsToExclude(columnsToExclude);
    }

    private Table() {
        super(Table.class, DataType.TABLE);
    }

    public String getName() {
        return this.name;
    }

    private Table setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = name;
        this.setNameFromDb();
        return this;
    }

    private void setNameFromDb() {
        if (this.name != null && this.getConnectionProvider() != null) {
            LetterCase tableLetterCase = this.getTableLetterCase();
            LetterCase columnLetterCase = this.getColumnLetterCase();
            SchemaMetadata metaData = this.getMetaData();
            for (String tableName : metaData.getTablesName()) {
                if (!tableLetterCase.isEqual(tableName, this.name)) continue;
                this.name = tableLetterCase.convert(tableName);
                break;
            }
            this.columnsList = new ArrayList<String>();
            for (String column : metaData.getColumnsName(this.name)) {
                this.columnsList.add(columnLetterCase.convert(column));
            }
        }
    }

    public String[] getColumnsToCheck() {
        if (this.columnsToCheck == null) {
            return null;
        }
        return (String[])this.columnsToCheck.clone();
    }

    private Table setColumnsToCheck(String[] columnsToCheck) {
        if (columnsToCheck == null) {
            this.columnsToCheck = null;
            return this;
        }
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the connectionProvider must be set first", new Object[0]);
        }
        LetterCase letterCase = this.getColumnLetterCase();
        ArrayList<String> columnsToCheckList = new ArrayList<String>();
        for (String column : columnsToCheck) {
            if (column == null) {
                throw new NullPointerException("The name of the column can not be null");
            }
            int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
            if (indexOf == -1) continue;
            columnsToCheckList.add(this.columnsList.get(indexOf));
        }
        this.columnsToCheck = columnsToCheckList.toArray(new String[0]);
        return this;
    }

    public String[] getColumnsToExclude() {
        if (this.columnsToExclude == null) {
            return null;
        }
        return (String[])this.columnsToExclude.clone();
    }

    private Table setColumnsToExclude(String[] columnsToExclude) {
        if (columnsToExclude == null) {
            this.columnsToExclude = null;
            return this;
        }
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the connectionProvider must be set first", new Object[0]);
        }
        LetterCase letterCase = this.getColumnLetterCase();
        this.columnsToExclude = new String[columnsToExclude.length];
        ArrayList<String> columnsToExcludeList = new ArrayList<String>();
        for (String column : columnsToExclude) {
            if (column == null) {
                throw new NullPointerException("The name of the column can not be null");
            }
            int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
            if (indexOf == -1) continue;
            columnsToExcludeList.add(this.columnsList.get(indexOf));
        }
        this.columnsToExclude = columnsToExcludeList.toArray(new String[0]);
        return this;
    }

    public Order[] getColumnsToOrder() {
        if (this.columnsToOrder == null) {
            return null;
        }
        return (Order[])this.columnsToOrder.clone();
    }

    private Table setColumnsToOrder(Order[] columnsToOrder) {
        if (columnsToOrder == null) {
            this.columnsToOrder = null;
            return this;
        }
        if (this.columnsList == null) {
            throw new AssertJDBException("The table name and the connectionProvider must be set first", new Object[0]);
        }
        LetterCase letterCase = this.getColumnLetterCase();
        this.columnsToOrder = new Order[columnsToOrder.length];
        ArrayList<Order> columnsToOrderList = new ArrayList<Order>();
        for (Order order : columnsToOrder) {
            if (order == null) {
                throw new NullPointerException("The order can not be null");
            }
            String column = order.getName();
            if (column == null) {
                throw new NullPointerException("The name of the column for order can not be null");
            }
            int indexOf = NameComparator.INSTANCE.indexOf(this.columnsList, column, letterCase);
            if (indexOf == -1) continue;
            String columnName = this.columnsList.get(indexOf);
            columnsToOrderList.add(Order.getOrder(columnName, order.getType()));
        }
        this.columnsToOrder = columnsToOrderList.toArray(new Order[0]);
        return this;
    }

    public Character getStartDelimiter() {
        return this.startDelimiter;
    }

    private Table setStartDelimiter(Character startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public Character getEndDelimiter() {
        return this.endDelimiter;
    }

    private Table setEndDelimiter(Character endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    private String encode(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.startDelimiter != null) {
            stringBuilder.append(this.startDelimiter);
        }
        stringBuilder.append(name);
        if (this.endDelimiter != null) {
            stringBuilder.append(this.endDelimiter);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getRequest() {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.columnsToCheck == null) {
            stringBuilder.append("*");
        } else {
            for (String column : this.columnsToCheck) {
                if (stringBuilder.length() > 7) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.encode(column));
            }
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.encode(this.name));
        if (this.columnsToOrder != null) {
            for (int index = 0; index < this.columnsToOrder.length; ++index) {
                if (index == 0) {
                    stringBuilder.append(" ORDER BY ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.encode(this.columnsToOrder[index].getName()));
                if (this.columnsToOrder[index].getType() != Order.OrderType.DESC) continue;
                stringBuilder.append(" DESC");
            }
        }
        return stringBuilder.toString();
    }

    private void collectColumnsNameFromResultSet(ResultSet resultSet) throws SQLException {
        LetterCase letterCase = this.getColumnLetterCase();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> columnsNameList = new ArrayList<String>();
        List<String> columnsToExcludeList = null;
        if (this.columnsToExclude != null) {
            columnsToExcludeList = Arrays.asList(this.columnsToExclude);
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = letterCase.convert(resultSetMetaData.getColumnLabel(i));
            if (columnsToExcludeList != null && NameComparator.INSTANCE.contains(columnsToExcludeList, columnName, letterCase)) continue;
            columnsNameList.add(columnName);
        }
        this.setColumnsNameList(columnsNameList);
    }

    private void collectPrimaryKeyName() {
        ArrayList<String> pksNameList = new ArrayList<String>();
        SchemaMetadata metaData = this.getMetaData();
        String tableName = this.name;
        LetterCase letterCase = this.getTableLetterCase();
        for (String tableResult : metaData.getTablesName()) {
            if (!letterCase.isEqual(tableName, tableResult)) continue;
            tableName = tableResult;
            break;
        }
        LetterCase pkLetterCase = this.getPrimaryKeyLetterCase();
        for (String primaryKey : metaData.getPrimaryKeys(tableName)) {
            if (!NameComparator.INSTANCE.contains(this.getColumnsNameList(), primaryKey, pkLetterCase)) continue;
            String pkName = pkLetterCase.convert(primaryKey);
            pksNameList.add(pkName);
        }
        this.setPksNameList(pksNameList);
    }

    @Override
    protected void loadImpl(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new NullPointerException("name can not be null");
        }
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getRequest());){
            this.collectColumnsNameFromResultSet(resultSet);
            this.collectRowsFromResultSet(resultSet);
        }
        this.collectPrimaryKeyName();
        if (this.columnsToOrder == null) {
            this.sortRows();
        }
    }

    public static class Order {
        private final String name;
        private final OrderType type;

        private Order(String name, OrderType type) {
            this.name = name;
            this.type = type;
        }

        public static Order asc(String name) {
            return Order.getOrder(name, OrderType.ASC);
        }

        public static Order desc(String name) {
            return Order.getOrder(name, OrderType.DESC);
        }

        private static Order getOrder(String name, OrderType type) {
            return new Order(name, type);
        }

        public String getName() {
            return this.name;
        }

        public OrderType getType() {
            return this.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.type == null ? 0 : this.type.hashCode());
            hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Order) {
                Order order = (Order)obj;
                if (order.type == this.type) {
                    return this.name == null && order.name == null || this.name != null && this.name.equals(order.name);
                }
            }
            return false;
        }

        public static enum OrderType {
            ASC,
            DESC;

        }
    }

    public static class Builder {
        private final ConnectionProvider connectionProvider;
        private final String name;
        private Order[] columnsToOrder;
        private Character startDelimiter;
        private Character endDelimiter;
        private String[] columnsToCheck;
        private String[] columnsToExclude;

        Builder(ConnectionProvider connectionProvider, String name) {
            this.connectionProvider = connectionProvider;
            this.name = name;
        }

        public Builder columnsToOrder(Order[] columnsToOrder) {
            this.columnsToOrder = columnsToOrder;
            return this;
        }

        public Builder delimiters(Character startDelimiter, Character endDelimiter) {
            this.startDelimiter = startDelimiter;
            this.endDelimiter = endDelimiter;
            return this;
        }

        public Builder columnsToCheck(String[] columnsToCheck) {
            this.columnsToCheck = columnsToCheck;
            return this;
        }

        public Builder columnsToExclude(String[] columnsToExclude) {
            this.columnsToExclude = columnsToExclude;
            return this;
        }

        public Table build() {
            return new Table(this.connectionProvider, this.name, this.startDelimiter, this.endDelimiter, this.columnsToOrder, this.columnsToCheck, this.columnsToExclude);
        }
    }
}

