/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.SchemaMetadata;

class FromConnectionSchemaMetadata
implements SchemaMetadata {
    private final ConnectionProvider connectionProvider;

    public FromConnectionSchemaMetadata(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    private static String getCatalog(Connection connection) throws SQLException {
        try {
            return connection.getCatalog();
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception throwable) {
            return null;
        }
    }

    private static String getSchema(Connection connection) throws SQLException {
        try {
            return connection.getSchema();
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception throwable) {
            return null;
        }
    }

    @Override
    public Collection<String> getTablesName() {
        ArrayList<String> arrayList;
        block16: {
            Connection connection = this.connectionProvider.getConnection();
            try {
                ArrayList<String> tables = new ArrayList<String>();
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet tableResultSet = metaData.getTables(FromConnectionSchemaMetadata.getCatalog(connection), FromConnectionSchemaMetadata.getSchema(connection), null, new String[]{"TABLE"});){
                    while (tableResultSet.next()) {
                        String tableName = tableResultSet.getString("TABLE_NAME");
                        tables.add(tableName);
                    }
                }
                arrayList = tables;
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AssertJDBException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public Collection<String> getColumnsName(String tableName) {
        ArrayList<String> arrayList;
        block16: {
            Connection connection = this.connectionProvider.getConnection();
            try {
                ArrayList<String> columnsList = new ArrayList<String>();
                try (ResultSet columnsResultSet = connection.getMetaData().getColumns(FromConnectionSchemaMetadata.getCatalog(connection), FromConnectionSchemaMetadata.getSchema(connection), tableName, null);){
                    while (columnsResultSet.next()) {
                        String column = columnsResultSet.getString("COLUMN_NAME");
                        columnsList.add(column);
                    }
                }
                arrayList = columnsList;
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AssertJDBException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public Collection<String> getPrimaryKeys(String tableName) {
        ArrayList<String> arrayList;
        block16: {
            Connection connection = this.connectionProvider.getConnection();
            try {
                ArrayList<String> pksNameList = new ArrayList<String>();
                try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(FromConnectionSchemaMetadata.getCatalog(connection), FromConnectionSchemaMetadata.getSchema(connection), tableName);){
                    while (resultSet.next()) {
                        String pkName = resultSet.getString("COLUMN_NAME");
                        pksNameList.add(pkName);
                    }
                }
                arrayList = pksNameList;
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AssertJDBException(e);
                }
            }
            connection.close();
        }
        return arrayList;
    }
}

