/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.AbstractDbData;
import org.assertj.db.type.AbstractDbElement;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.ConnectionProvider;
import org.assertj.db.type.Request;
import org.assertj.db.type.Row;
import org.assertj.db.type.Table;
import org.assertj.db.util.ChangeComparator;

public class Changes
extends AbstractDbElement<Changes> {
    private List<Table> tablesList;
    private List<Table> tablesAtStartPointList;
    private List<Table> tablesAtEndPointList;
    private Request request;
    private Request requestAtStartPoint;
    private Request requestAtEndPoint;
    private List<Change> changesList;

    private Changes(ConnectionProvider connectionProvider) {
        super(Changes.class, connectionProvider);
    }

    private Changes(ConnectionProvider connectionProvider, Collection<Table> tables) {
        super(Changes.class, connectionProvider);
        this.setTables(tables);
    }

    private Changes(ConnectionProvider connectionProvider, Request request) {
        super(Changes.class, connectionProvider);
        this.setRequest(request);
    }

    private Changes() {
        super(Changes.class);
    }

    private Request getDuplicatedRequest(Request request) {
        return new Request.Builder(this.getConnectionProvider(), request.getRequest()).parameters(request.getParameters()).pksName(request.getPksNameList().toArray(new String[0])).build();
    }

    private Table getDuplicatedTable(Table table) {
        return new Table.Builder(this.getConnectionProvider(), table.getName()).delimiters(table.getStartDelimiter(), table.getEndDelimiter()).columnsToCheck(table.getColumnsToCheck()).columnsToExclude(table.getColumnsToExclude()).columnsToOrder(table.getColumnsToOrder()).build();
    }

    private void setTables(Collection<Table> tables) {
        this.request = null;
        this.requestAtStartPoint = null;
        this.requestAtEndPoint = null;
        this.tablesList = new ArrayList<Table>();
        this.tablesAtStartPointList = null;
        this.tablesAtEndPointList = null;
        this.changesList = null;
        for (Table table : tables) {
            if (table == null) {
                throw new NullPointerException("The tables must be not null");
            }
            Table t = this.getDuplicatedTable(table);
            this.tablesList.add(t);
        }
    }

    public List<Table> getTablesList() {
        return this.tablesList;
    }

    public Request getRequest() {
        return this.request;
    }

    private void setRequest(Request request) {
        if (request == null) {
            throw new NullPointerException("The request must be not null");
        }
        this.tablesList = null;
        this.tablesAtStartPointList = null;
        this.tablesAtEndPointList = null;
        this.request = this.getDuplicatedRequest(request);
        this.requestAtStartPoint = null;
        this.requestAtEndPoint = null;
        this.changesList = null;
    }

    public List<Table> getTablesAtStartPointList() {
        return this.tablesAtStartPointList;
    }

    public List<Table> getTablesAtEndPointList() {
        return this.tablesAtEndPointList;
    }

    public Request getRequestAtStartPoint() {
        return this.requestAtStartPoint;
    }

    public Request getRequestAtEndPoint() {
        return this.requestAtEndPoint;
    }

    public Changes setStartPointNow() {
        if (this.request == null && this.tablesList == null) {
            this.tablesList = new LinkedList<Table>();
            for (String tableName : this.getMetaData().getTablesName()) {
                this.tablesList.add(new Table.Builder(this.getConnectionProvider(), this.getTableLetterCase().convert(tableName)).build());
            }
        }
        if (this.request != null) {
            this.tablesAtStartPointList = null;
            this.requestAtStartPoint = this.getDuplicatedRequest(this.request);
            this.requestAtStartPoint.getRowsList();
        } else {
            this.requestAtStartPoint = null;
            this.tablesAtStartPointList = new LinkedList<Table>();
            for (Table table : this.tablesList) {
                Table t = this.getDuplicatedTable(table);
                t.getRowsList();
                this.tablesAtStartPointList.add(t);
            }
        }
        this.tablesAtEndPointList = null;
        this.requestAtEndPoint = null;
        this.changesList = null;
        return (Changes)this.myself;
    }

    public Changes setEndPointNow() {
        if (this.requestAtStartPoint == null && this.tablesAtStartPointList == null) {
            throw new AssertJDBException("Start point must be set before", new Object[0]);
        }
        if (this.requestAtStartPoint != null) {
            this.requestAtEndPoint = this.getDuplicatedRequest(this.request);
            this.requestAtEndPoint.getRowsList();
        } else {
            this.tablesAtEndPointList = new LinkedList<Table>();
            for (Table table : this.tablesList) {
                Table t = this.getDuplicatedTable(table);
                t.getRowsList();
                this.tablesAtEndPointList.add(t);
            }
        }
        this.changesList = null;
        return (Changes)this.myself;
    }

    private List<Change> getChangesListWithPks(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        Change change;
        ArrayList<Change> changesListWithPks = new ArrayList<Change>();
        for (Row row : dataAtEndPoint.getRowsList()) {
            Row rowAtStartPoint = dataAtStartPoint.getRowFromPksValues(row.getPksValues());
            if (rowAtStartPoint != null) continue;
            change = Change.createCreationChange(dataAtEndPoint.getDataType(), dataName, row, this.getTableLetterCase(), this.getColumnLetterCase(), this.getPrimaryKeyLetterCase());
            changesListWithPks.add(change);
        }
        for (Row row : dataAtStartPoint.getRowsList()) {
            Row rowAtEndPoint = dataAtEndPoint.getRowFromPksValues(row.getPksValues());
            if (rowAtEndPoint == null) {
                change = Change.createDeletionChange(dataAtStartPoint.getDataType(), dataName, row, this.getTableLetterCase(), this.getColumnLetterCase(), this.getPrimaryKeyLetterCase());
                changesListWithPks.add(change);
                continue;
            }
            if (row.hasValues(rowAtEndPoint)) continue;
            change = Change.createModificationChange(dataAtStartPoint.getDataType(), dataName, row, rowAtEndPoint, this.getTableLetterCase(), this.getColumnLetterCase(), this.getPrimaryKeyLetterCase());
            changesListWithPks.add(change);
        }
        return changesListWithPks;
    }

    private List<Change> getChangesListWithoutPks(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        ArrayList<Change> changesListWithoutPks = new ArrayList<Change>();
        ArrayList<Row> rowsAtStartPointList = new ArrayList<Row>(dataAtStartPoint.getRowsList());
        for (Row rowAtEndPoint : dataAtEndPoint.getRowsList()) {
            int index = -1;
            int index1 = 0;
            for (Row row : rowsAtStartPointList) {
                if (rowAtEndPoint.hasValues(row)) {
                    index = index1;
                    break;
                }
                ++index1;
            }
            if (index == -1) {
                Change change = Change.createCreationChange(dataAtStartPoint.getDataType(), dataName, rowAtEndPoint, this.getTableLetterCase(), this.getColumnLetterCase(), this.getPrimaryKeyLetterCase());
                changesListWithoutPks.add(change);
                continue;
            }
            rowsAtStartPointList.remove(index);
        }
        ArrayList<Row> rowsAtEndPointList = new ArrayList<Row>(dataAtEndPoint.getRowsList());
        for (Row rowAtStartPoint : dataAtStartPoint.getRowsList()) {
            int index = -1;
            int index1 = 0;
            for (Row rowAtEndPoint : rowsAtEndPointList) {
                if (rowAtStartPoint.hasValues(rowAtEndPoint)) {
                    index = index1;
                    break;
                }
                ++index1;
            }
            if (index == -1) {
                Change change = Change.createDeletionChange(dataAtStartPoint.getDataType(), dataName, rowAtStartPoint, this.getTableLetterCase(), this.getColumnLetterCase(), this.getPrimaryKeyLetterCase());
                changesListWithoutPks.add(change);
                continue;
            }
            rowsAtEndPointList.remove(index);
        }
        return changesListWithoutPks;
    }

    private List<Change> getChangesList(String dataName, AbstractDbData<?> dataAtStartPoint, AbstractDbData<?> dataAtEndPoint) {
        if (dataAtStartPoint.getPksNameList().isEmpty()) {
            return this.getChangesListWithoutPks(dataName, dataAtStartPoint, dataAtEndPoint);
        }
        return this.getChangesListWithPks(dataName, dataAtStartPoint, dataAtEndPoint);
    }

    public List<Change> getChangesList() {
        if (this.changesList == null) {
            if (this.requestAtEndPoint == null && this.tablesAtEndPointList == null) {
                throw new AssertJDBException("End point must be set before", new Object[0]);
            }
            if (this.requestAtEndPoint != null) {
                this.changesList = this.getChangesList(this.requestAtStartPoint.getRequest(), this.requestAtStartPoint, this.requestAtEndPoint);
            } else {
                this.changesList = new ArrayList<Change>();
                Iterator<Table> iteratorAtStartPoint = this.tablesAtStartPointList.iterator();
                Iterator<Table> iteratorAtEndPoint = this.tablesAtEndPointList.iterator();
                while (iteratorAtStartPoint.hasNext()) {
                    Table tableAtStartPoint = iteratorAtStartPoint.next();
                    Table tableAtEndPoint = iteratorAtEndPoint.next();
                    this.changesList.addAll(this.getChangesList(tableAtStartPoint.getName(), tableAtStartPoint, tableAtEndPoint));
                }
            }
        }
        this.changesList.sort(ChangeComparator.INSTANCE);
        return this.changesList;
    }

    public Changes getChangesOfTable(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName must be not null");
        }
        Changes changes = this.createChangesFromThis();
        List<Change> changesListOfTable = this.getChangesList();
        if (this.tablesList != null) {
            for (Change change : changesListOfTable) {
                if (!this.getTableLetterCase().isEqual(tableName, change.getDataName())) continue;
                changes.changesList.add(change);
            }
        }
        return changes;
    }

    public Changes getChangesOfType(ChangeType changeType) {
        if (changeType == null) {
            throw new NullPointerException("changeType must be not null");
        }
        Changes changes = this.createChangesFromThis();
        List<Change> changesListOfType = this.getChangesList();
        for (Change change : changesListOfType) {
            if (!changeType.equals((Object)change.getChangeType())) continue;
            changes.changesList.add(change);
        }
        return changes;
    }

    private Changes createChangesFromThis() {
        Changes changes = new Changes(this.getConnectionProvider());
        if (this.request != null) {
            changes.request = this.getDuplicatedRequest(this.request);
        }
        if (this.tablesList != null) {
            changes.tablesList = new ArrayList<Table>();
            for (Table table : this.tablesList) {
                changes.tablesList.add(this.getDuplicatedTable(table));
            }
        }
        changes.changesList = new ArrayList<Change>();
        return changes;
    }

    public static class Builder {
        private final ConnectionProvider connectionProvider;
        private Request request;
        private List<Table> tables = new ArrayList<Table>();

        Builder(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder request(String request) {
            this.request = new Request.Builder(this.connectionProvider, request).build();
            return this;
        }

        public Builder request(String request, Consumer<Request.Builder> customizer) {
            Request.Builder builder = new Request.Builder(this.connectionProvider, request);
            customizer.accept(builder);
            this.request = builder.build();
            return this;
        }

        public Builder table(String name) {
            this.tables.add(new Table.Builder(this.connectionProvider, name).build());
            return this;
        }

        public Builder table(String name, Consumer<Table.Builder> customizer) {
            Table.Builder builder = new Table.Builder(this.connectionProvider, name);
            customizer.accept(builder);
            this.tables.add(builder.build());
            return this;
        }

        public Builder tables(Table ... tables) {
            this.tables = Arrays.asList(tables);
            return this;
        }

        public Changes build() {
            if (this.tables != null && !this.tables.isEmpty()) {
                return new Changes(this.connectionProvider, this.tables);
            }
            if (this.request != null) {
                return new Changes(this.connectionProvider, this.request);
            }
            return new Changes(this.connectionProvider);
        }
    }
}

