/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.List;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.DataType;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.type.lettercase.WithColumnLetterCase;
import org.assertj.db.type.lettercase.WithPrimaryKeyLetterCase;
import org.assertj.db.type.lettercase.WithTableLetterCase;

public class Change
implements DbElement,
WithTableLetterCase,
WithColumnLetterCase,
WithPrimaryKeyLetterCase {
    private final DataType dataType;
    private final String dataName;
    private final List<String> pksNameList;
    private final List<String> columnsNameList;
    private final ChangeType changeType;
    private final Row rowAtStartPoint;
    private final Row rowAtEndPoint;
    private final LetterCase tableLetterCase;
    private final LetterCase columnLetterCase;
    private final LetterCase primaryKeyLetterCase;

    private Change(DataType dataType, String dataName, ChangeType changeType, Row rowAtStartPoint, Row rowAtEndPoint, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        if (dataType == null) {
            throw new NullPointerException("The type of the data must be not null");
        }
        if (dataName == null) {
            throw new NullPointerException("The name of the data must be not null");
        }
        this.dataType = dataType;
        this.dataName = dataName;
        if (rowAtStartPoint != null) {
            this.pksNameList = rowAtStartPoint.getPksNameList();
            this.columnsNameList = rowAtStartPoint.getColumnsNameList();
        } else {
            this.pksNameList = rowAtEndPoint.getPksNameList();
            this.columnsNameList = rowAtEndPoint.getColumnsNameList();
        }
        this.changeType = changeType;
        this.rowAtStartPoint = rowAtStartPoint;
        this.rowAtEndPoint = rowAtEndPoint;
        this.tableLetterCase = tableLetterCase;
        this.columnLetterCase = columnLetterCase;
        this.primaryKeyLetterCase = primaryKeyLetterCase;
    }

    static Change createCreationChange(DataType dataType, String dataName, Row rowAtEndPoint, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        return new Change(dataType, dataName, ChangeType.CREATION, null, rowAtEndPoint, tableLetterCase, columnLetterCase, primaryKeyLetterCase);
    }

    static Change createModificationChange(DataType dataType, String dataName, Row rowAtStartPoint, Row rowAtEndPoint, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        return new Change(dataType, dataName, ChangeType.MODIFICATION, rowAtStartPoint, rowAtEndPoint, tableLetterCase, columnLetterCase, primaryKeyLetterCase);
    }

    static Change createDeletionChange(DataType dataType, String dataName, Row rowAtStartPoint, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        return new Change(dataType, dataName, ChangeType.DELETION, rowAtStartPoint, null, tableLetterCase, columnLetterCase, primaryKeyLetterCase);
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.columnLetterCase;
    }

    @Override
    public LetterCase getPrimaryKeyLetterCase() {
        return this.primaryKeyLetterCase;
    }

    @Override
    public LetterCase getTableLetterCase() {
        return this.tableLetterCase;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDataName() {
        return this.dataName;
    }

    public List<String> getPksNameList() {
        return this.pksNameList;
    }

    public List<Value> getPksValueList() {
        if (this.rowAtStartPoint != null) {
            return this.rowAtStartPoint.getPksValueList();
        }
        return this.rowAtEndPoint.getPksValueList();
    }

    public List<String> getColumnsNameList() {
        return this.columnsNameList;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Row getRowAtStartPoint() {
        return this.rowAtStartPoint;
    }

    public Row getRowAtEndPoint() {
        return this.rowAtEndPoint;
    }
}

