/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output.impl;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.db.output.impl.HtmlOutput;
import org.assertj.db.output.impl.Output;
import org.assertj.db.output.impl.PlainOutput;
import org.assertj.db.type.Change;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Column;
import org.assertj.db.type.DataType;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.Request;
import org.assertj.db.type.Row;
import org.assertj.db.type.Table;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public enum OutputType implements Output
{
    PLAIN(PlainOutput.INSTANCE),
    HTML(HtmlOutput.INSTANCE);

    private final Output displayer;

    private OutputType(Output displayer) {
        this.displayer = displayer;
    }

    static String getDataName(Change change) {
        DataType dataType = change.getDataType();
        String dataName = change.getDataName();
        if (dataType == DataType.REQUEST && dataName.length() > 30) {
            dataName = dataName.substring(0, 30) + "...";
        }
        return dataName;
    }

    static String getType(Value ... values) {
        for (Value value : values) {
            if (value.getValue() == null) continue;
            return "(" + value.getValueTypeRepresentation() + ")";
        }
        return "(" + (Object)((Object)ValueType.NOT_IDENTIFIED) + ")";
    }

    static String getText(Value value) {
        Object object = value.getValue();
        ValueType type = value.getValueType();
        if (type == ValueType.BYTES) {
            return "...";
        }
        if (type == ValueType.DATE_TIME) {
            return "" + DateTimeValue.from((Timestamp)object);
        }
        if (type == ValueType.DATE) {
            return "" + DateValue.from((Date)object);
        }
        if (type == ValueType.TIME) {
            return "" + TimeValue.from((Time)object);
        }
        return "" + object;
    }

    static List<String> getTypesList(Row ... rows) {
        ArrayList<String> typesList = new ArrayList<String>();
        Row row0 = null;
        for (Row row : rows) {
            if (row == null) continue;
            row0 = row;
            break;
        }
        if (row0 != null) {
            for (int index = 0; index < row0.getColumnsNameList().size(); ++index) {
                ArrayList<Value> valuesList = new ArrayList<Value>();
                for (Row row : rows) {
                    if (row == null) continue;
                    Value value = row.getValuesList().get(index);
                    valuesList.add(value);
                }
                String type = OutputType.getType(valuesList.toArray(new Value[0]));
                typesList.add(type);
            }
        }
        return typesList;
    }

    static StringBuilder[] getPksValueStringBuilder(Row ... rows) {
        ArrayList<StringBuilder> stringBuildersList = new ArrayList<StringBuilder>();
        for (Row row : rows) {
            List<Value> pksValueList = row.getPksValueList();
            StringBuilder pksValueStringBuilder = new StringBuilder();
            for (Value pkValue : pksValueList) {
                if (pksValueStringBuilder.length() > 0) {
                    pksValueStringBuilder.append(", ");
                }
                pksValueStringBuilder.append(OutputType.getText(pkValue));
            }
            stringBuildersList.add(pksValueStringBuilder);
        }
        return stringBuildersList.toArray(new StringBuilder[0]);
    }

    static StringBuilder[] getPksValueStringBuilder(Change ... changes) {
        ArrayList<StringBuilder> stringBuildersList = new ArrayList<StringBuilder>();
        for (Change change : changes) {
            List<Value> pksValueList = change.getPksValueList();
            StringBuilder pksValueStringBuilder = new StringBuilder();
            for (Value pkValue : pksValueList) {
                if (pksValueStringBuilder.length() > 0) {
                    pksValueStringBuilder.append(", ");
                }
                pksValueStringBuilder.append(OutputType.getText(pkValue));
            }
            stringBuildersList.add(pksValueStringBuilder);
        }
        return stringBuildersList.toArray(new StringBuilder[0]);
    }

    @Override
    public String getTableOutput(WritableAssertionInfo info, Table table) {
        return this.displayer.getTableOutput(info, table);
    }

    @Override
    public String getRequestOutput(WritableAssertionInfo info, Request request) {
        return this.displayer.getRequestOutput(info, request);
    }

    @Override
    public String getChangesOutput(WritableAssertionInfo info, Changes changes) {
        return this.displayer.getChangesOutput(info, changes);
    }

    @Override
    public String getChangeOutput(WritableAssertionInfo info, Change change) {
        return this.displayer.getChangeOutput(info, change);
    }

    @Override
    public String getRowOutput(WritableAssertionInfo info, Row row) {
        return this.displayer.getRowOutput(info, row);
    }

    @Override
    public String getColumnOutput(WritableAssertionInfo info, Column column) {
        return this.displayer.getColumnOutput(info, column);
    }

    @Override
    public String getChangeColumnOutput(WritableAssertionInfo info, String columnName, Value valueAtStartPoint, Value valueAtEndPoint) {
        return this.displayer.getChangeColumnOutput(info, columnName, valueAtStartPoint, valueAtEndPoint);
    }

    @Override
    public String getValueOutput(WritableAssertionInfo info, Value value) {
        return this.displayer.getValueOutput(info, value);
    }
}

