/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.aspectj.tools.ant.taskdefs.AjcTask;
import org.aspectj.util.FileUtil;

public class Ajc11CompilerAdapter
implements CompilerAdapter {
    public static final String CLEAN = "build.compiler.clean";
    private static final ThreadLocal<Boolean> inSelfCall = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    Javac javac;

    public void setJavac(Javac javac) {
        this.javac = javac;
        javac.setTaskName(javac.getTaskName() + " - ajc");
    }

    public boolean execute() throws BuildException {
        if (null == this.javac) {
            throw new IllegalStateException("null javac");
        }
        if (!inSelfCall.get().booleanValue() && this.afterCleaningDirs()) {
            inSelfCall.set(Boolean.TRUE);
            this.javac.execute();
        } else {
            try {
                AjcTask ajc = new AjcTask();
                String err = ajc.setupAjc(this.javac);
                if (null != err) {
                    throw new BuildException(err, this.javac.getLocation());
                }
                ajc.execute();
            }
            finally {
                inSelfCall.set(Boolean.FALSE);
            }
        }
        return true;
    }

    private boolean afterCleaningDirs() {
        String clean = this.javac.getProject().getProperty(CLEAN);
        if (null == clean) {
            return false;
        }
        File destDir = this.javac.getDestdir();
        if (null == destDir) {
            this.javac.log("build.compiler.clean specified, but no dest dir to clean", 1);
            return false;
        }
        this.javac.log("build.compiler.clean cleaning .class files from " + destDir, 3);
        FileUtil.deleteContents(destDir, FileUtil.DIRS_AND_WRITABLE_CLASSES, true);
        return true;
    }
}

