/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchEngine;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.index.IndexLocation;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.BinaryContainer;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.aspectj.org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class AddJarFileToIndex
extends BinaryContainer {
    private static final char JAR_SEPARATOR = "|".charAt(0);
    IFile resource;
    private IndexLocation indexFileURL;
    private final boolean forceIndexUpdate;

    public AddJarFileToIndex(IFile resource, IndexLocation indexFile, IndexManager manager) {
        this(resource, indexFile, manager, false);
    }

    public AddJarFileToIndex(IFile resource, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public AddJarFileToIndex(IPath jarPath, IndexLocation indexFile, IndexManager manager) {
        this(jarPath, indexFile, manager, false);
    }

    public AddJarFileToIndex(IPath jarPath, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(jarPath, manager);
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public boolean equals(Object o) {
        if (o instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals(((AddJarFileToIndex)o).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals(((AddJarFileToIndex)o).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (this.hasPreBuiltIndex()) {
            boolean added = this.manager.addIndex(this.containerPath, this.indexFileURL);
            if (added) {
                return true;
            }
            this.indexFileURL = null;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            index.separator = JAR_SEPARATOR;
            ZipFile zip = null;
            try {
                JavaSearchDocument entryDocument;
                String zipEntryName;
                ZipEntry ze;
                Path zipFilePath = null;
                monitor.enterWrite();
                if (this.resource != null) {
                    File file;
                    URI location;
                    block47: {
                        location = this.resource.getLocationURI();
                        if (location == null) {
                            return false;
                        }
                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + location.getPath());
                        }
                        file = null;
                        try {
                            file = org.aspectj.org.eclipse.jdt.internal.core.util.Util.toLocalFile(location, progressMonitor);
                        }
                        catch (CoreException e) {
                            if (!JobManager.VERBOSE) break block47;
                            org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + location.getPath() + " because of the following exception:");
                            e.printStackTrace();
                        }
                    }
                    if (file == null) {
                        if (!JobManager.VERBOSE) return false;
                        org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + location.getPath() + " because the file could not be fetched");
                        return false;
                    }
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                    }
                    zip = new ZipFile(file);
                    zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                } else {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                    }
                    zip = new ZipFile(this.containerPath.toFile());
                    zipFilePath = (Path)this.containerPath;
                }
                if (this.isCancelled) {
                    if (!JobManager.VERBOSE) return false;
                    org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                    return false;
                }
                if (JobManager.VERBOSE) {
                    org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing " + zip.getName());
                }
                long initialTime = System.currentTimeMillis();
                String[] paths = index.queryDocumentNames("");
                if (paths != null) {
                    boolean needToReindex;
                    int max = paths.length;
                    String EXISTS = "OK";
                    String DELETED = "DELETED";
                    SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (i < max) {
                        indexedFileNames.put(paths[i], DELETED);
                        ++i;
                    }
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ze = e.nextElement();
                        zipEntryName = ze.getName();
                        if (!Util.isClassFileName(zipEntryName) || !this.isValidPackageNameForClassOrisModule(zipEntryName)) continue;
                        indexedFileNames.put(zipEntryName, EXISTS);
                    }
                    boolean bl = needToReindex = indexedFileNames.elementSize != max;
                    if (!needToReindex) {
                        Object[] valueTable = indexedFileNames.valueTable;
                        int i2 = 0;
                        int l = valueTable.length;
                        while (i2 < l) {
                            if (valueTable[i2] == DELETED) {
                                needToReindex = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!needToReindex) {
                            if (JobManager.VERBOSE) {
                                org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                            }
                            this.manager.saveIndex(index);
                            return true;
                        }
                    }
                }
                SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                if (!this.manager.resetIndex(this.containerPath)) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                index.separator = JAR_SEPARATOR;
                Path indexPath = null;
                IndexLocation indexLocation = index.getIndexLocation();
                if (indexLocation != null) {
                    indexPath = new Path(indexLocation.getCanonicalFilePath());
                }
                boolean hasModuleInfoClass = false;
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    if (this.isCancelled) {
                        if (!JobManager.VERBOSE) return false;
                        org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                        return false;
                    }
                    ze = e.nextElement();
                    zipEntryName = ze.getName();
                    if (!Util.isClassFileName(zipEntryName) || !this.isValidPackageNameForClassOrisModule(zipEntryName)) continue;
                    hasModuleInfoClass |= zipEntryName.contains("module-info");
                    byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
                    entryDocument = new JavaSearchDocument(ze, zipFilePath, classFileBytes, participant);
                    this.manager.indexDocument(entryDocument, participant, index, indexPath);
                }
                if (!hasModuleInfoClass) {
                    try {
                        String s = this.resource == null ? this.containerPath.toOSString() : JavaModelManager.getLocalFile(this.resource.getFullPath()).toPath().toAbsolutePath().toString();
                        char[] autoModuleName = AutomaticModuleNaming.determineAutomaticModuleName(s);
                        char[] contents = CharOperation.append(CharOperation.append("Automatic-Module-Name".toCharArray(), ':'), autoModuleName);
                        ZipEntry ze2 = new ZipEntry("Automatic-Module-Name");
                        entryDocument = new JavaSearchDocument(ze2, zipFilePath, new String(contents).getBytes(Charset.defaultCharset()), participant);
                        this.manager.indexDocument(entryDocument, participant, index, indexPath);
                    }
                    catch (CoreException coreException) {}
                }
                if (this.forceIndexUpdate) {
                    this.manager.savePreBuiltIndex(index);
                } else {
                    this.manager.saveIndex(index);
                }
                if (!JobManager.VERBOSE) return true;
                org.aspectj.org.eclipse.jdt.internal.core.util.Util.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                if (zip != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + this.containerPath);
                    }
                    zip.close();
                }
                monitor.exitWrite();
            }
        }
        catch (IOException | ZipError e) {
            org.aspectj.org.eclipse.jdt.internal.core.util.Util.log(e, "Failed to index " + this.containerPath);
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    @Override
    public String getJobFamily() {
        if (this.resource != null) {
            return super.getJobFamily();
        }
        return this.containerPath.toOSString();
    }

    @Override
    protected Integer updatedIndexState() {
        Integer updateState = null;
        updateState = this.hasPreBuiltIndex() ? IndexManager.REUSE_STATE : IndexManager.REBUILDING_STATE;
        return updateState;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    protected boolean hasPreBuiltIndex() {
        return !this.forceIndexUpdate && this.indexFileURL != null && this.indexFileURL.exists();
    }
}

