/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.ajde.ui.UserPreferencesAdapter;

public class BrowserOutputLocationManager
implements IOutputLocationManager {
    private UserPreferencesAdapter preferencesAdapter;

    public BrowserOutputLocationManager(UserPreferencesAdapter preferencesAdapter) {
        this.preferencesAdapter = preferencesAdapter;
    }

    @Override
    public File getOutputLocationForClass(File compilationUnit) {
        return new File(this.getCommonOutputDir());
    }

    @Override
    public File getOutputLocationForResource(File resource) {
        return new File(this.getCommonOutputDir());
    }

    private String getCommonOutputDir() {
        String outputPath = this.preferencesAdapter.getProjectPreference("build.outputpath");
        if (outputPath == null) {
            return ".";
        }
        return outputPath;
    }

    @Override
    public List<File> getAllOutputLocations() {
        ArrayList<File> outputDirs = new ArrayList<File>();
        outputDirs.add(new File(this.getCommonOutputDir()));
        return outputDirs;
    }

    @Override
    public File getDefaultOutputLocation() {
        return new File(this.getCommonOutputDir());
    }

    @Override
    public String getSourceFolderForFile(File sourceFile) {
        return null;
    }

    @Override
    public void reportFileWrite(String outputfile, int filetype) {
    }

    @Override
    public void reportFileRemove(String outputfile, int filetype) {
    }

    @Override
    public int discoverChangesSince(File dir, long buildtime) {
        return 0;
    }

    @Override
    public Map<File, String> getInpathMap() {
        return Collections.emptyMap();
    }
}

