/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.IClasspathAttribute;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IModuleDescription;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JarEntryResource;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    protected static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath jarPath;
    boolean knownToBeModuleLess;
    private boolean multiVersion;
    protected final IClasspathAttribute[] extraAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarPackageFragmentRoot(IResource resource, IPath externalJarPath, JavaProject project, IClasspathAttribute[] attributes) {
        super(resource, project);
        this.jarPath = externalJarPath;
        if (attributes == null) {
            try {
                JavaModelManager.PerProjectInfo perProjectInfo;
                JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = project.getPerProjectInfo();
                synchronized (perProjectInfo2) {
                    IClasspathEntry classpathEntry;
                    if (perProjectInfo.resolvedClasspath != null && perProjectInfo.unresolvedEntryStatus == JavaModelStatus.VERIFIED_OK && (classpathEntry = project.getClasspathEntryFor(externalJarPath)) != null) {
                        attributes = classpathEntry.getExtraAttributes();
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.extraAttributes = attributes;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        HashtableOfArrayToObject rawPackageInfo = new HashtableOfArrayToObject();
        HashMap<String, String> overridden = new HashMap<String, String>();
        IJavaElement[] children = JavaElement.NO_ELEMENTS;
        try {
            rawPackageInfo.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            Object file = JavaModel.getTarget(this.getPath(), true);
            long classLevel = Util.getJdkLevel(file);
            String projectCompliance = this.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
            long projectLevel = CompilerOptions.versionToJdkLevel(projectCompliance);
            ZipFile jar = null;
            try {
                String[] supportedVersions;
                String versionPath;
                jar = this.getJar();
                String version = "META-INF/versions/";
                ArrayList<String> versions = new ArrayList<String>();
                if (projectLevel >= 0x350000L && jar.getEntry(version) != null) {
                    int latestJavaVer;
                    int earliestJavaVersion = 53;
                    long latestJDK = CompilerOptions.releaseToJDKLevel(projectCompliance);
                    int i = latestJavaVer = (int)(latestJDK >> 16);
                    while (i >= earliestJavaVersion) {
                        String s = "" + (i - 44);
                        versionPath = String.valueOf(version) + s;
                        if (jar.getEntry(versionPath) != null) {
                            versions.add(s);
                        }
                        --i;
                    }
                }
                if ((supportedVersions = versions.toArray(new String[versions.size()])).length > 0) {
                    this.multiVersion = true;
                }
                int length = version.length();
                Enumeration<? extends ZipEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    ZipEntry member = e.nextElement();
                    String name = member.getName();
                    if (this.multiVersion && name.length() > length + 2 && name.startsWith(version)) {
                        int end = name.indexOf(47, length);
                        if (end >= name.length()) continue;
                        versionPath = name.substring(0, end);
                        String ver = name.substring(length, end);
                        if (versions.contains(ver) && org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(name)) {
                            name = name.substring(end + 1);
                            overridden.put(name, versionPath);
                        }
                    }
                    this.initRawPackageInfo(rawPackageInfo, name, member.isDirectory(), CompilerOptions.versionFromJdkLevel(classLevel));
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
            children = new IJavaElement[rawPackageInfo.size()];
            int index = 0;
            int i = 0;
            int length = rawPackageInfo.keyTable.length;
            while (i < length) {
                String[] pkgName = (String[])rawPackageInfo.keyTable[i];
                if (pkgName != null) {
                    children[index++] = this.getPackageFragment(pkgName);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ZipException) {
                Util.log(4, "Invalid ZIP archive: " + this.toStringWithAncestors());
                children = JavaElement.NO_ELEMENTS;
            }
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
        info.setChildren(children);
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        ((JarPackageFragmentRootInfo)info).overriddenClasses = overridden;
        return true;
    }

    protected IJavaElement[] createChildren(HashtableOfArrayToObject rawPackageInfo) {
        IJavaElement[] children = new IJavaElement[rawPackageInfo.size()];
        int index = 0;
        int i = 0;
        int length = rawPackageInfo.keyTable.length;
        while (i < length) {
            String[] pkgName = (String[])rawPackageInfo.keyTable[i];
            if (pkgName != null) {
                children[index++] = this.getPackageFragment(pkgName);
            }
            ++i;
        }
        return children;
    }

    @Override
    protected Object createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    @Override
    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals(other.jarPath) && Arrays.equals(this.extraAttributes, other.extraAttributes);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    int internalKind() throws JavaModelException {
        return 2;
    }

    @Override
    public Object[] getNonJavaResources() throws JavaModelException {
        Object[] defaultPkgResources = ((JarPackageFragment)this.getPackageFragment(CharOperation.NO_STRINGS)).storedNonJavaResources();
        int length = defaultPkgResources.length;
        if (length == 0) {
            return defaultPkgResources;
        }
        Object[] nonJavaResources = new Object[length];
        int i = 0;
        while (i < length) {
            JarEntryResource nonJavaResource = (JarEntryResource)defaultPkgResources[i];
            nonJavaResources[i] = nonJavaResource.clone(this);
            ++i;
        }
        return nonJavaResources;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName, String mod) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    public String getClassFilePath(String classname) {
        if (this.multiVersion) {
            try {
                JarPackageFragmentRootInfo elementInfo = (JarPackageFragmentRootInfo)this.getElementInfo();
                String versionPath = elementInfo.overriddenClasses.get(classname);
                return versionPath == null ? classname : String.valueOf(versionPath) + '/' + classname;
            }
            catch (JavaModelException javaModelException) {}
        }
        return classname;
    }

    @Override
    public IModuleDescription getModuleDescription() {
        if (this.knownToBeModuleLess) {
            return null;
        }
        IModuleDescription module = super.getModuleDescription();
        if (module == null) {
            this.knownToBeModuleLess = true;
        }
        return module;
    }

    @Override
    public IPath internalPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.internalPath();
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (this.resource == null) {
            return null;
        }
        return super.resource(root);
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.jarPath.hashCode() + Arrays.hashCode(this.extraAttributes);
    }

    protected void initRawPackageInfo(HashtableOfArrayToObject rawPackageInfo, String entryName, boolean isDirectory, String compliance) {
        int length;
        int lastSeparator = isDirectory ? (entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length()) : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])rawPackageInfo.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i], null, compliance)) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])rawPackageInfo.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            rawPackageInfo.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])rawPackageInfo.get(pkgName);
        if (org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String nameWithoutExtension = entryName.substring(lastSeparator + 1, entryName.length() - 6);
            children[0].add(nameWithoutExtension);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.resource() == null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected boolean resourceExists(IResource underlyingResource) {
        if (underlyingResource == null) {
            return JavaModel.getExternalTarget(this.getPath(), true) != null;
        }
        return super.resourceExists(underlyingResource);
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public URL getIndexPath() {
        try {
            IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
            if (entry != null) {
                return ((ClasspathEntry)entry).getLibraryIndexLocation();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    @Override
    public Manifest getManifest() {
        block15: {
            ZipFile jar = null;
            try {
                Manifest manifest;
                block16: {
                    jar = this.getJar();
                    ZipEntry mfEntry = jar.getEntry("META-INF/MANIFEST.MF");
                    if (mfEntry == null) break block15;
                    Throwable throwable = null;
                    Object var4_5 = null;
                    InputStream is = jar.getInputStream(mfEntry);
                    try {
                        manifest = new Manifest(is);
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException exception) {
                            break block15;
                        }
                    }
                    is.close();
                }
                return manifest;
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(jar);
            }
        }
        return null;
    }
}

