/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;

class LstBuildConfigFileUpdater {
    LstBuildConfigFileUpdater() {
    }

    public void updateBuildConfigFile(String buildConfigFile, String update, boolean addToConfiguration) {
        List<String> fileContents = this.readConfigFile(buildConfigFile);
        if (addToConfiguration) {
            fileContents.add(update);
        } else {
            fileContents.remove(update);
        }
        this.writeConfigFile(buildConfigFile, fileContents);
    }

    public void updateBuildConfigFiles(List buildConfigFiles, List<String> filesToUpdate, boolean addToConfiguration) {
        for (Object buildConfigFile : buildConfigFiles) {
            List<String> fileContents = this.readConfigFile((String)buildConfigFile);
            if (addToConfiguration) {
                for (String s : filesToUpdate) {
                    fileContents.add(s);
                }
            } else {
                for (String s : filesToUpdate) {
                    if (!fileContents.contains(s)) continue;
                    fileContents.remove(s);
                }
            }
            this.writeConfigFile((String)buildConfigFile, fileContents);
        }
    }

    public boolean exists(String entry, String configFile) {
        return this.exists(entry, configFile, "");
    }

    public boolean exists(String entry, String configFile, String rootPath) {
        for (String s : this.readConfigFile(configFile)) {
            if (!entry.equals(rootPath + "/" + s)) continue;
            return true;
        }
        return false;
    }

    public List<String> readConfigFile(String filePath) {
        try {
            File configFile = new File(filePath);
            if (!configFile.exists()) {
                Message msg = new Message("Config file: " + filePath + " does not exist.  Update failed.", IMessage.WARNING, null, null);
                Ajde.getDefault().getMessageHandler().handleMessage(msg);
            }
            ArrayList<String> fileContents = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            String line = reader.readLine();
            while (line != null) {
                fileContents.add(line.replace('\\', '/'));
                line = reader.readLine();
            }
            reader.close();
            return fileContents;
        }
        catch (IOException ioe) {
            Message msg = new Message("Could not update build config file.", IMessage.ERROR, ioe, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
            return null;
        }
    }

    public void writeConfigFile(String filePath, List<BuildConfigNode> files, List<BuildConfigNode> importedNodes) {
        String fileContentsString = "";
        HashSet<String> includedFiles = new HashSet<String>();
        for (BuildConfigNode node : importedNodes) {
            fileContentsString = fileContentsString + '@' + node.getResourcePath() + "\n";
            String parentPath = new File(filePath).getParent();
            String importedFilePath = parentPath + File.separator + node.getResourcePath();
            includedFiles.addAll(this.getIncludedFiles(importedFilePath, parentPath));
        }
        for (BuildConfigNode node : files) {
            if (node.getName().endsWith(".lst") && !node.getResourcePath().startsWith("..")) {
                fileContentsString = fileContentsString + '@';
                fileContentsString = fileContentsString + node.getResourcePath() + "\n";
                continue;
            }
            if (includedFiles.contains(node.getResourcePath())) continue;
            fileContentsString = fileContentsString + node.getResourcePath() + "\n";
        }
        this.writeFile(fileContentsString, filePath);
    }

    private List<String> getIncludedFiles(String path, String rootPath) {
        try {
            ConfigParser configParser = new ConfigParser();
            configParser.parseConfigFile(new File(path));
            List<File> files = configParser.getFiles();
            ArrayList<String> relativeFiles = new ArrayList<String>();
            for (File file : files) {
                relativeFiles.add(this.relativizePath(file.getPath(), rootPath));
            }
            return relativeFiles;
        }
        catch (ConfigParser.ParseException pe) {
            return new ArrayList<String>();
        }
    }

    public String relativizePath(String path, String rootPath) {
        int pathIndex = (path = path.replace('\\', '/')).indexOf(rootPath = rootPath.replace('\\', '/'));
        if (pathIndex > -1) {
            return path.substring(pathIndex + rootPath.length() + 1);
        }
        return path;
    }

    public void writeConfigFile(String filePath, List<String> fileContents) {
        TreeSet<String> contentsSet = new TreeSet<String>(fileContents);
        StringBuffer fileContentsSB = new StringBuffer();
        for (String s : contentsSet) {
            fileContentsSB.append(s.toString());
            fileContentsSB.append("\n");
        }
        this.writeFile(fileContentsSB.toString(), filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String contents, String filePath) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath, false);
            fos.write(contents.getBytes());
        }
        catch (IOException ioe) {
            Message msg = new Message("Could not update build config file: " + filePath, IMessage.ERROR, ioe, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

