/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.ajde.core.internal.AjdeCoreBuildNotifierAdapter;
import org.aspectj.ajde.core.internal.AjdeCoreMessageHandlerAdapter;
import org.aspectj.ajde.core.internal.OutputLocationAdapter;
import org.aspectj.ajdt.ajc.AjdtCommand;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.util.LangUtil;

public class AjdeCoreBuildManager {
    private final AjCompiler compiler;
    private AjdeCoreBuildNotifierAdapter buildEventNotifier = null;
    private final AjBuildManager ajBuildManager;
    private final IMessageHandler msgHandlerAdapter;

    public AjdeCoreBuildManager(AjCompiler compiler) {
        this.compiler = compiler;
        this.msgHandlerAdapter = new AjdeCoreMessageHandlerAdapter(compiler.getMessageHandler());
        this.ajBuildManager = new AjBuildManager(this.msgHandlerAdapter);
        this.ajBuildManager.environmentSupportsIncrementalCompilation(true);
        IncrementalStateManager.recordIncrementalStates = true;
        IncrementalStateManager.debugIncrementalStates = false;
        AsmManager.attemptIncrementalModelRepairs = true;
    }

    public AjBuildManager getAjBuildManager() {
        return this.ajBuildManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBuild(boolean fullBuild) {
        if (!fullBuild) {
            AjState existingState = IncrementalStateManager.retrieveStateFor(this.compiler.getId());
            if (existingState == null || existingState.getBuildConfig() == null || this.ajBuildManager.getState().getBuildConfig() == null) {
                fullBuild = true;
            } else {
                AsmManager.setLastActiveStructureModel(existingState.getStructureModel());
            }
        }
        try {
            AjBuildConfig buildConfig;
            this.reportProgressBegin();
            if (!this.msgHandlerAdapter.isIgnoring(IMessage.INFO)) {
                this.handleMessage(new Message(this.getFormattedOptionsString(), IMessage.INFO, null, null));
            }
            CompilationAndWeavingContext.reset();
            if (fullBuild) {
                buildConfig = this.generateAjBuildConfig();
                if (buildConfig == null) {
                    return;
                }
                this.ajBuildManager.batchBuild(buildConfig, this.msgHandlerAdapter);
            } else {
                buildConfig = null;
                ICompilerConfiguration compilerConfig = this.compiler.getCompilerConfiguration();
                int changes = compilerConfig.getConfigurationChanges();
                if (changes != 0) {
                    buildConfig = this.generateAjBuildConfig();
                    if (buildConfig == null) {
                        return;
                    }
                } else {
                    buildConfig = this.ajBuildManager.getState().getBuildConfig();
                    buildConfig.setChanged(changes);
                    buildConfig.setModifiedFiles(compilerConfig.getProjectSourceFilesChanged());
                    buildConfig.setClasspathElementsWithModifiedContents(compilerConfig.getClasspathElementsWithModifiedContents());
                    compilerConfig.configurationRead();
                }
                this.ajBuildManager.incrementalBuild(buildConfig, this.msgHandlerAdapter);
            }
            IncrementalStateManager.recordSuccessfulBuild(this.compiler.getId(), this.ajBuildManager.getState());
        }
        catch (ConfigParser.ParseException pe) {
            this.handleMessage(new Message("Config file entry invalid, file: " + pe.getFile().getPath() + ", line number: " + pe.getLine(), IMessage.WARNING, null, null));
        }
        catch (AbortException e) {
            IMessage message = e.getIMessage();
            if (message == null) {
                this.handleMessage(new Message(LangUtil.unqualifiedClassName(e) + " thrown: " + e.getMessage(), IMessage.ERROR, e, null));
            } else {
                this.handleMessage(new Message(message.getMessage() + "\n" + CompilationAndWeavingContext.getCurrentContext(), IMessage.ERROR, e, null));
            }
        }
        catch (Throwable t) {
            this.handleMessage(new Message("Compile error: " + LangUtil.unqualifiedClassName(t) + " thrown: " + t.getMessage(), IMessage.ABORT, t, null));
        }
        finally {
            this.compiler.getBuildProgressMonitor().finish(this.ajBuildManager.wasFullBuild());
        }
    }

    private void reportProgressBegin() {
        this.compiler.getBuildProgressMonitor().begin();
        this.buildEventNotifier = new AjdeCoreBuildNotifierAdapter(this.compiler.getBuildProgressMonitor());
        this.ajBuildManager.setProgressListener(this.buildEventNotifier);
    }

    private String getFormattedOptionsString() {
        ICompilerConfiguration compilerConfig = this.compiler.getCompilerConfiguration();
        return "Building with settings: \n-> output paths: " + this.formatCollection(compilerConfig.getOutputLocationManager().getAllOutputLocations()) + "\n-> classpath: " + compilerConfig.getClasspath() + "\n-> -inpath " + this.formatCollection(compilerConfig.getInpath()) + "\n-> -outjar " + this.formatOptionalString(compilerConfig.getOutJar()) + "\n-> -aspectpath " + this.formatCollection(compilerConfig.getAspectPath()) + "\n-> -sourcePathResources " + this.formatMap(compilerConfig.getSourcePathResources()) + "\n-> non-standard options: " + compilerConfig.getNonStandardOptions() + "\n-> javaoptions:" + this.formatMap(compilerConfig.getJavaOptionsMap());
    }

    private String formatCollection(Collection<?> options) {
        if (options == null) {
            return "<default>";
        }
        if (options.isEmpty()) {
            return "none";
        }
        StringBuffer formattedOptions = new StringBuffer();
        for (Object option : options) {
            String o = option.toString();
            if (formattedOptions.length() > 0) {
                formattedOptions.append(", ");
            }
            formattedOptions.append(o);
        }
        return formattedOptions.toString();
    }

    private String formatMap(Map<String, ? extends Object> options) {
        if (options == null) {
            return "<default>";
        }
        if (options.isEmpty()) {
            return "none";
        }
        return options.toString();
    }

    private String formatOptionalString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public AjBuildConfig generateAjBuildConfig() {
        String message;
        String outJar;
        File configFile = new File(this.compiler.getId());
        ICompilerConfiguration compilerConfig = this.compiler.getCompilerConfiguration();
        CountingMessageHandler handler = CountingMessageHandler.makeCountingMessageHandler(this.msgHandlerAdapter);
        String[] args = null;
        if (configFile.exists() && configFile.isFile()) {
            args = new String[]{"@" + configFile.getAbsolutePath()};
        } else {
            List<String> xmlfiles;
            String processorPath;
            List<String> projectSourceFiles = compilerConfig.getProjectSourceFiles();
            if (projectSourceFiles == null) {
                return null;
            }
            ArrayList<String> l = new ArrayList<String>(projectSourceFiles);
            String processor = compilerConfig.getProcessor();
            if (processor != null && processor.length() != 0) {
                l.add("-processor");
                l.add(processor);
            }
            if ((processorPath = compilerConfig.getProcessorPath()) != null && processorPath.length() != 0) {
                l.add("-processorpath");
                l.add(processorPath);
            }
            if (compilerConfig.getOutputLocationManager() != null && compilerConfig.getOutputLocationManager().getDefaultOutputLocation() != null) {
                l.add("-d");
                l.add(compilerConfig.getOutputLocationManager().getDefaultOutputLocation().toString());
            }
            if ((xmlfiles = compilerConfig.getProjectXmlConfigFiles()) != null && !xmlfiles.isEmpty()) {
                args = new String[l.size() + xmlfiles.size() + 1];
                int p = 0;
                for (String s : l) {
                    args[p++] = s;
                }
                for (String xmlfile : xmlfiles) {
                    args[p++] = xmlfile;
                }
                args[p++] = "-xmlConfigured";
            } else {
                args = l.toArray(new String[0]);
            }
        }
        BuildArgParser parser = new BuildArgParser(handler);
        AjBuildConfig config = new AjBuildConfig(parser);
        parser.populateBuildConfig(config, args, false, configFile);
        String propcp = compilerConfig.getClasspath();
        if (propcp != null && propcp.length() != 0) {
            StringTokenizer st = new StringTokenizer(propcp, File.pathSeparator);
            List<String> configClasspath = config.getClasspath();
            ArrayList<String> toAdd = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                if (configClasspath.contains(entry)) continue;
                toAdd.add(entry);
            }
            if (0 < toAdd.size()) {
                ArrayList<String> both = new ArrayList<String>(configClasspath.size() + toAdd.size());
                both.addAll(configClasspath);
                both.addAll(toAdd);
                config.setClasspath(both);
                FileSystem.Classpath[] checkedClasspaths = config.getCheckedClasspaths();
                ArrayList<FileSystem.Classpath> cps = parser.handleClasspath(toAdd, compilerConfig.getProjectEncoding());
                FileSystem.Classpath[] newCheckedClasspaths = new FileSystem.Classpath[checkedClasspaths.length + cps.size()];
                System.arraycopy(checkedClasspaths, 0, newCheckedClasspaths, 0, checkedClasspaths.length);
                for (int i = 0; i < cps.size(); ++i) {
                    newCheckedClasspaths[checkedClasspaths.length + i] = cps.get(i);
                }
                config.setCheckedClasspaths(newCheckedClasspaths);
            }
        }
        if (config.getOutputJar() == null && (outJar = compilerConfig.getOutJar()) != null && outJar.length() != 0) {
            config.setOutputJar(new File(outJar));
        }
        IOutputLocationManager outputLocationManager = compilerConfig.getOutputLocationManager();
        if (config.getCompilationResultDestinationManager() == null && outputLocationManager != null) {
            config.setCompilationResultDestinationManager(new OutputLocationAdapter(outputLocationManager));
        }
        config.addToInpath(compilerConfig.getInpath());
        if (config.getInpath() != null) {
            config.processInPath();
        }
        config.setSourcePathResources(compilerConfig.getSourcePathResources());
        config.addToAspectpath(compilerConfig.getAspectPath());
        Map<String, String> jom = compilerConfig.getJavaOptionsMap();
        if (jom != null) {
            String version = jom.get("org.eclipse.jdt.core.compiler.compliance");
            if (version != null && !version.equals("1.4")) {
                config.setBehaveInJava5Way(true);
            }
            config.getOptions().set(jom);
        }
        this.configureNonStandardOptions(config);
        compilerConfig.configurationRead();
        SourceLocation location = null;
        if (config.getConfigFile() != null) {
            location = new SourceLocation(config.getConfigFile(), 0);
        }
        if (null != (message = parser.getOtherMessages(true))) {
            Message m = new Message(message, IMessage.ERROR, null, location);
            handler.handleMessage(m);
        }
        config.setGenerateModelMode(true);
        config.setIncrementalMode(true);
        config.setProceedOnError(true);
        config.setProjectEncoding(compilerConfig.getProjectEncoding());
        config.setProcessor(compilerConfig.getProcessor());
        config.setProcessorPath(compilerConfig.getProcessorPath());
        return config;
    }

    private void configureNonStandardOptions(AjBuildConfig config) {
        String nonStdOptions = this.compiler.getCompilerConfiguration().getNonStandardOptions();
        if (LangUtil.isEmpty(nonStdOptions)) {
            return;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int ind = nonStdOptions.indexOf(34);
        int ind2 = nonStdOptions.indexOf(34, ind + 1);
        if (ind > -1 && ind2 > -1) {
            String pre = nonStdOptions.substring(0, ind);
            String quoted = nonStdOptions.substring(ind + 1, ind2);
            String post = nonStdOptions.substring(ind2 + 1, nonStdOptions.length());
            tokens.addAll(this.tokenizeString(pre));
            tokens.add(quoted);
            tokens.addAll(this.tokenizeString(post));
        } else {
            tokens.addAll(this.tokenizeString(nonStdOptions));
        }
        String[] args = tokens.toArray(new String[0]);
        CountingMessageHandler counter = CountingMessageHandler.makeCountingMessageHandler(this.msgHandlerAdapter);
        AjBuildConfig altConfig = AjdtCommand.genBuildConfig(args, counter);
        if (counter.hasErrors()) {
            return;
        }
        config.installGlobals(altConfig);
    }

    private List<String> tokenizeString(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(str);
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        return tokens;
    }

    private void handleMessage(Message msg) {
        this.compiler.getMessageHandler().handleMessage(msg);
    }

    public void setCustomMungerFactory(Object o) {
        this.ajBuildManager.setCustomMungerFactory(o);
    }

    public Object getCustomMungerFactory() {
        return this.ajBuildManager.getCustomMungerFactory();
    }

    public void cleanupEnvironment() {
        this.ajBuildManager.cleanupEnvironment();
    }

    public AsmManager getStructureModel() {
        return this.ajBuildManager.getStructureModel();
    }
}

