/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.BatchFilerImpl;
import org.aspectj.org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.CompilationUnit;

public final class AjBatchFilerImpl
extends BatchFilerImpl {
    public AjBatchFilerImpl(BaseAnnotationProcessorManager dispatchManager, BatchProcessingEnvImpl env) {
        super(dispatchManager, env);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        String name = String.valueOf(relativeName);
        FileObject resource = super.createResource(location, pkg, relativeName, originatingElements);
        return name.endsWith(".aj") ? new HookedFileObject(resource) : resource;
    }

    private final class HookedFileObject
    implements FileObject {
        private final FileObject fileObject;
        private boolean _closed = false;

        HookedFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        @Override
        public URI toUri() {
            return this.fileObject.toUri();
        }

        @Override
        public String getName() {
            return this.fileObject.getName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.fileObject.openInputStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new ForwardingOutputStream(this.fileObject.openOutputStream());
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return this.fileObject.openReader(ignoreEncodingErrors);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.fileObject.getCharContent(ignoreEncodingErrors);
        }

        @Override
        public Writer openWriter() throws IOException {
            return new ForwardingWriter(this.fileObject.openWriter());
        }

        @Override
        public long getLastModified() {
            return this.fileObject.getLastModified();
        }

        @Override
        public boolean delete() {
            return this.fileObject.delete();
        }

        private void onClose() {
            if (this._closed) {
                return;
            }
            this._closed = true;
            String name = this.fileObject.getName();
            CompilationUnit unit = new CompilationUnit(null, name, null);
            AjBatchFilerImpl.this.addNewUnit(unit);
        }

        private final class ForwardingOutputStream
        extends OutputStream {
            private final OutputStream stream;

            public ForwardingOutputStream(OutputStream stream) {
                this.stream = stream;
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.stream.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.stream.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.stream.flush();
            }

            @Override
            public void close() throws IOException {
                this.stream.close();
                HookedFileObject.this.onClose();
            }

            @Override
            public void write(int b) throws IOException {
                this.stream.write(b);
            }
        }

        private final class ForwardingWriter
        extends Writer {
            private final Writer writer;

            public ForwardingWriter(Writer writer) {
                this.writer = writer;
            }

            @Override
            public void write(int c) throws IOException {
                this.writer.write(c);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                this.writer.write(cbuf);
            }

            @Override
            public void write(String str) throws IOException {
                this.writer.write(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                this.writer.write(str, off, len);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.writer.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
                HookedFileObject.this.onClose();
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                this.writer.append(csq);
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                this.writer.append(csq, start, end);
                return this;
            }

            @Override
            public Writer append(char c) throws IOException {
                this.writer.append(c);
                return this;
            }
        }
    }
}

