/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences.legacy;

import java.lang.reflect.Field;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InitLegacyPreferences
implements ILegacyPreferences {
    @Override
    @Deprecated
    public Object init(Object object, String name) {
        Plugin plugin = null;
        if (object instanceof Plugin) {
            plugin = (Plugin)object;
        } else {
            plugin = this.getActivator(name);
            if (plugin == null) {
                if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
                    InternalPlatform.message("No plug-in object available to set plug-in default preference overrides for:" + name);
                }
                return null;
            }
        }
        if (InternalPlatform.DEBUG_PLUGIN_PREFERENCES) {
            InternalPlatform.message("Applying plug-in default preference overrides for plug-in: " + plugin.getBundle().getBundleId());
        }
        plugin.internalInitializeDefaultPluginPreferences();
        return plugin;
    }

    private Plugin getActivator(String name) {
        Bundle bundle = InternalPlatform.getDefault().getBundle(name);
        if (bundle == null) {
            return null;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            return null;
        }
        try {
            Field field = context.getClass().getDeclaredField("activator");
            field.setAccessible(true);
            Object activator = field.get(context);
            if (activator instanceof Plugin) {
                return (Plugin)activator;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            InitLegacyPreferences.log(ex, name);
        }
        return null;
    }

    private static void log(Exception ex, String name) {
        Status status = new Status(4, "org.eclipse.core.runtime", 4, NLS.bind(Messages.plugin_unableToGetActivator, name), ex);
        InternalPlatform.getDefault().log(status);
    }
}

