/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
							TokenNameWHITESPACE = 1000,
							TokenNameCOMMENT_LINE = 1001,
							TokenNameCOMMENT_BLOCK = 1002,
							TokenNameCOMMENT_JAVADOC = 1003,
							TokenNameSingleQuoteStringLiteral = 1004,
							TokenNameCOMMENT_MARKDOWN = 1005;

	static boolean isRestrictedKeyword(int tokenType) {
		return switch (tokenType) {
			case TokenNameRestrictedIdentifierYield, TokenNameRestrictedIdentifierrecord,TokenNameRestrictedIdentifierWhen,
					TokenNameRestrictedIdentifiersealed, TokenNameRestrictedIdentifierpermits -> true;
			default -> false;
		};
	}

	static int getRestrictedKeyword(char [] text) {
		if (text != null) {
			int len = text.length;
			if (len == 4 && text[0] == 'w' ||
				len == 5 && text[0] == 'y' ||
				len == 6 && (text[0] == 'r' || text[0] == 's') ||
				len == 7 && text[0] == 'p') {
				return getRestrictedKeyword(new String(text));
			}
		}
		return TokenNameNotAToken;
	}

	static int getRestrictedKeyword(String text) {
		return switch (text) {
			case "yield"   -> TokenNameRestrictedIdentifierYield;   //$NON-NLS-1$
			case "record"  -> TokenNameRestrictedIdentifierrecord;  //$NON-NLS-1$
			case "when"    -> TokenNameRestrictedIdentifierWhen;    //$NON-NLS-1$
			case "sealed"  -> TokenNameRestrictedIdentifiersealed;  //$NON-NLS-1$
			case "permits" -> TokenNameRestrictedIdentifierpermits; //$NON-NLS-1$
			default        -> TokenNameNotAToken;
		};
	}

	// AspectJ: Tokens taken from javasym.java, generated by jikespg according to
	// https://www.eclipse.org/jdt/core/howto/generate%20parser/generateParser.html
	//
	// TODO Every time when updating tokens, make sure to rename
	//   - TokenName$eof -> TokenNameEOF
	//   - TokenName$error -> TokenNameERROR
	//   - TokenNamenon-sealed -> TokenNamenon_sealed
	int
    TokenNameIdentifier = 12,
    TokenNameabstract = 49,
    TokenNameassert = 87,
    TokenNameboolean = 119,
    TokenNamebreak = 88,
    TokenNamebyte = 120,
    TokenNamecase = 98,
    TokenNamecatch = 99,
    TokenNamechar = 121,
    TokenNameclass = 76,
    TokenNamecontinue = 89,
    TokenNameconst = 143,
    TokenNamedefault = 96,
    TokenNamedo = 90,
    TokenNamedouble = 122,
    TokenNameelse = 105,
    TokenNameenum = 81,
    TokenNameextends = 97,
    TokenNamefalse = 61,
    TokenNamefinal = 50,
    TokenNamefinally = 102,
    TokenNamefloat = 123,
    TokenNamefor = 91,
    TokenNamegoto = 144,
    TokenNameif = 92,
    TokenNameimplements = 106,
    TokenNameimport = 100,
    TokenNameinstanceof = 17,
    TokenNameint = 124,
    TokenNameinterface = 80,
    TokenNamelong = 125,
    TokenNamenative = 51,
    TokenNamenew = 43,
    TokenNamenon_sealed = 52,
    TokenNamenull = 62,
    TokenNamepackage = 95,
    TokenNameprivate = 53,
    TokenNameprotected = 54,
    TokenNamepublic = 55,
    TokenNamereturn = 93,
    TokenNameshort = 126,
    TokenNamestatic = 44,
    TokenNamestrictfp = 56,
    TokenNamesuper = 46,
    TokenNameswitch = 71,
    TokenNamesynchronized = 45,
    TokenNamethis = 47,
    TokenNamethrow = 85,
    TokenNamethrows = 103,
    TokenNametransient = 57,
    TokenNametrue = 63,
    TokenNametry = 94,
    TokenNamevoid = 127,
    TokenNamevolatile = 58,
    TokenNamewhile = 86,
    TokenNamemodule = 128,
    TokenNameopen = 130,
    TokenNamerequires = 131,
    TokenNametransitive = 136,
    TokenNameexports = 132,
    TokenNameopens = 133,
    TokenNameto = 141,
    TokenNameuses = 134,
    TokenNameprovides = 135,
    TokenNamewith = 142,
    TokenNameaspect = 24,
    TokenNamepointcut = 28,
    TokenNamearound = 33,
    TokenNamebefore = 30,
    TokenNameafter = 31,
    TokenNamedeclare = 32,
    TokenNameprivileged = 26,
    TokenNameIntegerLiteral = 64,
    TokenNameLongLiteral = 65,
    TokenNameFloatingPointLiteral = 66,
    TokenNameDoubleLiteral = 67,
    TokenNameCharacterLiteral = 68,
    TokenNameStringLiteral = 69,
    TokenNameTextBlock = 70,
    TokenNamePLUS_PLUS = 3,
    TokenNameMINUS_MINUS = 4,
    TokenNameEQUAL_EQUAL = 23,
    TokenNameLESS_EQUAL = 18,
    TokenNameGREATER_EQUAL = 19,
    TokenNameNOT_EQUAL = 20,
    TokenNameLEFT_SHIFT = 21,
    TokenNameRIGHT_SHIFT = 13,
    TokenNameUNSIGNED_RIGHT_SHIFT = 16,
    TokenNamePLUS_EQUAL = 108,
    TokenNameMINUS_EQUAL = 109,
    TokenNameMULTIPLY_EQUAL = 110,
    TokenNameDIVIDE_EQUAL = 111,
    TokenNameAND_EQUAL = 112,
    TokenNameOR_EQUAL = 113,
    TokenNameXOR_EQUAL = 114,
    TokenNameREMAINDER_EQUAL = 115,
    TokenNameLEFT_SHIFT_EQUAL = 116,
    TokenNameRIGHT_SHIFT_EQUAL = 117,
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 118,
    TokenNameOR_OR = 38,
    TokenNameAND_AND = 37,
    TokenNamePLUS = 2,
    TokenNameMINUS = 6,
    TokenNameNOT = 74,
    TokenNameREMAINDER = 10,
    TokenNameXOR = 34,
    TokenNameAND = 22,
    TokenNameMULTIPLY = 8,
    TokenNameOR = 36,
    TokenNameTWIDDLE = 77,
    TokenNameDIVIDE = 11,
    TokenNameGREATER = 15,
    TokenNameLESS = 7,
    TokenNameLPAREN = 14,
    TokenNameRPAREN = 27,
    TokenNameLBRACE = 59,
    TokenNameRBRACE = 41,
    TokenNameLBRACKET = 5,
    TokenNameRBRACKET = 75,
    TokenNameSEMICOLON = 29,
    TokenNameQUESTION = 35,
    TokenNameCOLON = 72,
    TokenNameCOMMA = 39,
    TokenNameDOT = 1,
    TokenNameEQUAL = 79,
    TokenNameAT = 40,
    TokenNameELLIPSIS = 104,
    TokenNameARROW = 129,
    TokenNameCOLON_COLON = 9,
    TokenNameBeginLambda = 73,
    TokenNameBeginIntersectionCast = 78,
    TokenNameBeginTypeArguments = 101,
    TokenNameElidedSemicolonAndRightBrace = 82,
    TokenNameAT308 = 25,
    TokenNameAT308DOTDOTDOT = 137,
    TokenNameCaseArrow = 83,
    TokenNameRestrictedIdentifierYield = 107,
    TokenNameRestrictedIdentifierrecord = 84,
    TokenNameRestrictedIdentifiersealed = 48,
    TokenNameRestrictedIdentifierpermits = 138,
    TokenNameBeginCasePattern = 139,
    TokenNameRestrictedIdentifierWhen = 140,
    TokenNameUNDERSCORE = 42,
    TokenNameEOF = 60,
    TokenNameERROR = 145;
}
