/*******************************************************************************
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.codeassist.select;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;

/*
 * Selection node build by the parser in any case it was intending to
 * reduce an export reference containing the assist identifier.
 * e.g.
 *
 *	module myModule {
 *  exports packageo[cursor];
 *  }
 *
 *	module myModule {
 *	---> <SelectionOnExport:packageo>
 *  }
 *
 */
public class SelectionOnPackageVisibilityReference extends ImportReference {

	public SelectionOnPackageVisibilityReference(char[][] tokens, long[] positions) {
		super(tokens, positions, false, 0);
	}

	@Override
	public StringBuffer print(int indent, StringBuffer output) {

		printIndent(indent, output).append("<SelectOnPackageVisibility:"); //$NON-NLS-1$
		output.append(new String(CharOperation.concatWith(this.tokens, '.')));
		return output.append('>');
	}
}
