/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTParser;
import org.aspectj.org.eclipse.jdt.core.dom.Comment;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.aspectj.org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.formatter.CommentsPreparator;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.aspectj.org.eclipse.jdt.internal.formatter.LineBreaksPreparator;
import org.aspectj.org.eclipse.jdt.internal.formatter.SpacePreparator;
import org.aspectj.org.eclipse.jdt.internal.formatter.TextEditsBuilder;
import org.aspectj.org.eclipse.jdt.internal.formatter.Token;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenManager;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.WrapPreparator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class DefaultCodeFormatter
extends CodeFormatter {
    public static boolean DEBUG = false;
    private static final int K_COMMENTS_MASK = 112;
    private static final int K_MASK = 127;
    private DefaultCodeFormatterOptions originalOptions;
    private DefaultCodeFormatterOptions workingOptions;
    private Object oldCommentFormatOption;
    private String sourceLevel;
    private String sourceString;
    private char[] sourceArray;
    private ASTNode astRoot;
    private List<Token> tokens = new ArrayList<Token>();
    private TokenManager tokenManager;

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions options) {
        this(options, null);
    }

    public DefaultCodeFormatter(Map<String, String> options) {
        this(null, options);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        this.initOptions(defaultCodeFormatterOptions, options);
    }

    private void initOptions(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        if (options != null) {
            this.originalOptions = new DefaultCodeFormatterOptions(options);
            this.workingOptions = new DefaultCodeFormatterOptions(options);
            this.oldCommentFormatOption = this.getOldCommentFormatOption(options);
            String compilerSource = options.get("org.eclipse.jdt.core.compiler.source");
            this.sourceLevel = compilerSource != null ? compilerSource : "1.8";
        } else {
            Map settings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
            this.originalOptions = new DefaultCodeFormatterOptions(settings);
            this.workingOptions = new DefaultCodeFormatterOptions(settings);
            this.oldCommentFormatOption = "true";
            this.sourceLevel = "1.8";
        }
        if (defaultCodeFormatterOptions != null) {
            this.originalOptions.set(defaultCodeFormatterOptions.getMap());
            this.workingOptions.set(defaultCodeFormatterOptions.getMap());
        }
    }

    @Deprecated
    private Object getOldCommentFormatOption(Map<String, String> options) {
        return options.get("org.aspectj.org.eclipse.jdt.core.formatter.comment.format_comments");
    }

    @Override
    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int indent = indentationLevel * this.originalOptions.indentation_size;
        TextEditsBuilder.appendIndentationString(sb, this.originalOptions.tab_char, this.originalOptions.tab_size, indent, 0);
        return sb.toString();
    }

    @Override
    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        return this.format(kind, source, new IRegion[]{new Region(offset, length)}, indentationLevel, lineSeparator);
    }

    @Override
    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        if (!this.regionsSatisfiesPreconditions(regions, source.length())) {
            throw new IllegalArgumentException();
        }
        this.updateWorkingOptions(indentationLevel, lineSeparator, kind);
        if ((kind & 0x70) != 0) {
            return this.formatComments(source, kind & 0x70, regions);
        }
        if (this.prepareFormattedCode(source, kind) == null) {
            return this.tokens.isEmpty() ? new MultiTextEdit() : null;
        }
        MultiTextEdit result = new MultiTextEdit();
        TextEditsBuilder resultBuilder = new TextEditsBuilder(this.sourceString, regions, this.tokenManager, this.workingOptions);
        this.tokenManager.traverse(0, resultBuilder);
        for (TextEdit edit : resultBuilder.getEdits()) {
            result.addChild(edit);
        }
        return result;
    }

    private boolean init(String source) {
        this.sourceString = source;
        this.sourceArray = source.toCharArray();
        this.tokens.clear();
        this.tokenManager = new TokenManager(this.tokens, source, this.workingOptions);
        this.tokenizeSource();
        return !this.tokens.isEmpty();
    }

    List<Token> prepareFormattedCode(String source, int kind) {
        if (!this.init(source)) {
            return null;
        }
        this.astRoot = this.parseSourceCode(kind);
        if (this.astRoot == null) {
            return null;
        }
        if (kind != 0) {
            this.findHeader();
        }
        this.prepareSpaces();
        this.prepareLineBreaks();
        this.prepareComments();
        this.prepareWraps(kind);
        this.tokenManager.applyFormatOff();
        return this.tokens;
    }

    private void findHeader() {
        List types;
        if (this.astRoot instanceof CompilationUnit && !(types = ((CompilationUnit)this.astRoot).types()).isEmpty()) {
            int headerEndIndex = this.tokenManager.firstIndexIn((ASTNode)types.get(0), -1);
            this.tokenManager.setHeaderEndIndex(headerEndIndex);
        }
    }

    private TextEdit formatComments(String source, int kind, IRegion[] regions) {
        MultiTextEdit result = new MultiTextEdit();
        if (!this.init(source)) {
            return result;
        }
        CommentsPreparator commentsPreparator = new CommentsPreparator(this.tokenManager, this.workingOptions, this.sourceLevel);
        CommentWrapExecutor commentWrapper = new CommentWrapExecutor(this.tokenManager, this.workingOptions);
        switch (kind) {
            case 64: {
                ASTParser parser = ASTParser.newParser(8);
                for (Token token : this.tokens) {
                    if (token.tokenType != 1003) continue;
                    parser.setSourceRange(token.originalStart, token.countChars());
                    CompilationUnit cu = (CompilationUnit)this.parseSourceCode(parser, 8, true);
                    Javadoc javadoc = (Javadoc)cu.getCommentList().get(0);
                    javadoc.accept(commentsPreparator);
                    int startPosition = this.tokenManager.findSourcePositionInLine(token.originalStart);
                    commentWrapper.wrapMultiLineComment(token, startPosition, false, false);
                }
                break;
            }
            case 32: {
                Token token;
                int i = 0;
                while (i < this.tokens.size()) {
                    token = this.tokens.get(i);
                    if (token.tokenType == 1002) {
                        commentsPreparator.handleBlockComment(i);
                        int startPosition = this.tokenManager.findSourcePositionInLine(token.originalStart);
                        commentWrapper.wrapMultiLineComment(token, startPosition, false, false);
                    }
                    ++i;
                }
                break;
            }
            case 16: {
                Token token;
                int i = 0;
                while (i < this.tokens.size()) {
                    token = this.tokens.get(i);
                    if (token.tokenType == 1001) {
                        commentsPreparator.handleLineComment(i);
                        if (i >= this.tokens.size() || this.tokens.get(i) != token) {
                            token = this.tokens.get(--i);
                        }
                        int startPosition = this.tokenManager.findSourcePositionInLine(token.originalStart);
                        commentWrapper.wrapLineComment(token, startPosition);
                    }
                    ++i;
                }
                break;
            }
            default: {
                throw new AssertionError((Object)String.valueOf(kind));
            }
        }
        this.tokenManager.applyFormatOff();
        TextEditsBuilder resultBuilder = new TextEditsBuilder(source, regions, this.tokenManager, this.workingOptions);
        resultBuilder.setAlignChar(2);
        for (Token token : this.tokens) {
            List<Token> structure = token.getInternalStructure();
            if (structure == null || structure.isEmpty()) continue;
            resultBuilder.processComment(token);
        }
        for (TextEdit edit : resultBuilder.getEdits()) {
            result.addChild(edit);
        }
        return result;
    }

    private ASTNode parseSourceCode(int kind) {
        ASTParser parser = ASTParser.newParser(8);
        Hashtable parserOptions = JavaCore.getOptions();
        parserOptions.put("org.eclipse.jdt.core.compiler.source", this.sourceLevel);
        parser.setCompilerOptions(parserOptions);
        switch (kind & 0x7F) {
            case 8: {
                return this.parseSourceCode(parser, 8, true);
            }
            case 4: {
                return this.parseSourceCode(parser, 4, false);
            }
            case 2: {
                return this.parseSourceCode(parser, 2, false);
            }
            case 1: {
                return this.parseSourceCode(parser, 1, false);
            }
            case 0: {
                int[] parserModes;
                int[] nArray = parserModes = new int[]{8, 1, 4, 2};
                int n = parserModes.length;
                int n2 = 0;
                while (n2 < n) {
                    int parserMode = nArray[n2];
                    ASTNode astNode = this.parseSourceCode(parser, parserMode, false);
                    if (astNode != null) {
                        return astNode;
                    }
                    parser.setCompilerOptions(parserOptions);
                    ++n2;
                }
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    private ASTNode parseSourceCode(ASTParser parser, int parserMode, boolean ignoreErrors) {
        parser.setKind(parserMode);
        parser.setSource(this.sourceArray);
        ASTNode astNode = parser.createAST(null);
        if (ignoreErrors) {
            return astNode;
        }
        boolean hasErrors = false;
        CompilationUnit root = (CompilationUnit)astNode.getRoot();
        IProblem[] iProblemArray = root.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                hasErrors = true;
                break;
            }
            ++n2;
        }
        return hasErrors ? null : astNode;
    }

    private void tokenizeSource() {
        this.tokens.clear();
        Scanner scanner = new Scanner(true, false, false, CompilerOptions.versionToJdkLevel(this.sourceLevel), null, null, false);
        scanner.setSource(this.sourceArray);
        while (true) {
            Token token;
            try {
                int tokenType;
                while ((tokenType = scanner.getNextToken()) != 70) {
                    token = Token.fromCurrent(scanner, tokenType);
                    this.tokens.add(token);
                }
            }
            catch (InvalidInputException e) {
                token = Token.fromCurrent(scanner, 0);
                this.tokens.add(token);
                continue;
            }
            break;
        }
    }

    private void prepareSpaces() {
        SpacePreparator spacePreparator = new SpacePreparator(this.tokenManager, this.workingOptions);
        this.astRoot.accept(spacePreparator);
        spacePreparator.finishUp();
    }

    private void prepareLineBreaks() {
        LineBreaksPreparator breaksPreparator = new LineBreaksPreparator(this.tokenManager, this.workingOptions);
        this.astRoot.accept(breaksPreparator);
        breaksPreparator.finishUp();
    }

    private void prepareComments() {
        CommentsPreparator commentsPreparator = new CommentsPreparator(this.tokenManager, this.workingOptions, this.sourceLevel);
        List comments = ((CompilationUnit)this.astRoot.getRoot()).getCommentList();
        for (Comment comment : comments) {
            comment.accept(commentsPreparator);
        }
        commentsPreparator.finishUp();
    }

    private void prepareWraps(int kind) {
        WrapPreparator wrapPreparator = new WrapPreparator(this.tokenManager, this.workingOptions, kind);
        this.astRoot.accept(wrapPreparator);
        wrapPreparator.finishUp(this.astRoot);
    }

    private boolean regionsSatisfiesPreconditions(IRegion[] regions, int maxLength) {
        int regionsLength;
        int n = regionsLength = regions == null ? 0 : regions.length;
        if (regionsLength == 0) {
            return false;
        }
        IRegion first = regions[0];
        if (first.getOffset() < 0 || first.getLength() < 0 || first.getOffset() + first.getLength() > maxLength) {
            return false;
        }
        int lastOffset = first.getOffset() + first.getLength() - 1;
        int i = 1;
        while (i < regionsLength) {
            IRegion current = regions[i];
            if (lastOffset > current.getOffset()) {
                return false;
            }
            if (current.getOffset() < 0 || current.getLength() < 0 || current.getOffset() + current.getLength() > maxLength) {
                return false;
            }
            lastOffset = current.getOffset() + current.getLength() - 1;
            ++i;
        }
        return true;
    }

    private void updateWorkingOptions(int indentationLevel, String lineSeparator, int kind) {
        String string = this.workingOptions.line_separator = lineSeparator != null ? lineSeparator : this.originalOptions.line_separator;
        if (this.workingOptions.line_separator == null) {
            this.workingOptions.line_separator = Util.LINE_SEPARATOR;
        }
        this.workingOptions.initial_indentation_level = indentationLevel;
        this.workingOptions.comment_format_javadoc_comment = this.originalOptions.comment_format_javadoc_comment && this.canFormatComment(kind, 64);
        this.workingOptions.comment_format_block_comment = this.originalOptions.comment_format_block_comment && this.canFormatComment(kind, 32);
        this.workingOptions.comment_format_line_comment = this.originalOptions.comment_format_line_comment && this.canFormatComment(kind, 16);
    }

    private boolean canFormatComment(int kind, int commentKind) {
        if ((kind & 0x1000) != 0) {
            return true;
        }
        if ("false".equals(this.oldCommentFormatOption)) {
            return false;
        }
        if ((kind & 0x7F) == commentKind) {
            return true;
        }
        return kind == 0 && "true".equals(this.oldCommentFormatOption);
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.initOptions(null, options);
    }
}

