/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.runtime.internal.AroundClosure;

public class ParameterizedMethodBinding
extends MethodBinding {
    protected MethodBinding originalMethod;

    public ParameterizedMethodBinding(final ParameterizedTypeBinding parameterizedDeclaringClass, MethodBinding originalMethod) {
        super(originalMethod.modifiers, originalMethod.selector, originalMethod.returnType, originalMethod.parameters, originalMethod.thrownExceptions, parameterizedDeclaringClass);
        this.originalMethod = originalMethod;
        this.tagBits = originalMethod.tagBits;
        final TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        Substitution substitution = null;
        final int length = originalVariables.length;
        final boolean isStatic = originalMethod.isStatic();
        if (length == 0) {
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            if (!isStatic) {
                substitution = parameterizedDeclaringClass;
            }
        } else {
            TypeVariableBinding originalVariable;
            final TypeVariableBinding[] substitutedVariables = new TypeVariableBinding[length];
            int i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                substitutedVariables[i] = new TypeVariableBinding(originalVariable.sourceName, this, originalVariable.rank);
                ++i;
            }
            this.typeVariables = substitutedVariables;
            substitution = new Substitution(){

                public LookupEnvironment environment() {
                    return parameterizedDeclaringClass.environment;
                }

                public boolean isRawSubstitution() {
                    return !isStatic && parameterizedDeclaringClass.isRawSubstitution();
                }

                public TypeBinding substitute(TypeVariableBinding typeVariable) {
                    if (typeVariable.rank < length && originalVariables[typeVariable.rank] == typeVariable) {
                        return substitutedVariables[typeVariable.rank];
                    }
                    if (!isStatic) {
                        return parameterizedDeclaringClass.substitute(typeVariable);
                    }
                    return typeVariable;
                }
            };
            i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                TypeVariableBinding substitutedVariable = substitutedVariables[i];
                TypeBinding substitutedSuperclass = Scope.substitute(substitution, originalVariable.superclass);
                ReferenceBinding[] substitutedInterfaces = Scope.substitute(substitution, originalVariable.superInterfaces);
                if (originalVariable.firstBound != null) {
                    substitutedVariable.firstBound = originalVariable.firstBound == originalVariable.superclass ? substitutedSuperclass : substitutedInterfaces[0];
                }
                switch (substitutedSuperclass.kind()) {
                    case 68: {
                        substitutedVariable.superclass = parameterizedDeclaringClass.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                        substitutedVariable.superInterfaces = substitutedInterfaces;
                        break;
                    }
                    default: {
                        if (substitutedSuperclass.isInterface()) {
                            substitutedVariable.superclass = parameterizedDeclaringClass.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                            int interfaceCount = substitutedInterfaces.length;
                            ReferenceBinding[] referenceBindingArray = substitutedInterfaces;
                            substitutedInterfaces = new ReferenceBinding[interfaceCount + 1];
                            System.arraycopy(referenceBindingArray, 0, substitutedInterfaces, 1, interfaceCount);
                            substitutedInterfaces[0] = (ReferenceBinding)substitutedSuperclass;
                            substitutedVariable.superInterfaces = substitutedInterfaces;
                            break;
                        }
                        substitutedVariable.superclass = (ReferenceBinding)substitutedSuperclass;
                        substitutedVariable.superInterfaces = substitutedInterfaces;
                    }
                }
                ++i;
            }
        }
        if (substitution != null) {
            this.returnType = Scope.substitute(substitution, this.returnType);
            this.parameters = Scope.substitute(substitution, this.parameters);
            this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
            if (this.thrownExceptions == null) {
                this.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
        }
    }

    public ParameterizedMethodBinding(ReferenceBinding declaringClass, MethodBinding originalMethod, char[][] alternateParamaterNames, final LookupEnvironment environment) {
        super(originalMethod.modifiers, originalMethod.selector, originalMethod.returnType, originalMethod.parameters, originalMethod.thrownExceptions, declaringClass);
        this.originalMethod = originalMethod;
        this.tagBits = originalMethod.tagBits;
        final TypeVariableBinding[] originalVariables = originalMethod.typeVariables;
        Substitution substitution = null;
        final int length = originalVariables.length;
        if (length == 0) {
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
        } else {
            TypeVariableBinding originalVariable;
            final TypeVariableBinding[] substitutedVariables = new TypeVariableBinding[length];
            int i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                substitutedVariables[i] = new TypeVariableBinding(alternateParamaterNames == null ? originalVariable.sourceName : alternateParamaterNames[i], this, originalVariable.rank);
                ++i;
            }
            this.typeVariables = substitutedVariables;
            substitution = new Substitution(){

                public LookupEnvironment environment() {
                    return environment;
                }

                public boolean isRawSubstitution() {
                    return false;
                }

                public TypeBinding substitute(TypeVariableBinding typeVariable) {
                    if (typeVariable.rank < length && originalVariables[typeVariable.rank] == typeVariable) {
                        return substitutedVariables[typeVariable.rank];
                    }
                    return typeVariable;
                }
            };
            i = 0;
            while (i < length) {
                originalVariable = originalVariables[i];
                TypeVariableBinding substitutedVariable = substitutedVariables[i];
                TypeBinding substitutedSuperclass = Scope.substitute(substitution, originalVariable.superclass);
                ReferenceBinding[] substitutedInterfaces = Scope.substitute(substitution, originalVariable.superInterfaces);
                if (originalVariable.firstBound != null) {
                    substitutedVariable.firstBound = originalVariable.firstBound == originalVariable.superclass ? substitutedSuperclass : substitutedInterfaces[0];
                }
                switch (substitutedSuperclass.kind()) {
                    case 68: {
                        substitutedVariable.superclass = environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                        substitutedVariable.superInterfaces = substitutedInterfaces;
                        break;
                    }
                    default: {
                        if (substitutedSuperclass.isInterface()) {
                            substitutedVariable.superclass = environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                            int interfaceCount = substitutedInterfaces.length;
                            ReferenceBinding[] referenceBindingArray = substitutedInterfaces;
                            substitutedInterfaces = new ReferenceBinding[interfaceCount + 1];
                            System.arraycopy(referenceBindingArray, 0, substitutedInterfaces, 1, interfaceCount);
                            substitutedInterfaces[0] = (ReferenceBinding)substitutedSuperclass;
                            substitutedVariable.superInterfaces = substitutedInterfaces;
                            break;
                        }
                        substitutedVariable.superclass = (ReferenceBinding)substitutedSuperclass;
                        substitutedVariable.superInterfaces = substitutedInterfaces;
                    }
                }
                ++i;
            }
        }
        if (substitution != null) {
            this.returnType = Scope.substitute(substitution, this.returnType);
            this.parameters = Scope.substitute(substitution, this.parameters);
            this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
            if (this.thrownExceptions == null) {
                this.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
        }
    }

    public ParameterizedMethodBinding() {
    }

    public static ParameterizedMethodBinding instantiateGetClass(TypeBinding receiverType, MethodBinding originalMethod, Scope scope) {
        ParameterizedMethodBinding method = new ParameterizedMethodBinding();
        method.modifiers = originalMethod.modifiers;
        method.selector = originalMethod.selector;
        MethodBinding methodBinding = originalMethod;
        method.declaringClass = (ReferenceBinding)ParameterizedMethodBinding.declaringClass_aroundBody1$advice(methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null);
        method.typeVariables = Binding.NO_TYPE_VARIABLES;
        method.originalMethod = originalMethod;
        method.parameters = originalMethod.parameters;
        method.thrownExceptions = originalMethod.thrownExceptions;
        ReferenceBinding genericClassType = scope.getJavaLangClass();
        LookupEnvironment environment = scope.environment();
        TypeBinding rawType = environment.convertToRawType(receiverType.erasure());
        method.returnType = environment.createParameterizedType(genericClassType, new TypeBinding[]{environment.createWildcard(genericClassType, 0, rawType, null, 1)}, null);
        return method;
    }

    public boolean hasSubstitutedParameters() {
        return this.parameters != this.originalMethod.parameters;
    }

    public boolean hasSubstitutedReturnType() {
        return this.returnType != this.originalMethod.returnType;
    }

    public MethodBinding original() {
        return this.originalMethod.original();
    }

    public boolean alwaysNeedsAccessMethod() {
        return this.originalMethod.alwaysNeedsAccessMethod();
    }

    public boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.alwaysNeedsAccessMethod()) {
            return this.originalMethod.canBeSeenBy(receiverType, invocationSite, scope);
        }
        return super.canBeSeenBy(receiverType, invocationSite, scope);
    }

    public MethodBinding getAccessMethod(boolean staticReference) {
        return this.originalMethod.getAccessMethod(staticReference);
    }

    public AbstractMethodDeclaration sourceMethod() {
        return this.originalMethod.sourceMethod();
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(MethodBinding this_, OwningClassSupportForMethodBindings aBinding, MethodBinding ajc_aroundClosure, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(ajc_aroundClosure);
    }
}

