/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.runtime.internal.AroundClosure;

public class MethodVerifier {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    LookupEnvironment environment;
    private boolean allowCompatibleReturnTypes;

    MethodVerifier(LookupEnvironment environment) {
        this.environment = environment;
        this.allowCompatibleReturnTypes = environment.globalOptions.complianceLevel >= 0x310000L && environment.globalOptions.sourceLevel < 0x310000L;
    }

    boolean areMethodsCompatible(MethodBinding one, MethodBinding two) {
        return this.doesMethodOverride(one, two) && this.areReturnTypesCompatible(one, two);
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.areTypesEqual(oneArgs[i], twoArgs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding one, MethodBinding two) {
        MethodBinding methodBinding;
        MethodBinding methodBinding2;
        if (one.returnType == two.returnType) {
            return true;
        }
        if (this.areTypesEqual(one.returnType, two.returnType)) {
            return true;
        }
        if (this.allowCompatibleReturnTypes && (ReferenceBinding)MethodVerifier.declaringClass_aroundBody1$advice(this, methodBinding2 = one, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null) instanceof BinaryTypeBinding && (ReferenceBinding)MethodVerifier.declaringClass_aroundBody3$advice(this, methodBinding = two, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) instanceof BinaryTypeBinding) {
            return this.areReturnTypesCompatible0(one, two);
        }
        return false;
    }

    boolean areReturnTypesCompatible0(MethodBinding one, MethodBinding two) {
        if (one.returnType.isBaseType()) {
            return false;
        }
        MethodBinding methodBinding = one;
        if (!((ReferenceBinding)MethodVerifier.declaringClass_aroundBody5$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null)).isInterface()) {
            MethodBinding methodBinding2 = one;
            if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody7$advice((MethodVerifier)this, (MethodBinding)methodBinding2, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding2, null)).id == 1) {
                return two.returnType.isCompatibleWith(one.returnType);
            }
            return one.returnType.isCompatibleWith(two.returnType);
        }
        MethodBinding methodBinding3 = two;
        if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody9$advice((MethodVerifier)this, (MethodBinding)methodBinding3, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding3, null)).id == 1) {
            return one.returnType.isCompatibleWith(two.returnType);
        }
        MethodBinding methodBinding4 = one;
        MethodBinding methodBinding5 = two;
        if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody11$advice(this, methodBinding4, OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null)).implementsInterface((ReferenceBinding)MethodVerifier.declaringClass_aroundBody13$advice(this, methodBinding5, OwningClassSupportForMethodBindings.aspectOf(), methodBinding5, null), true)) {
            return one.returnType.isCompatibleWith(two.returnType);
        }
        MethodBinding methodBinding6 = two;
        MethodBinding methodBinding7 = one;
        if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody15$advice(this, methodBinding6, OwningClassSupportForMethodBindings.aspectOf(), methodBinding6, null)).implementsInterface((ReferenceBinding)MethodVerifier.declaringClass_aroundBody17$advice(this, methodBinding7, OwningClassSupportForMethodBindings.aspectOf(), methodBinding7, null), true)) {
            return two.returnType.isCompatibleWith(one.returnType);
        }
        return one.returnType.isCompatibleWith(two.returnType) || two.returnType.isCompatibleWith(one.returnType);
    }

    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        if (one instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)one).resolvedType == two;
        }
        if (two instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)two).resolvedType == one;
        }
        return false;
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        if (two != null) {
            MethodBinding methodBinding = one;
            MethodBinding methodBinding2 = two;
            if ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody19$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) != (ReferenceBinding)MethodVerifier.declaringClass_aroundBody21$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null)) {
                return false;
            }
        }
        return true;
    }

    void checkAbstractMethod(MethodBinding abstractMethod) {
        MethodBinding methodBinding = abstractMethod;
        if (this.mustImplementAbstractMethod((ReferenceBinding)MethodVerifier.declaringClass_aroundBody23$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null))) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(abstractMethod);
                missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding currentMethod, MethodBinding[] methods, int length, MethodBinding[] allInheritedMethods) {
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(currentMethod, methods[length - 1]);
            return;
        }
        CompilerOptions options = this.type.scope.compilerOptions();
        int[] overriddenInheritedMethods = length > 1 ? this.findOverriddenInheritedMethods(methods, length) : null;
        int i = length;
        block0: while (--i >= 0) {
            MethodBinding inheritedMethod = methods[i];
            if (overriddenInheritedMethods == null || overriddenInheritedMethods[i] == 0) {
                MethodBinding methodBinding;
                if (currentMethod.isStatic() != inheritedMethod.isStatic()) {
                    this.problemReporter(currentMethod).staticAndInstanceConflict(currentMethod, inheritedMethod);
                    continue;
                }
                currentMethod.modifiers = inheritedMethod.isAbstract() ? (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody25$advice(this, methodBinding = inheritedMethod, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null)).isInterface() ? (currentMethod.modifiers |= 0x20000000) : (currentMethod.modifiers |= 0x30000000)) : (currentMethod.modifiers |= 0x10000000);
                if (!this.areReturnTypesCompatible(currentMethod, inheritedMethod) && this.reportIncompatibleReturnTypeError(currentMethod, inheritedMethod)) continue;
                if (currentMethod.thrownExceptions != Binding.NO_EXCEPTIONS) {
                    this.checkExceptions(currentMethod, inheritedMethod);
                }
                if (inheritedMethod.isFinal()) {
                    this.problemReporter(currentMethod).finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
                }
                if (!this.isAsVisible(currentMethod, inheritedMethod)) {
                    this.problemReporter(currentMethod).visibilityConflict(currentMethod, inheritedMethod);
                }
                if (options.reportDeprecationWhenOverridingDeprecatedMethod && inheritedMethod.isViewedAsDeprecated() && (!currentMethod.isViewedAsDeprecated() || options.reportDeprecationInsideDeprecatedCode)) {
                    MethodBinding methodBinding2 = inheritedMethod;
                    ReferenceBinding declaringClass = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody27$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null);
                    if (declaringClass.isInterface()) {
                        int j = length;
                        while (--j >= 0) {
                            MethodBinding methodBinding3;
                            if (i != j && ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody29$advice(this, methodBinding3 = methods[j], OwningClassSupportForMethodBindings.aspectOf(), methodBinding3, null)).implementsInterface(declaringClass, false)) continue block0;
                        }
                    }
                    this.problemReporter(currentMethod).overridesDeprecatedMethod(currentMethod, inheritedMethod);
                }
            }
            this.checkForBridgeMethod(currentMethod, inheritedMethod, allInheritedMethods);
        }
    }

    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        if (concreteMethod.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, concreteMethod, abstractMethods);
        }
        if (!concreteMethod.isPublic()) {
            int index = 0;
            int length = abstractMethods.length;
            if (concreteMethod.isProtected()) {
                while (index < length) {
                    if (!abstractMethods[index].isPublic()) {
                        ++index;
                        continue;
                    }
                    break;
                }
            } else if (concreteMethod.isDefault()) {
                while (index < length) {
                    if (abstractMethods[index].isDefault()) {
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            if (index < length) {
                this.problemReporter().inheritedMethodReducesVisibility(this.type, concreteMethod, abstractMethods);
            }
        }
        if (concreteMethod.thrownExceptions != Binding.NO_EXCEPTIONS) {
            int i = abstractMethods.length;
            while (--i >= 0) {
                this.checkExceptions(concreteMethod, abstractMethods[i]);
            }
        }
    }

    void checkExceptions(MethodBinding newMethod, MethodBinding inheritedMethod) {
        ReferenceBinding[] newExceptions = this.resolvedExceptionTypesFor(newMethod);
        ReferenceBinding[] inheritedExceptions = this.resolvedExceptionTypesFor(inheritedMethod);
        int i = newExceptions.length;
        while (--i >= 0) {
            ReferenceBinding newException = newExceptions[i];
            int j = inheritedExceptions.length;
            while (--j > -1 && !this.isSameClassOrSubclassOf(newException, inheritedExceptions[j])) {
            }
            if (j != -1 || newException.isUncheckedException(false)) continue;
            this.problemReporter(newMethod).incompatibleExceptionInThrowsClause(this.type, newMethod, inheritedMethod, newException);
        }
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] allInheritedMethods) {
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        int i;
        int i2;
        if (length > 1) {
            int[] overriddenInheritedMethods = this.findOverriddenInheritedMethods(methods, length);
            if (overriddenInheritedMethods != null) {
                int index = 0;
                MethodBinding[] closestMethods = new MethodBinding[length];
                i2 = 0;
                while (i2 < length) {
                    if (overriddenInheritedMethods[i2] == 0) {
                        closestMethods[index++] = methods[i2];
                    }
                    ++i2;
                }
                if (index > 1 && !this.checkInheritedReturnTypes(closestMethods, index)) {
                    return;
                }
            } else if (!this.checkInheritedReturnTypes(methods, length)) {
                return;
            }
        }
        MethodBinding concreteMethod = null;
        if (!this.type.isInterface()) {
            i = length;
            while (--i >= 0) {
                if (methods[i].isAbstract()) continue;
                concreteMethod = methods[i];
                break;
            }
        }
        if (concreteMethod == null) {
            if (!this.type.isAbstract()) {
                i = length;
                while (--i >= 0) {
                    MethodBinding methodBinding = methods[i];
                    if (!this.mustImplementAbstractMethod((ReferenceBinding)MethodVerifier.declaringClass_aroundBody31$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null))) continue;
                    TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                    if (typeDeclaration != null) {
                        MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(methods[0]);
                        missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    }
                    return;
                }
            }
            return;
        }
        if (length > 1) {
            MethodBinding[] abstractMethods = new MethodBinding[length - 1];
            int index = 0;
            i2 = length;
            while (--i2 >= 0) {
                if (methods[i2] == concreteMethod) continue;
                abstractMethods[index++] = methods[i2];
            }
            this.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
        }
    }

    boolean checkInheritedReturnTypes(MethodBinding[] methods, int length) {
        MethodBinding first = methods[0];
        int index = length;
        while (--index > 0 && this.areReturnTypesCompatible(first, methods[index])) {
        }
        if (index == 0) {
            return true;
        }
        if (this.type.isInterface()) {
            int i = length;
            while (--i >= 0) {
                MethodBinding methodBinding = methods[i];
                if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody33$advice((MethodVerifier)this, (MethodBinding)methodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding, null)).id != 1) continue;
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methods, length);
        return false;
    }

    void checkMethods() {
        boolean mustImplementAbstractMethods = this.mustImplementAbstractMethods();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.canSkipInheritedMethods();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            int j;
            int i;
            MethodBinding[] current;
            if (methodSelectors[s] == null || (current = (MethodBinding[])this.currentMethods.get(methodSelectors[s])) == null && skipInheritedMethods) continue;
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            if (current != null) {
                i = 0;
                int length1 = current.length;
                while (i < length1) {
                    MethodBinding currentMethod = current[i];
                    j = 0;
                    int length2 = inherited.length;
                    while (j < length2) {
                        MethodBinding inheritedMethod = this.computeSubstituteMethod(inherited[j], currentMethod);
                        if (inheritedMethod != null && this.doesMethodOverride(currentMethod, inheritedMethod)) {
                            matchingInherited[++index] = inheritedMethod;
                            inherited[j] = null;
                        }
                        ++j;
                    }
                    if (index >= 0) {
                        this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1, inherited);
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            int length = inherited.length;
            while (i < length) {
                MethodBinding inheritedMethod = inherited[i];
                if (inheritedMethod != null) {
                    matchingInherited[++index] = inheritedMethod;
                    j = i + 1;
                    while (j < length) {
                        MethodBinding otherInheritedMethod = inherited[j];
                        if (!this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) && (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) != null && this.doesMethodOverride(inheritedMethod, otherInheritedMethod)) {
                            matchingInherited[++index] = otherInheritedMethod;
                            inherited[j] = null;
                        }
                        ++j;
                    }
                    if (index != -1) {
                        if (index > 0) {
                            this.checkInheritedMethods(matchingInherited, index + 1);
                        } else if (mustImplementAbstractMethods && matchingInherited[0].isAbstract()) {
                            this.checkAbstractMethod(matchingInherited[0]);
                        }
                        while (index >= 0) {
                            matchingInherited[index--] = null;
                        }
                    }
                }
                ++i;
            }
        }
    }

    void checkPackagePrivateAbstractMethod(MethodBinding abstractMethod) {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = abstractMethod;
        PackageBinding necessaryPackage = ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody35$advice((MethodVerifier)this, (MethodBinding)methodBinding2, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding2, null)).fPackage;
        if (necessaryPackage == this.type.fPackage) {
            return;
        }
        ReferenceBinding superType = this.type.superclass();
        char[] selector = abstractMethod.selector;
        do {
            if (!superType.isValidBinding()) {
                return;
            }
            if (!superType.isAbstract()) {
                return;
            }
            if (necessaryPackage != superType.fPackage) continue;
            MethodBinding[] methods = superType.getMethods(selector);
            int m = methods.length;
            while (--m >= 0) {
                MethodBinding method = methods[m];
                if (method.isPrivate() || method.isConstructor() || method.isDefaultAbstract() || !this.areMethodsCompatible(method, abstractMethod)) continue;
                return;
            }
        } while ((superType = superType.superclass()) != (ReferenceBinding)MethodVerifier.declaringClass_aroundBody37$advice(this, methodBinding = abstractMethod, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, abstractMethod);
    }

    void computeInheritedMethods() {
        ReferenceBinding superclass = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(superclass, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding[] itsInterfaces = superInterfaces;
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            nextPosition = itsInterfaces.length;
            interfacesToVisit = itsInterfaces;
        }
        ReferenceBinding superType = superclass;
        HashtableOfObject nonVisibleDefaultMethods = new HashtableOfObject(3);
        boolean allSuperclassesAreAbstract = true;
        while (superType != null && superType.isValidBinding()) {
            if (allSuperclassesAreAbstract) {
                if (superType.isAbstract()) {
                    itsInterfaces = superType.superInterfaces();
                    if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                        if (interfacesToVisit == null) {
                            interfacesToVisit = itsInterfaces;
                            nextPosition = interfacesToVisit.length;
                        } else {
                            int itsLength = itsInterfaces.length;
                            if (nextPosition + itsLength >= interfacesToVisit.length) {
                                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                            }
                            int a = 0;
                            while (a < itsLength) {
                                block44: {
                                    ReferenceBinding next = itsInterfaces[a];
                                    int b = 0;
                                    while (b < nextPosition) {
                                        if (next != interfacesToVisit[b]) {
                                            ++b;
                                            continue;
                                        }
                                        break block44;
                                    }
                                    interfacesToVisit[nextPosition++] = next;
                                }
                                ++a;
                            }
                        }
                    }
                } else {
                    allSuperclassesAreAbstract = false;
                }
            }
            MethodBinding[] methods = superType.unResolvedMethods();
            int m = methods.length;
            block3: while (--m >= 0) {
                MethodBinding[] current;
                MethodBinding[] nonVisible;
                int length;
                MethodBinding inheritedMethod;
                block47: {
                    MethodBinding[] existingMethods;
                    block46: {
                        inheritedMethod = methods[m];
                        if (inheritedMethod.isPrivate() || inheritedMethod.isConstructor() || inheritedMethod.isDefaultAbstract()) continue;
                        existingMethods = (MethodBinding[])this.inheritedMethods.get(inheritedMethod.selector);
                        if (existingMethods != null) {
                            int i = 0;
                            length = existingMethods.length;
                            while (i < length) {
                                MethodBinding methodBinding = existingMethods[i];
                                MethodBinding methodBinding2 = inheritedMethod;
                                if ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody39$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) != (ReferenceBinding)MethodVerifier.declaringClass_aroundBody41$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null) && this.areMethodsCompatible(existingMethods[i], inheritedMethod)) {
                                    if (!inheritedMethod.isDefault() || !inheritedMethod.isAbstract()) continue block3;
                                    this.checkPackagePrivateAbstractMethod(inheritedMethod);
                                    continue block3;
                                }
                                ++i;
                            }
                        }
                        if ((nonVisible = (MethodBinding[])nonVisibleDefaultMethods.get(inheritedMethod.selector)) != null) {
                            int i = 0;
                            int l = nonVisible.length;
                            while (i < l) {
                                if (this.areMethodsCompatible(nonVisible[i], inheritedMethod)) continue block3;
                                ++i;
                            }
                        }
                        if (!inheritedMethod.isDefault()) break block46;
                        MethodBinding methodBinding = inheritedMethod;
                        if (((ReferenceBinding)MethodVerifier.declaringClass_aroundBody43$advice((MethodVerifier)this, (MethodBinding)methodBinding, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding, null)).fPackage != this.type.fPackage) break block47;
                    }
                    if (existingMethods == null) {
                        existingMethods = new MethodBinding[]{inheritedMethod};
                    } else {
                        length = existingMethods.length;
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                        existingMethods[length] = inheritedMethod;
                    }
                    this.inheritedMethods.put(inheritedMethod.selector, existingMethods);
                    continue;
                }
                if (nonVisible == null) {
                    nonVisible = new MethodBinding[]{inheritedMethod};
                } else {
                    length = nonVisible.length;
                    MethodBinding[] methodBindingArray = nonVisible;
                    nonVisible = new MethodBinding[length + 1];
                    System.arraycopy(methodBindingArray, 0, nonVisible, 0, length);
                    nonVisible[length] = inheritedMethod;
                }
                nonVisibleDefaultMethods.put(inheritedMethod.selector, nonVisible);
                if (inheritedMethod.isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, inheritedMethod);
                }
                if ((current = (MethodBinding[])this.currentMethods.get(inheritedMethod.selector)) == null) continue;
                int i = 0;
                int length2 = current.length;
                while (i < length2) {
                    if (this.areMethodsCompatible(current[i], inheritedMethod)) {
                        this.problemReporter().overridesPackageDefaultMethod(current[i], inheritedMethod);
                        continue block3;
                    }
                    ++i;
                }
            }
            superType = superType.superclass();
        }
        if (nextPosition == 0) {
            return;
        }
        SimpleSet skip = this.findSuperinterfaceCollisions(superclass, superInterfaces);
        int i = 0;
        while (i < nextPosition) {
            superType = interfacesToVisit[i];
            if (superType.isValidBinding() && (skip == null || !skip.includes(superType))) {
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    int a = 0;
                    while (a < itsLength) {
                        block45: {
                            ReferenceBinding next = itsInterfaces[a];
                            int b = 0;
                            while (b < nextPosition) {
                                if (next != interfacesToVisit[b]) {
                                    ++b;
                                    continue;
                                }
                                break block45;
                            }
                            interfacesToVisit[nextPosition++] = next;
                        }
                        ++a;
                    }
                }
                MethodBinding[] methods = superType.unResolvedMethods();
                int m = methods.length;
                block10: while (--m >= 0) {
                    MethodBinding inheritedMethod = methods[m];
                    if (!inheritedMethod.isAbstract()) continue;
                    MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(inheritedMethod.selector);
                    if (existingMethods == null) {
                        int ii = 0;
                        while (ii < methods.length) {
                            MethodBinding mb = methods[ii];
                            if (!mb.isAbstract() && new String(mb.selector).equals(new String(inheritedMethod.selector)) && this.areMethodsCompatible(mb, inheritedMethod)) continue block10;
                            ++ii;
                        }
                        existingMethods = new MethodBinding[]{inheritedMethod};
                    } else {
                        int length = existingMethods.length;
                        int e = 0;
                        while (e < length) {
                            if (this.isInterfaceMethodImplemented(inheritedMethod, existingMethods[e], superType)) continue block10;
                            ++e;
                        }
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                        existingMethods[length] = inheritedMethod;
                    }
                    this.inheritedMethods.put(inheritedMethod.selector, existingMethods);
                }
            }
            ++i;
        }
    }

    void computeMethods() {
        MethodBinding[] methods = null;
        methods = this.type.memberFinder != null ? this.type.memberFinder.methods(this.type) : this.type.methods();
        int size = methods.length;
        this.currentMethods = new HashtableOfObject(size == 0 ? 1 : size);
        int m = size;
        while (--m >= 0) {
            MethodBinding method = methods[m];
            if (method.isConstructor() || method.isDefaultAbstract()) continue;
            MethodBinding[] existingMethods = (MethodBinding[])this.currentMethods.get(method.selector);
            if (existingMethods == null) {
                existingMethods = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray = existingMethods;
                existingMethods = new MethodBinding[existingMethods.length + 1];
                System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
            }
            existingMethods[existingMethods.length - 1] = method;
            this.currentMethods.put(method.selector, existingMethods);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.parameters.length != inheritedMethod.parameters.length) {
            return null;
        }
        return inheritedMethod;
    }

    public boolean doesMethodOverride(MethodBinding method, MethodBinding inheritedMethod) {
        return this.areParametersEqual(method, inheritedMethod);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        return null;
    }

    int[] findOverriddenInheritedMethods(MethodBinding[] methods, int length) {
        int[] toSkip = null;
        int i = 0;
        MethodBinding methodBinding = methods[i];
        ReferenceBinding declaringClass = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody45$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null);
        if (!declaringClass.isInterface()) {
            MethodBinding methodBinding2 = methods[++i];
            ReferenceBinding declaringClass2 = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody47$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null);
            while (declaringClass == declaringClass2) {
                if (++i == length) {
                    return null;
                }
                MethodBinding methodBinding3 = methods[i];
                declaringClass2 = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody49$advice(this, methodBinding3, OwningClassSupportForMethodBindings.aspectOf(), methodBinding3, null);
            }
            if (!declaringClass2.isInterface()) {
                MethodBinding methodBinding4;
                toSkip = new int[length];
                do {
                    toSkip[i] = -1;
                    if (++i != length) continue;
                    return toSkip;
                } while (!(declaringClass2 = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody51$advice(this, methodBinding4 = methods[i], OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null)).isInterface());
            }
        }
        while (i < length) {
            if (toSkip == null || toSkip[i] != -1) {
                MethodBinding methodBinding5 = methods[i];
                declaringClass = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody53$advice(this, methodBinding5, OwningClassSupportForMethodBindings.aspectOf(), methodBinding5, null);
                int j = i + 1;
                while (j < length) {
                    MethodBinding methodBinding6;
                    ReferenceBinding declaringClass2;
                    if ((toSkip == null || toSkip[j] != -1) && declaringClass != (declaringClass2 = (ReferenceBinding)MethodVerifier.declaringClass_aroundBody55$advice(this, methodBinding6 = methods[j], OwningClassSupportForMethodBindings.aspectOf(), methodBinding6, null))) {
                        if (declaringClass.implementsInterface(declaringClass2, true)) {
                            if (toSkip == null) {
                                toSkip = new int[length];
                            }
                            toSkip[j] = -1;
                        } else if (declaringClass2.implementsInterface(declaringClass, true)) {
                            if (toSkip == null) {
                                toSkip = new int[length];
                            }
                            toSkip[i] = -1;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return toSkip;
    }

    boolean isAsVisible(MethodBinding newMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.modifiers == newMethod.modifiers) {
            return true;
        }
        if (newMethod.isPublic()) {
            return true;
        }
        if (inheritedMethod.isPublic()) {
            return false;
        }
        if (newMethod.isProtected()) {
            return true;
        }
        if (inheritedMethod.isProtected()) {
            return false;
        }
        return !newMethod.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        MethodBinding methodBinding;
        return this.areParametersEqual(existingMethod, inheritedMethod) && ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody57$advice(this, methodBinding = existingMethod, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null)).implementsInterface(superType, true);
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding testClass, ReferenceBinding superclass) {
        do {
            if (testClass != superclass) continue;
            return true;
        } while ((testClass = testClass.superclass()) != null);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mustImplementAbstractMethod(ReferenceBinding declaringClass) {
        block4: {
            block3: {
                superclass = this.type.superclass();
                if (!declaringClass.isClass()) break block3;
                while (superclass.isAbstract() && superclass != declaringClass) {
                    superclass = superclass.superclass();
                }
                break block4;
            }
            if (!this.type.implementsInterface(declaringClass, false)) ** GOTO lbl14
            if (this.type.isAbstract()) {
                return false;
            }
            if (superclass.implementsInterface(declaringClass, true)) ** GOTO lbl14
            return true;
lbl-1000:
            // 1 sources

            {
                superclass = superclass.superclass();
lbl14:
                // 3 sources

                ** while (superclass.isAbstract() && !superclass.implementsInterface((ReferenceBinding)declaringClass, (boolean)false))
            }
        }
        return superclass.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding currentMethod) {
        ProblemReporter reporter = this.problemReporter();
        MethodBinding methodBinding = currentMethod;
        if ((ReferenceBinding)MethodVerifier.declaringClass_aroundBody59$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) == this.type && currentMethod.sourceMethod() != null) {
            reporter.referenceContext = currentMethod.sourceMethod();
        }
        return reporter;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        this.problemReporter(currentMethod).incompatibleReturnType(currentMethod, inheritedMethod);
        return true;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding method) {
        ReferenceBinding[] exceptions = method.thrownExceptions;
        if ((method.modifiers & 0x2000000) == 0) {
            return exceptions;
        }
        MethodBinding methodBinding = method;
        if (!((ReferenceBinding)MethodVerifier.declaringClass_aroundBody61$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) instanceof BinaryTypeBinding)) {
            return Binding.NO_EXCEPTIONS;
        }
        int i = exceptions.length;
        while (--i >= 0) {
            exceptions[i] = BinaryTypeBinding.resolveType(exceptions[i], this.environment, true);
        }
        return exceptions;
    }

    void verify(SourceTypeBinding someType) {
        this.type = someType;
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("MethodVerifier for type: ");
        buffer.append(this.type.readableName());
        buffer.append('\n');
        buffer.append("\t-inherited methods: ");
        buffer.append(this.inheritedMethods);
        return buffer.toString();
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody2(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody3$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody4(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody5$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody6(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody7$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody8(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody9$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody10(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody11$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody12(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody13$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody14(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody15$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody16(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody17$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody18(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody19$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody20(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody21$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody22(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody23$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody24(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody25$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody26(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody27$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody28(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody29$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody30(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody31$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody32(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody33$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody34(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody35$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody36(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody37$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody38(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody39$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody40(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody41$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody42(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody43$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody44(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody45$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody46(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody47$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody48(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody49$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody50(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody51$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody52(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody53$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody54(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody55$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody56(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody57$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody58(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody59$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody60(MethodVerifier methodVerifier, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody61$advice(MethodVerifier this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }
}

