/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.CompactTypeStructureRepresentation;
import org.aspectj.ajdt.internal.core.builder.CompilerConfigurationChangeFlags;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.aspectj.org.eclipse.jdt.internal.core.builder.StringSet;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;

public class AjState
implements CompilerConfigurationChangeFlags {
    public static boolean CHECK_STATE_FIRST = false;
    public static IStateListener stateListener = null;
    public static boolean FORCE_INCREMENTAL_DURING_TESTING = false;
    private final AjBuildManager buildManager;
    private boolean couldBeSubsequentIncrementalBuild = false;
    private INameEnvironment nameEnvironment;
    private AsmManager structureModel;
    private final Set affectedFiles = new HashSet();
    private long lastSuccessfulFullBuildTime = -1L;
    private final Hashtable structuralChangesSinceLastFullBuild = new Hashtable();
    private long lastSuccessfulBuildTime = -1L;
    private long currentBuildTime = -1L;
    private AjBuildConfig buildConfig;
    private boolean batchBuildRequiredThisTime = false;
    private final Map fullyQualifiedTypeNamesResultingFromCompilationUnit = new HashMap();
    private final Set sourceFilesDefiningAspects = new HashSet();
    private final Map references = new HashMap();
    private Map binarySourceFiles = new HashMap();
    private final Map inputClassFilesBySource = new HashMap();
    private final List aspectClassFiles = new ArrayList();
    private final Map resolvedTypeStructuresFromLastBuild = new HashMap();
    private final Map classesFromName = new HashMap();
    private Map aspectsFromFileNames;
    private Set compiledSourceFiles = new HashSet();
    private final List resources = new ArrayList();
    private StringSet qualifiedStrings = new StringSet(3);
    private StringSet simpleStrings = new StringSet(3);
    private Set addedFiles;
    private Set deletedFiles;
    private Set addedBinaryFiles;
    private Set deletedBinaryFiles;
    private BcelWeaver weaver;
    private BcelWorld world;
    private static int CLASS_FILE_NO_CHANGES = 0;
    private static int CLASS_FILE_CHANGED_THAT_NEEDS_INCREMENTAL_BUILD = 1;
    private static int CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD = 2;
    private static int MAX_AFFECTED_FILES_BEFORE_FULL_BUILD = 30;
    public static final FileFilter classFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    };
    SoftHashMap fileToClassNameMap = new SoftHashMap();
    private static final char[][] EMPTY_CHAR_ARRAY = new char[0][];

    public AjState(AjBuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setCouldBeSubsequentIncrementalBuild(boolean yesThereCould) {
        this.couldBeSubsequentIncrementalBuild = yesThereCould;
    }

    void successfulCompile(AjBuildConfig config, boolean wasFullBuild) {
        this.buildConfig = config;
        this.lastSuccessfulBuildTime = this.currentBuildTime;
        if (stateListener != null) {
            stateListener.buildSuccessful(wasFullBuild);
        }
        if (wasFullBuild) {
            this.lastSuccessfulFullBuildTime = this.currentBuildTime;
        }
    }

    public boolean prepareForNextBuild(AjBuildConfig newBuildConfig) {
        this.currentBuildTime = System.currentTimeMillis();
        if (!this.maybeIncremental()) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because either not in AJDT or incremental deactivated");
            }
            return false;
        }
        if (this.batchBuildRequiredThisTime) {
            this.batchBuildRequiredThisTime = false;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental this time because batch build explicitly forced");
            }
            return false;
        }
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because no successful previous full build");
            }
            return false;
        }
        if (newBuildConfig.getOutputJar() != null) {
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because outjar being used");
            }
            return false;
        }
        this.affectedFiles.clear();
        if (this.pathChange(this.buildConfig, newBuildConfig)) {
            this.removeAllResultsOfLastBuild();
            if (stateListener != null) {
                stateListener.pathChangeDetected();
            }
            this.structuralChangesSinceLastFullBuild.clear();
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because path change detected (one of classpath/aspectpath/inpath/injars)");
            }
            return false;
        }
        if (this.simpleStrings.elementSize > 20) {
            this.simpleStrings = new StringSet(3);
        } else {
            this.simpleStrings.clear();
        }
        if (this.qualifiedStrings.elementSize > 20) {
            this.qualifiedStrings = new StringSet(3);
        } else {
            this.qualifiedStrings.clear();
        }
        if ((newBuildConfig.getChanged() & 1) == 0) {
            this.addedFiles = Collections.EMPTY_SET;
            this.deletedFiles = Collections.EMPTY_SET;
        } else {
            HashSet oldFiles = new HashSet(this.buildConfig.getFiles());
            HashSet newFiles = new HashSet(newBuildConfig.getFiles());
            this.addedFiles = new HashSet(newFiles);
            this.addedFiles.removeAll(oldFiles);
            this.deletedFiles = new HashSet(oldFiles);
            this.deletedFiles.removeAll(newFiles);
        }
        HashSet oldBinaryFiles = new HashSet(this.buildConfig.getBinaryFiles());
        HashSet newBinaryFiles = new HashSet(newBuildConfig.getBinaryFiles());
        this.addedBinaryFiles = new HashSet(newBinaryFiles);
        this.addedBinaryFiles.removeAll(oldBinaryFiles);
        this.deletedBinaryFiles = new HashSet(oldBinaryFiles);
        this.deletedBinaryFiles.removeAll(newBinaryFiles);
        boolean couldStillBeIncremental = this.processDeletedFiles(this.deletedFiles);
        if (!couldStillBeIncremental) {
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Preparing for build: not going to be incremental because an aspect was deleted");
            }
            return false;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Preparing for build: planning to be an incremental build");
        }
        return true;
    }

    private boolean processDeletedFiles(Set deletedFiles) {
        Iterator iter = deletedFiles.iterator();
        while (iter.hasNext()) {
            File aDeletedFile = (File)iter.next();
            if (this.sourceFilesDefiningAspects.contains(aDeletedFile)) {
                this.removeAllResultsOfLastBuild();
                if (stateListener != null) {
                    stateListener.detectedAspectDeleted(aDeletedFile);
                }
                return false;
            }
            List classes = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(aDeletedFile);
            if (classes == null) continue;
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                ClassFile element = (ClassFile)iterator.next();
                this.resolvedTypeStructuresFromLastBuild.remove(element.fullyQualifiedTypeName);
            }
        }
        return true;
    }

    private Collection getModifiedFiles() {
        return this.getModifiedFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedFiles(long lastBuildTime) {
        HashSet<File> ret = new HashSet<File>();
        List modifiedFiles = this.buildConfig.getModifiedFiles();
        if (modifiedFiles == null) {
            Iterator i = this.buildConfig.getFiles().iterator();
            while (i.hasNext()) {
                long modTime;
                File file = (File)i.next();
                if (!file.exists() || (modTime = file.lastModified()) + 1000L <= lastBuildTime) continue;
                ret.add(file);
            }
        } else {
            ret.addAll(modifiedFiles);
        }
        ret.addAll(this.affectedFiles);
        return ret;
    }

    private Collection getModifiedBinaryFiles() {
        return this.getModifiedBinaryFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedBinaryFiles(long lastBuildTime) {
        ArrayList<AjBuildConfig.BinarySourceFile> ret = new ArrayList<AjBuildConfig.BinarySourceFile>();
        Iterator i = this.buildConfig.getBinaryFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            AjBuildConfig.BinarySourceFile bsfile = (AjBuildConfig.BinarySourceFile)i.next();
            File file = bsfile.binSrc;
            if (!file.exists() || (modTime = file.lastModified()) + 1000L < lastBuildTime) continue;
            ret.add(bsfile);
        }
        return ret;
    }

    private int classFileChangedInDirSinceLastBuildRequiringFullBuild(File dir) {
        if (!dir.isDirectory()) {
            return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
        }
        AjState state = IncrementalStateManager.findStateManagingOutputLocation(dir);
        if (this.listenerDefined()) {
            if (state != null) {
                this.getListener().recordDecision("Found state instance managing output location : " + dir);
            } else {
                this.getListener().recordDecision("Failed to find a state instance managing output location : " + dir);
            }
        }
        List classFiles = FileUtil.listClassFiles(dir);
        Iterator iterator = classFiles.iterator();
        while (iterator.hasNext()) {
            File classFile = (File)iterator.next();
            if (CHECK_STATE_FIRST && state != null) {
                if (state.isAspect(classFile)) {
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
                if (!state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime)) continue;
                if (this.listenerDefined()) {
                    this.getListener().recordDecision("Structural change detected in : " + classFile);
                }
                if (!this.isTypeWeReferTo(classFile) || this.affectedFiles.size() <= MAX_AFFECTED_FILES_BEFORE_FULL_BUILD) continue;
                return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
            }
            long modTime = classFile.lastModified();
            if (modTime + 1000L < this.lastSuccessfulBuildTime) continue;
            if (state != null) {
                if (state.isAspect(classFile)) {
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
                if (state.hasStructuralChangedSince(classFile, this.lastSuccessfulBuildTime)) {
                    if (this.listenerDefined()) {
                        this.getListener().recordDecision("Structural change detected in : " + classFile);
                    }
                    if (!this.isTypeWeReferTo(classFile) || this.affectedFiles.size() <= MAX_AFFECTED_FILES_BEFORE_FULL_BUILD) continue;
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
                if (!this.listenerDefined()) continue;
                this.getListener().recordDecision("Change detected in " + classFile + " but it is not structural");
                continue;
            }
            if (this.isTypeWeReferTo(classFile)) {
                if (this.affectedFiles.size() > MAX_AFFECTED_FILES_BEFORE_FULL_BUILD) {
                    return CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD;
                }
                return CLASS_FILE_CHANGED_THAT_NEEDS_INCREMENTAL_BUILD;
            }
            return CLASS_FILE_NO_CHANGES;
        }
        return CLASS_FILE_NO_CHANGES;
    }

    private boolean isAspect(File file) {
        return this.aspectClassFiles.contains(file.getAbsolutePath());
    }

    private boolean isTypeWeReferTo(File file) {
        char[] className;
        String fpath = file.getAbsolutePath();
        int finalSeparator = fpath.lastIndexOf(File.separator);
        String baseDir = fpath.substring(0, finalSeparator);
        String theFile = fpath.substring(finalSeparator + 1);
        SoftHashMap classNames = (SoftHashMap)this.fileToClassNameMap.get(baseDir);
        if (classNames == null) {
            classNames = new SoftHashMap();
            this.fileToClassNameMap.put(baseDir, classNames);
        }
        if ((className = (char[])classNames.get(theFile)) == null) {
            ClassFileReader cfr;
            try {
                cfr = ClassFileReader.read(file);
            }
            catch (ClassFormatException e) {
                return true;
            }
            catch (IOException e) {
                return true;
            }
            className = cfr.getName();
            classNames.put(theFile, className);
        }
        Object qualifiedNames = null;
        Object simpleNames = null;
        if (CharOperation.indexOf('/', className) != -1) {
            qualifiedNames = new char[1][][];
            qualifiedNames[0] = CharOperation.splitOn('/', className);
            qualifiedNames = ReferenceCollection.internQualifiedNames(qualifiedNames);
        } else {
            simpleNames = new char[1][];
            simpleNames[0] = className;
            simpleNames = ReferenceCollection.internSimpleNames(simpleNames, true);
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (refs == null || !refs.includes((char[][][])qualifiedNames, (char[][])simpleNames)) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision(this.toString() + ": type " + new String(className) + " is depended upon by '" + entry.getKey() + "'");
            }
            this.affectedFiles.add(entry.getKey());
            if (this.affectedFiles.size() <= MAX_AFFECTED_FILES_BEFORE_FULL_BUILD) continue;
            return true;
        }
        if (this.affectedFiles.size() > 0) {
            return true;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision(this.toString() + ": type " + new String(className) + " is not depended upon by this state");
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AjState(").append(this.buildConfig == null ? "NULLCONFIG" : this.buildConfig.getConfigFile().toString()).append(")");
        return sb.toString();
    }

    private boolean hasStructuralChangedSince(File file, long lastSuccessfulBuildTime) {
        Long l = (Long)this.structuralChangesSinceLastFullBuild.get(file.getAbsolutePath());
        long strucModTime = -1L;
        strucModTime = l != null ? l : this.lastSuccessfulFullBuildTime;
        return strucModTime > lastSuccessfulBuildTime;
    }

    private boolean pathChange(AjBuildConfig previousConfig, AjBuildConfig newConfig) {
        int changes = newConfig.getChanged();
        if ((changes & 0x31C) != 0) {
            List newInJars;
            List newInPath;
            List newAspectpath;
            List oldOutputLocs = this.getOutputLocations(previousConfig);
            HashSet alreadyAnalysedPaths = new HashSet();
            List oldClasspath = previousConfig.getClasspath();
            List newClasspath = newConfig.getClasspath();
            if (stateListener != null) {
                stateListener.aboutToCompareClasspaths(oldClasspath, newClasspath);
            }
            if (this.classpathChangedAndNeedsFullBuild(oldClasspath, newClasspath, true, oldOutputLocs, alreadyAnalysedPaths)) {
                return true;
            }
            List oldAspectpath = previousConfig.getAspectpath();
            if (this.changedAndNeedsFullBuild(oldAspectpath, newAspectpath = newConfig.getAspectpath(), true, oldOutputLocs, alreadyAnalysedPaths)) {
                return true;
            }
            List oldInPath = previousConfig.getInpath();
            if (this.changedAndNeedsFullBuild(oldInPath, newInPath = newConfig.getInpath(), false, oldOutputLocs, alreadyAnalysedPaths)) {
                return true;
            }
            List oldInJars = previousConfig.getInJars();
            if (this.changedAndNeedsFullBuild(oldInJars, newInJars = newConfig.getInJars(), false, oldOutputLocs, alreadyAnalysedPaths)) {
                return true;
            }
        } else if (newConfig.getClasspathElementsWithModifiedContents() != null) {
            List modifiedCpElements = newConfig.getClasspathElementsWithModifiedContents();
            Iterator iterator = modifiedCpElements.iterator();
            while (iterator.hasNext()) {
                int classFileChanges;
                File cpElement = new File((String)iterator.next());
                if (!(cpElement.exists() && !cpElement.isDirectory() ? cpElement.lastModified() > this.lastSuccessfulBuildTime : (classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(cpElement)) == CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD)) continue;
                return true;
            }
        }
        return false;
    }

    private List getOutputLocations(AjBuildConfig config) {
        ArrayList<File> outputLocs = new ArrayList<File>();
        if (config.getOutputDir() != null) {
            try {
                outputLocs.add(config.getOutputDir().getCanonicalFile());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (config.getCompilationResultDestinationManager() != null) {
            List dirs = config.getCompilationResultDestinationManager().getAllOutputLocations();
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                File f = (File)iterator.next();
                try {
                    File cf = f.getCanonicalFile();
                    if (outputLocs.contains(cf)) continue;
                    outputLocs.add(cf);
                }
                catch (IOException e) {}
            }
        }
        return outputLocs;
    }

    private boolean changedAndNeedsFullBuild(List oldPath, List newPath, boolean checkClassFiles, List outputLocs, Set alreadyAnalysedPaths) {
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            Object o = oldPath.get(i);
            File f = null;
            f = o instanceof String ? new File((String)o) : (File)o;
            if (f.exists() && !f.isDirectory() && f.lastModified() >= this.lastSuccessfulBuildTime) {
                return true;
            }
            if (!checkClassFiles || !f.exists() || !f.isDirectory()) continue;
            boolean foundMatch = false;
            Iterator iterator = outputLocs.iterator();
            while (!foundMatch && iterator.hasNext()) {
                File dir = (File)iterator.next();
                if (!f.equals(dir)) continue;
                foundMatch = true;
            }
            if (foundMatch || alreadyAnalysedPaths.contains(f.getAbsolutePath())) continue;
            alreadyAnalysedPaths.add(f.getAbsolutePath());
            int classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(f);
            if (classFileChanges != CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD) continue;
            return true;
        }
        return false;
    }

    private boolean classpathChangedAndNeedsFullBuild(List oldPath, List newPath, boolean checkClassFiles, List outputLocs, Set alreadyAnalysedPaths) {
        if (oldPath.size() != newPath.size()) {
            return true;
        }
        for (int i = 0; i < oldPath.size(); ++i) {
            if (!oldPath.get(i).equals(newPath.get(i))) {
                return true;
            }
            File f = new File((String)oldPath.get(i));
            if (f.exists() && !f.isDirectory() && f.lastModified() >= this.lastSuccessfulBuildTime) {
                return true;
            }
            if (!checkClassFiles || !f.exists() || !f.isDirectory()) continue;
            boolean foundMatch = false;
            Iterator iterator = outputLocs.iterator();
            while (!foundMatch && iterator.hasNext()) {
                File dir = (File)iterator.next();
                if (!f.equals(dir)) continue;
                foundMatch = true;
            }
            if (foundMatch || alreadyAnalysedPaths.contains(f.getAbsolutePath())) continue;
            alreadyAnalysedPaths.add(f.getAbsolutePath());
            int classFileChanges = this.classFileChangedInDirSinceLastBuildRequiringFullBuild(f);
            if (classFileChanges != CLASS_FILE_CHANGED_THAT_NEEDS_FULL_BUILD) continue;
            return true;
        }
        return false;
    }

    public Set getFilesToCompile(boolean firstPass) {
        HashSet thisTime = new HashSet();
        if (firstPass) {
            this.compiledSourceFiles = new HashSet();
            Collection modifiedFiles = this.getModifiedFiles();
            thisTime.addAll(modifiedFiles);
            if (this.addedFiles != null) {
                Iterator fIter = this.addedFiles.iterator();
                while (fIter.hasNext()) {
                    Object o = fIter.next();
                    if (thisTime.contains(o)) continue;
                    thisTime.add(o);
                }
            }
            this.deleteClassFiles();
            this.addAffectedSourceFiles(thisTime, thisTime);
        } else {
            this.addAffectedSourceFiles(thisTime, this.compiledSourceFiles);
        }
        this.compiledSourceFiles = thisTime;
        return thisTime;
    }

    private boolean maybeIncremental() {
        return FORCE_INCREMENTAL_DURING_TESTING || this.couldBeSubsequentIncrementalBuild;
    }

    public Map getBinaryFilesToCompile(boolean firstTime) {
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null || !this.maybeIncremental()) {
            return this.binarySourceFiles;
        }
        HashMap toWeave = new HashMap();
        if (firstTime) {
            ArrayList addedOrModified = new ArrayList();
            addedOrModified.addAll(this.addedBinaryFiles);
            addedOrModified.addAll(this.getModifiedBinaryFiles());
            Iterator iter = addedOrModified.iterator();
            while (iter.hasNext()) {
                AjBuildConfig.BinarySourceFile bsf = (AjBuildConfig.BinarySourceFile)iter.next();
                UnwovenClassFile ucf = this.createUnwovenClassFile(bsf);
                if (ucf == null) continue;
                ArrayList<UnwovenClassFile> ucfs = new ArrayList<UnwovenClassFile>();
                ucfs.add(ucf);
                this.recordTypeChanged(ucf.getClassName());
                this.binarySourceFiles.put(bsf.binSrc.getPath(), ucfs);
                ArrayList<ClassFile> cfs = new ArrayList<ClassFile>(1);
                cfs.add(this.getClassFileFor(ucf));
                this.inputClassFilesBySource.put(bsf.binSrc.getPath(), cfs);
                toWeave.put(bsf.binSrc.getPath(), ucfs);
            }
            this.deleteBinaryClassFiles();
        }
        return toWeave;
    }

    private void removeAllResultsOfLastBuild() {
        Iterator<Object> iter = this.inputClassFilesBySource.values().iterator();
        while (iter.hasNext()) {
            List cfs = (List)iter.next();
            Iterator iterator = cfs.iterator();
            while (iterator.hasNext()) {
                ClassFile cf = (ClassFile)iterator.next();
                cf.deleteFromFileSystem();
            }
        }
        Iterator iterator = this.classesFromName.values().iterator();
        while (iterator.hasNext()) {
            File f = (File)iterator.next();
            new ClassFile("", f).deleteFromFileSystem();
        }
        iter = this.resources.iterator();
        while (iter.hasNext()) {
            String resource = (String)iter.next();
            List outputDirs = this.getOutputLocations(this.buildConfig);
            Iterator iterator2 = outputDirs.iterator();
            while (iterator2.hasNext()) {
                File dir = (File)iterator2.next();
                File f = new File(dir, resource);
                if (!f.exists()) continue;
                f.delete();
            }
        }
    }

    private void deleteClassFiles() {
        if (this.deletedFiles == null) {
            return;
        }
        Iterator i = this.deletedFiles.iterator();
        while (i.hasNext()) {
            File deletedFile = (File)i.next();
            this.addDependentsOf(deletedFile);
            List cfs = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(deletedFile);
            this.fullyQualifiedTypeNamesResultingFromCompilationUnit.remove(deletedFile);
            if (cfs == null) continue;
            Iterator iter = cfs.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.deleteClassFile(cf);
            }
        }
    }

    private void deleteBinaryClassFiles() {
        Iterator iter = this.deletedBinaryFiles.iterator();
        while (iter.hasNext()) {
            AjBuildConfig.BinarySourceFile deletedFile = (AjBuildConfig.BinarySourceFile)iter.next();
            List cfs = (List)this.inputClassFilesBySource.get(deletedFile.binSrc.getPath());
            Iterator iterator = cfs.iterator();
            while (iterator.hasNext()) {
                this.deleteClassFile((ClassFile)iterator.next());
            }
            this.inputClassFilesBySource.remove(deletedFile.binSrc.getPath());
        }
    }

    private void deleteClassFile(ClassFile cf) {
        this.classesFromName.remove(cf.fullyQualifiedTypeName);
        this.weaver.deleteClassFile(cf.fullyQualifiedTypeName);
        cf.deleteFromFileSystem();
    }

    private UnwovenClassFile createUnwovenClassFile(AjBuildConfig.BinarySourceFile bsf) {
        UnwovenClassFile ucf = null;
        try {
            File outputDir = this.buildConfig.getOutputDir();
            if (this.buildConfig.getCompilationResultDestinationManager() != null) {
                outputDir = this.buildConfig.getCompilationResultDestinationManager().getDefaultOutputLocation();
            }
            ucf = this.weaver.addClassFile(bsf.binSrc, bsf.fromInPathDirectory, outputDir);
        }
        catch (IOException ex) {
            Message msg = new Message("can't read class file " + bsf.binSrc.getPath(), new SourceLocation(bsf.binSrc, 0), false);
            this.buildManager.handler.handleMessage(msg);
        }
        return ucf;
    }

    public void noteResult(InterimCompilationResult result) {
        if (!this.maybeIncremental()) {
            return;
        }
        File sourceFile = new File(result.fileName());
        CompilationResult cr = result.result();
        this.references.put(sourceFile, new ReferenceCollection(cr.qualifiedReferences, cr.simpleNameReferences));
        UnwovenClassFile[] unwovenClassFiles = result.unwovenClassFiles();
        for (int i = 0; i < unwovenClassFiles.length; ++i) {
            File lastTimeRound = (File)this.classesFromName.get(unwovenClassFiles[i].getClassName());
            this.recordClassFile(unwovenClassFiles[i], lastTimeRound);
            this.classesFromName.put(unwovenClassFiles[i].getClassName(), new File(unwovenClassFiles[i].getFilename()));
        }
        this.recordWhetherCompilationUnitDefinedAspect(sourceFile, cr);
        this.deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(sourceFile, unwovenClassFiles);
        this.recordFQNsResultingFromCompilationUnit(sourceFile, result);
    }

    public void noteNewResult(CompilationResult cr) {
    }

    private void deleteTypesThatWereInThisCompilationUnitLastTimeRoundButHaveBeenDeletedInThisIncrement(File sourceFile, UnwovenClassFile[] unwovenClassFiles) {
        List classFiles = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (classFiles != null) {
            for (int i = 0; i < unwovenClassFiles.length; ++i) {
                this.removeFromClassFilesIfPresent(unwovenClassFiles[i].getClassName(), classFiles);
            }
            Iterator iter = classFiles.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.deleteClassFile(cf);
            }
        }
    }

    private void removeFromClassFilesIfPresent(String className, List classFiles) {
        ClassFile victim = null;
        Iterator iter = classFiles.iterator();
        while (iter.hasNext()) {
            ClassFile cf = (ClassFile)iter.next();
            if (!cf.fullyQualifiedTypeName.equals(className)) continue;
            victim = cf;
            break;
        }
        if (victim != null) {
            classFiles.remove(victim);
        }
    }

    private void recordFQNsResultingFromCompilationUnit(File sourceFile, InterimCompilationResult icr) {
        ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
        UnwovenClassFile[] types = icr.unwovenClassFiles();
        for (int i = 0; i < types.length; ++i) {
            classFiles.add(new ClassFile(types[i].getClassName(), new File(types[i].getFilename())));
        }
        this.fullyQualifiedTypeNamesResultingFromCompilationUnit.put(sourceFile, classFiles);
    }

    private void recordWhetherCompilationUnitDefinedAspect(File sourceFile, CompilationResult cr) {
        Map compiledTypes;
        this.sourceFilesDefiningAspects.remove(sourceFile);
        if (cr != null && (compiledTypes = cr.compiledTypes) != null) {
            Iterator iterator = compiledTypes.keySet().iterator();
            while (iterator.hasNext()) {
                char[] className = (char[])iterator.next();
                String typeName = new String(className).replace('/', '.');
                if (typeName.indexOf("$ajc") != -1) continue;
                ResolvedType rt = this.world.resolve(typeName);
                if (rt.isMissing()) {
                    throw new IllegalStateException("Type '" + rt.getSignature() + "' not found in world!");
                }
                if (!rt.isAspect()) continue;
                this.sourceFilesDefiningAspects.add(sourceFile);
                break;
            }
        }
    }

    private void recordClassFile(UnwovenClassFile thisTime, File lastTime) {
        if (this.simpleStrings == null) {
            ResolvedType rType = this.world.resolve(thisTime.getClassName());
            if (!rType.isMissing()) {
                try {
                    ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                    this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader));
                }
                catch (ClassFormatException cfe) {
                    throw new BCException("Unexpected problem processing class", cfe);
                }
            }
            return;
        }
        CompactTypeStructureRepresentation existingStructure = (CompactTypeStructureRepresentation)this.resolvedTypeStructuresFromLastBuild.get(thisTime.getClassName());
        ResolvedType newResolvedType = this.world.resolve(thisTime.getClassName());
        if (!newResolvedType.isMissing()) {
            try {
                ClassFileReader reader = new ClassFileReader(thisTime.getBytes(), null);
                this.resolvedTypeStructuresFromLastBuild.put(thisTime.getClassName(), new CompactTypeStructureRepresentation(reader));
            }
            catch (ClassFormatException cfe) {
                throw new BCException("Unexpected problem processing class", cfe);
            }
        }
        if (lastTime == null) {
            this.recordTypeChanged(thisTime.getClassName());
            return;
        }
        if (newResolvedType.isMissing()) {
            return;
        }
        this.world.ensureAdvancedConfigurationProcessed();
        byte[] newBytes = thisTime.getBytes();
        try {
            ClassFileReader reader = new ClassFileReader(newBytes, lastTime.getAbsolutePath().toCharArray());
            if (!reader.isLocal() && !reader.isAnonymous() && this.hasStructuralChanges(reader, existingStructure)) {
                if (this.world.forDEBUG_structuralChangesCode) {
                    System.err.println("Detected a structural change in " + thisTime.getFilename());
                }
                this.structuralChangesSinceLastFullBuild.put(thisTime.getFilename(), new Long(this.currentBuildTime));
                this.recordTypeChanged(new String(reader.getName()).replace('/', '.'));
            }
        }
        catch (ClassFormatException e) {
            this.recordTypeChanged(thisTime.getClassName());
        }
    }

    private boolean hasStructuralChanges(ClassFileReader reader, CompactTypeStructureRepresentation existingType) {
        IBinaryMethod[] existingMs;
        IBinaryField[] existingFs;
        if (existingType == null) {
            return true;
        }
        if (!this.modifiersEqual(reader.getModifiers(), existingType.modifiers)) {
            return true;
        }
        if (!CharOperation.equals(reader.getGenericSignature(), existingType.genericSignature)) {
            return true;
        }
        if (!CharOperation.equals(reader.getSuperclassName(), existingType.superclassName)) {
            return true;
        }
        IBinaryAnnotation[] newAnnos = reader.getAnnotations();
        if (newAnnos == null || newAnnos.length == 0) {
            if (existingType.annotations != null && existingType.annotations.length != 0) {
                return true;
            }
        } else {
            IBinaryAnnotation[] existingAnnos = existingType.annotations;
            if (existingAnnos == null || existingAnnos.length != newAnnos.length) {
                return true;
            }
            for (int i = 0; i < newAnnos.length; ++i) {
                if (CharOperation.equals(newAnnos[i].getTypeName(), existingAnnos[i].getTypeName())) continue;
                return true;
            }
        }
        char[][] existingIfs = existingType.interfaces;
        char[][] newIfsAsChars = reader.getInterfaceNames();
        if (newIfsAsChars == null) {
            newIfsAsChars = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs == null) {
            existingIfs = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs.length != newIfsAsChars.length) {
            return true;
        }
        block1: for (int i = 0; i < newIfsAsChars.length; ++i) {
            for (int j = 0; j < existingIfs.length; ++j) {
                if (CharOperation.equals(existingIfs[j], newIfsAsChars[i])) continue block1;
            }
            return true;
        }
        IBinaryField[] newFields = reader.getFields();
        if (newFields == null) {
            newFields = CompactTypeStructureRepresentation.NoField;
        }
        if (newFields.length != (existingFs = existingType.binFields).length) {
            return true;
        }
        block3: for (int i = 0; i < newFields.length; ++i) {
            IBinaryField field = newFields[i];
            char[] fieldName = field.getName();
            for (int j = 0; j < existingFs.length; ++j) {
                if (!CharOperation.equals(existingFs[j].getName(), fieldName)) continue;
                if (!this.modifiersEqual(field.getModifiers(), existingFs[j].getModifiers())) {
                    return true;
                }
                if (CharOperation.equals(existingFs[j].getTypeName(), field.getTypeName())) continue block3;
                return true;
            }
            return true;
        }
        IBinaryMethod[] newMethods = reader.getMethods();
        if (newMethods == null) {
            newMethods = CompactTypeStructureRepresentation.NoMethod;
        }
        if (newMethods.length != (existingMs = existingType.binMethods).length) {
            return true;
        }
        block5: for (int i = 0; i < newMethods.length; ++i) {
            IBinaryMethod method = newMethods[i];
            char[] methodName = method.getSelector();
            for (int j = 0; j < existingMs.length; ++j) {
                if (!CharOperation.equals(existingMs[j].getSelector(), methodName) || !CharOperation.equals(method.getMethodDescriptor(), existingMs[j].getMethodDescriptor())) continue;
                if (this.modifiersEqual(method.getModifiers(), existingMs[j].getModifiers())) continue block5;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean modifiersEqual(int eclipseModifiers, int resolvedTypeModifiers) {
        return (eclipseModifiers &= 0xFFFF) == (resolvedTypeModifiers &= 0xFFFF);
    }

    private String stringifyList(Set l) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Object el = iter.next();
            sb.append(el);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    protected void addAffectedSourceFiles(Set addTo, Set lastTimeSources) {
        char[][] simpleNames;
        char[][][] qualifiedNames;
        if (this.qualifiedStrings.elementSize == 0 && this.simpleStrings.elementSize == 0) {
            return;
        }
        if (this.listenerDefined()) {
            this.getListener().recordDecision("Examining whether any other files now need compilation based on just compiling: '" + this.stringifyList(lastTimeSources) + "'");
        }
        if ((qualifiedNames = ReferenceCollection.internQualifiedNames(this.qualifiedStrings)).length < this.qualifiedStrings.elementSize) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(this.simpleStrings)).length < this.simpleStrings.elementSize) {
            simpleNames = null;
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            File file;
            Map.Entry entry = i.next();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = (File)entry.getKey()).exists() || lastTimeSources.contains(file)) continue;
            if (this.listenerDefined()) {
                this.getListener().recordDecision("Need to recompile '" + file.getName().toString() + "'");
            }
            addTo.add(file);
        }
        if (addTo.size() > 0) {
            addTo.addAll(lastTimeSources);
        }
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
    }

    protected void recordTypeChanged(String typename) {
        String typeName;
        int lastDot = typename.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = typename.substring(0, lastDot).replace('.', '/');
            this.qualifiedStrings.add(packageName);
            typeName = typename.substring(lastDot + 1);
        } else {
            this.qualifiedStrings.add("");
            typeName = typename;
        }
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        this.simpleStrings.add(typeName);
    }

    protected void addDependentsOf(File sourceFile) {
        List cfs = (List)this.fullyQualifiedTypeNamesResultingFromCompilationUnit.get(sourceFile);
        if (cfs != null) {
            Iterator iter = cfs.iterator();
            while (iter.hasNext()) {
                ClassFile cf = (ClassFile)iter.next();
                this.recordTypeChanged(cf.fullyQualifiedTypeName);
            }
        }
    }

    public void setStructureModel(AsmManager structureModel) {
        this.structureModel = structureModel;
    }

    public AsmManager getStructureModel() {
        return this.structureModel;
    }

    public void setWeaver(BcelWeaver bw) {
        this.weaver = bw;
    }

    public BcelWeaver getWeaver() {
        return this.weaver;
    }

    public void setWorld(BcelWorld bw) {
        this.world = bw;
    }

    public BcelWorld getBcelWorld() {
        return this.world;
    }

    public int getNumberOfStructuralChangesSinceLastFullBuild() {
        return this.structuralChangesSinceLastFullBuild.size();
    }

    public long getLastBuildTime() {
        return this.lastSuccessfulBuildTime;
    }

    public long getLastFullBuildTime() {
        return this.lastSuccessfulFullBuildTime;
    }

    public AjBuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public void clearBinarySourceFiles() {
        this.binarySourceFiles = new HashMap();
    }

    public void recordBinarySource(String fromPathName, List unwovenClassFiles) {
        this.binarySourceFiles.put(fromPathName, unwovenClassFiles);
        if (this.maybeIncremental()) {
            LinkedList<ClassFile> simpleClassFiles = new LinkedList<ClassFile>();
            Iterator iter = unwovenClassFiles.iterator();
            while (iter.hasNext()) {
                UnwovenClassFile ucf = (UnwovenClassFile)iter.next();
                ClassFile cf = this.getClassFileFor(ucf);
                simpleClassFiles.add(cf);
            }
            this.inputClassFilesBySource.put(fromPathName, simpleClassFiles);
        }
    }

    private ClassFile getClassFileFor(UnwovenClassFile ucf) {
        return new ClassFile(ucf.getClassName(), new File(ucf.getFilename()));
    }

    public Map getBinarySourceMap() {
        return this.binarySourceFiles;
    }

    public Map getClassNameToFileMap() {
        return this.classesFromName;
    }

    public boolean hasResource(String resourceName) {
        return this.resources.contains(resourceName);
    }

    public void recordResource(String resourceName) {
        this.resources.add(resourceName);
    }

    public Set getAddedFiles() {
        return this.addedFiles;
    }

    public Set getDeletedFiles() {
        return this.deletedFiles;
    }

    public void forceBatchBuildNextTimeAround() {
        this.batchBuildRequiredThisTime = true;
    }

    public boolean requiresFullBatchBuild() {
        return this.batchBuildRequiredThisTime;
    }

    public void wipeAllKnowledge() {
        this.buildManager.state = null;
    }

    public Map getAspectNamesToFileNameMap() {
        return this.aspectsFromFileNames;
    }

    public void initializeAspectNamesToFileNameMap() {
        this.aspectsFromFileNames = new HashMap();
    }

    public boolean listenerDefined() {
        return stateListener != null;
    }

    public IStateListener getListener() {
        return stateListener;
    }

    public IBinaryType checkPreviousBuild(String name) {
        return (IBinaryType)this.resolvedTypeStructuresFromLastBuild.get(name);
    }

    public AjBuildManager getAjBuildManager() {
        return this.buildManager;
    }

    public INameEnvironment getNameEnvironment() {
        return this.nameEnvironment;
    }

    public void setNameEnvironment(INameEnvironment nameEnvironment) {
        this.nameEnvironment = nameEnvironment;
    }

    public void recordAspectClassFile(String aspectFile) {
        this.aspectClassFiles.add(aspectFile);
    }

    private static class ClassFile {
        public String fullyQualifiedTypeName;
        public File locationOnDisk;

        public ClassFile(String fqn, File location) {
            this.fullyQualifiedTypeName = fqn;
            this.locationOnDisk = location;
        }

        public void deleteFromFileSystem() {
            File[] weaverGenerated;
            String namePrefix = this.locationOnDisk.getName();
            namePrefix = namePrefix.substring(0, namePrefix.lastIndexOf(46));
            final String targetPrefix = namePrefix + "$Ajc";
            File dir = this.locationOnDisk.getParentFile();
            if (dir != null && (weaverGenerated = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(targetPrefix);
                }
            })) != null) {
                for (int i = 0; i < weaverGenerated.length; ++i) {
                    weaverGenerated[i].delete();
                }
            }
            this.locationOnDisk.delete();
        }
    }

    public static class SoftHashMap
    extends AbstractMap {
        private final Map map;
        private final ReferenceQueue rq = new ReferenceQueue();

        public SoftHashMap(Map map) {
            this.map = map;
        }

        public SoftHashMap() {
            this(new HashMap());
        }

        public SoftHashMap(Map map, boolean b) {
            this(map);
        }

        private void processQueue() {
            SoftReferenceKnownKey sv = null;
            while ((sv = (SoftReferenceKnownKey)this.rq.poll()) != null) {
                this.map.remove(sv.key);
            }
        }

        public Object get(Object key) {
            SoftReferenceKnownKey value = (SoftReferenceKnownKey)this.map.get(key);
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.map.remove(value.key);
                return null;
            }
            return value.get();
        }

        public Object put(Object k, Object v) {
            this.processQueue();
            return this.map.put(k, new SoftReferenceKnownKey(k, v));
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public void clear() {
            this.processQueue();
            this.map.clear();
        }

        public int size() {
            this.processQueue();
            return this.map.size();
        }

        public Object remove(Object k) {
            this.processQueue();
            SoftReferenceKnownKey value = (SoftReferenceKnownKey)this.map.remove(k);
            if (value == null) {
                return null;
            }
            if (value.get() != null) {
                return value.get();
            }
            return null;
        }

        class SoftReferenceKnownKey
        extends SoftReference {
            private final Object key;

            SoftReferenceKnownKey(Object k, Object v) {
                super(v, SoftHashMap.this.rq);
                this.key = k;
            }
        }
    }
}

