/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.structurals;

import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFieldref;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.FieldOrMethod;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.IINC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.InstVisitor;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.ReturnaddressType;
import org.aspectj.apache.bcel.generic.TABLESWITCH;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.verifier.EmptyInstVisitor;
import org.aspectj.apache.bcel.verifier.VerificationResult;
import org.aspectj.apache.bcel.verifier.Verifier;
import org.aspectj.apache.bcel.verifier.VerifierFactory;
import org.aspectj.apache.bcel.verifier.exc.AssertionViolatedException;
import org.aspectj.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.aspectj.apache.bcel.verifier.structurals.Frame;
import org.aspectj.apache.bcel.verifier.structurals.LocalVariables;
import org.aspectj.apache.bcel.verifier.structurals.OperandStack;
import org.aspectj.apache.bcel.verifier.structurals.UninitializedObjectType;

public class InstConstraintVisitor
extends EmptyInstVisitor
implements InstVisitor {
    private static ObjectType GENERIC_ARRAY = new ObjectType("org.aspectj.apache.bcel.verifier.structurals.GenericArray");
    private Frame frame = null;
    private ConstantPool cpg = null;
    private MethodGen mg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(Instruction violator, String description) {
        String fq_classname = violator.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + fq_classname.substring(fq_classname.lastIndexOf(46) + 1) + " constraint violated: " + description);
    }

    public void setFrame(Frame f) {
        this.frame = f;
    }

    public void setConstantPoolGen(ConstantPool cpg) {
        this.cpg = cpg;
    }

    public void setMethodGen(MethodGen mg) {
        this.mg = mg;
    }

    private void indexOfInt(Instruction o, Type index) {
        if (!index.equals(Type.INT)) {
            this.constraintViolated(o, "The 'index' is not of type int but of type " + index + ".");
        }
    }

    private void referenceTypeIsInitialized(Instruction o, ReferenceType r) {
        if (r instanceof UninitializedObjectType) {
            this.constraintViolated(o, "Working on an uninitialized object '" + r + "'.");
        }
    }

    private void valueOfInt(Instruction o, Type value) {
        if (!value.equals(Type.INT)) {
            this.constraintViolated(o, "The 'value' is not of type int but of type " + value + ".");
        }
    }

    private boolean arrayrefOfArrayType(Instruction o, Type arrayref) {
        if (!(arrayref instanceof ArrayType) && !arrayref.equals(Type.NULL)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array but is of type " + arrayref + ".");
        }
        return arrayref instanceof ArrayType;
    }

    private void _visitStackAccessor(Instruction o) {
        int produce;
        int consume = o.consumeStack(this.cpg);
        if (consume > this.stack().slotsUsed()) {
            this.constraintViolated(o, "Cannot consume " + consume + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((produce = o.produceStack(this.cpg) - o.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(o, "Cannot produce " + produce + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    public void visitLoadClass(Instruction o) {
        Verifier v;
        VerificationResult vr;
        ObjectType t = o.getLoadClassType(this.cpg);
        if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitStackConsumer(Instruction o) {
        this._visitStackAccessor(o);
    }

    public void visitStackProducer(Instruction o) {
        this._visitStackAccessor(o);
    }

    public void visitCPInstruction(Instruction o) {
        int idx = o.getIndex();
        if (idx < 0 || idx >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + o + "' illegal? Pass 3a should have checked this!");
        }
    }

    public void visitFieldInstruction(Instruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantFieldref)) {
            this.constraintViolated(o, "Index '" + o.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + c + "'.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitInvokeInstruction(InvokeInstruction o) {
    }

    public void visitStackInstruction(Instruction o) {
        this._visitStackAccessor(o);
    }

    public void visitLocalVariableInstruction(InstructionLV o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
    }

    public void visitLoadInstruction(Instruction o) {
        if (this.locals().get(o.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(o, "Read-Access on local variable " + o.getIndex() + " with unknown content.");
        }
        if (o.getType(this.cpg).getSize() == 2 && this.locals().get(o.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(o, "Reading a two-locals value from local variables " + o.getIndex() + " and " + (o.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!o.isALOAD()) {
            if (this.locals().get(o.getIndex()) != o.getType(this.cpg)) {
                this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(o.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(o, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < o.getType(this.cpg).getSize()) {
            this.constraintViolated(o, "Not enough free stack slots to load a '" + o.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    public void visitStoreInstruction(Instruction o) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(o, "Cannot STORE: Stack to read from is empty.");
        }
        if (!o.isASTORE()) {
            if (this.stack().peek() != o.getType(this.cpg)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + o.getType(this.cpg) + "'.");
            }
        } else {
            Type stacktop = this.stack().peek();
            if (!(stacktop instanceof ReferenceType) && !(stacktop instanceof ReturnaddressType)) {
                this.constraintViolated(o, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
            if (stacktop instanceof ReferenceType) {
                this.referenceTypeIsInitialized(o, (ReferenceType)stacktop);
            }
        }
    }

    public void visitReturnInstruction(Instruction o) {
        if (o.getOpcode() == 177) {
            return;
        }
        if (o.getOpcode() == 176) {
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(o, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        } else {
            Type method_type = this.mg.getType();
            if (method_type == Type.BOOLEAN || method_type == Type.BYTE || method_type == Type.SHORT || method_type == Type.CHAR) {
                method_type = Type.INT;
            }
            if (!method_type.equals(this.stack().peek())) {
                this.constraintViolated(o, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + method_type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
            }
        }
    }

    public void visitAALOAD(Instruction o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref)) {
            if (!(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
            }
            this.referenceTypeIsInitialized(o, (ReferenceType)((ArrayType)arrayref).getElementType());
        }
    }

    public void visitAASTORE(Instruction o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (!(value instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'value' is not of a ReferenceType but of type " + value + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)value);
        }
        if (this.arrayrefOfArrayType(o, arrayref)) {
            if (!(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
            }
            if (!((ReferenceType)value).isAssignmentCompatibleWith((ReferenceType)((ArrayType)arrayref).getElementType())) {
                this.constraintViolated(o, "The type of 'value' ('" + value + "') is not assignment compatible to the components of the array 'arrayref' refers to. ('" + ((ArrayType)arrayref).getElementType() + "')");
            }
        }
    }

    public void visitACONST_NULL(Instruction o) {
    }

    public void visitALOAD(Instruction o) {
    }

    public void visitANEWARRAY(Instruction o) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(o, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitARETURN(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType objectref = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(o, objectref);
    }

    public void visitARRAYLENGTH(Instruction o) {
        Type arrayref = this.stack().peek(0);
        this.arrayrefOfArrayType(o, arrayref);
    }

    public void visitASTORE(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
        if (this.stack().peek() instanceof ReferenceType) {
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        }
    }

    public void visitATHROW(Instruction o) {
        ObjectType throwable;
        if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
            this.constraintViolated(o, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
        }
        if (this.stack().peek().equals(Type.NULL)) {
            return;
        }
        ObjectType exc = (ObjectType)this.stack().peek();
        if (!exc.subclassOf(throwable = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !exc.equals(throwable)) {
            this.constraintViolated(o, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
        }
    }

    public void visitBALOAD(Instruction o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBASTORE(Instruction o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBIPUSH(Instruction o) {
    }

    public void visitBREAKPOINT(Instruction o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    public void visitCALOAD(Instruction o) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.arrayrefOfArrayType(o, arrayref);
    }

    public void visitCASTORE(Instruction o) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o, index);
        this.valueOfInt(o, value);
        if (this.arrayrefOfArrayType(o, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(o, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    public void visitCHECKCAST(Instruction o) {
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)objectref);
        }
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    public void visitD2F(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
    }

    public void visitD2I(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
    }

    public void visitD2L(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
    }

    public void visitDADD(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDALOAD(Instruction o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDASTORE(Instruction o) {
        Type t;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitDCMPG(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCMPL(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCONST(Instruction o) {
    }

    public void visitDDIV(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDLOAD(Instruction o) {
    }

    public void visitDMUL(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDNEG(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
    }

    public void visitDREM(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    private void checkTop(Instruction o, Type t) {
        if (this.stack().peek() != t) {
            this.constraintViolated(o, "The value at the stack top is not of type '" + t + "', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDRETURN(Instruction o) {
        this.checkTop(o, Type.DOUBLE);
    }

    public void visitDSTORE(Instruction o) {
    }

    public void visitDSUB(Instruction o) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDUP(Instruction o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitDUP_X1(Instruction o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitDUP_X2(Instruction o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    public void visitDUP2(Instruction o) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X1(Instruction o) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(o, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X2(Instruction o) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(o, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    public void visitF2D(Instruction o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2I(Instruction o) {
        this.checkTop(o, Type.FLOAT);
    }

    public void visitF2L(Instruction o) {
        this.checkTop(o, Type.FLOAT);
    }

    public void visitFADD(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFALOAD(Instruction o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFASTORE(Instruction o) {
        Type t;
        this.checkTop(o, Type.FLOAT);
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitFCMPG(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCMPL(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCONST(Instruction o) {
    }

    public void visitFDIV(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFLOAD(Instruction o) {
    }

    public void visitFMUL(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFNEG(Instruction o) {
        this.checkTop(o, Type.FLOAT);
    }

    public void visitFREM(Instruction o) {
        this.checkTop(o, Type.FLOAT);
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFRETURN(Instruction o) {
        this.checkTop(o, Type.FLOAT);
    }

    public void visitFSTORE(Instruction o) {
    }

    public void visitFSUB(Instruction o) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitGETFIELD(FieldInstruction o) {
        ObjectType curr;
        ObjectType classtype;
        Type objectref = this.stack().peek();
        if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
            this.constraintViolated(o, "Stack top should be an object reference that's not an array reference, but is '" + objectref + "'.");
        }
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        Modifiers f = null;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(field_name)) {
                f = fields[i];
                break;
            }
            ++i;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        if (f.isProtected() && ((classtype = o.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
            ObjectType objreftype;
            Type t = this.stack().peek();
            if (t == Type.NULL) {
                return;
            }
            if (!(t instanceof ObjectType)) {
                this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + t + "'.");
            }
            if (!(objreftype = (ObjectType)t).equals(curr)) {
                objreftype.subclassOf(curr);
            }
        }
        if (f.isStatic()) {
            this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
        }
    }

    public void visitGETSTATIC(FieldInstruction o) {
    }

    public void visitGOTO(Instruction o) {
    }

    public void visitGOTO_W(Instruction o) {
    }

    public void visitI2B(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2C(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2D(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2F(Instruction o) {
        this.checkTop(o, Type.INT);
    }

    public void visitI2L(Instruction o) {
        this.checkTop(o, Type.INT);
    }

    public void visitI2S(Instruction o) {
        this.checkTop(o, Type.INT);
    }

    public void visitIADD(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIALOAD(Instruction o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIAND(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIASTORE(Instruction o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitICONST(Instruction o) {
    }

    public void visitIDIV(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ACMPEQ(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek(1));
    }

    public void visitIF_ACMPNE(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
            this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek(1));
        }
    }

    public void visitIF_ICMPEQ(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGT(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLT(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPNE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIFEQ(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGT(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLT(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNE(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNONNULL(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitIFNULL(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitIINC(IINC o) {
        if (this.locals().maxLocals() <= (o.getType(this.cpg).getSize() == 1 ? o.getIndex() : o.getIndex() + 1)) {
            this.constraintViolated(o, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(o, this.locals().get(o.getIndex()));
    }

    public void visitILOAD(Instruction o) {
    }

    public void visitIMPDEP1(Instruction o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    public void visitIMPDEP2(Instruction o) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    public void visitIMUL(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitINEG(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitINSTANCEOF(Instruction o) {
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        } else {
            this.referenceTypeIsInitialized(o, (ReferenceType)objectref);
        }
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantClass)) {
            this.constraintViolated(o, "The Constant at 'index' is not a ConstantClass, but '" + c + "'.");
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        int count = o.getCount();
        if (count == 0) {
            this.constraintViolated(o, "The 'count' argument must not be 0.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        int i = nargs - 1;
        while (i >= 0) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (!(fromStack.equals(fromDesc) || fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType)) {
                this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            --i;
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        int counted_count = 1;
        int i2 = 0;
        while (i2 < nargs) {
            counted_count += argtypes[i2].getSize();
            ++i2;
        }
        if (count != counted_count) {
            this.constraintViolated(o, "The 'count' argument should probably read '" + counted_count + "' but is '" + count + "'.");
        }
    }

    public void visitINVOKESPECIAL(InvokeInstruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t;
        if (o.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(o.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
            this.constraintViolated(o, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
        }
        if ((t = o.getType(this.cpg)) instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        int i = nargs - 1;
        while (i >= 0) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (!fromStack.equals(fromDesc)) {
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                } else {
                    this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
                }
            }
            --i;
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        String objref_classname = null;
        if (!o.getMethodName(this.cpg).equals("<init>")) {
            this.referenceTypeIsInitialized(o, (ReferenceType)objref);
            if (!(objref instanceof ObjectType)) {
                if (!(objref instanceof ArrayType)) {
                    this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                } else {
                    objref = GENERIC_ARRAY;
                }
            }
            objref_classname = ((ObjectType)objref).getClassName();
        } else {
            if (!(objref instanceof UninitializedObjectType)) {
                this.constraintViolated(o, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + objref + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
            }
            objref_classname = ((UninitializedObjectType)objref).getInitialized().getClassName();
        }
        String theClass = o.getClassName(this.cpg);
        if (!Repository.instanceOf(objref_classname, theClass)) {
            this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
        }
    }

    public void visitINVOKESTATIC(InvokeInstruction o) {
        String name;
        Verifier v;
        VerificationResult vr;
        Type t = o.getType(this.cpg);
        if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        int i = nargs - 1;
        while (i >= 0) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (!fromStack.equals(fromDesc)) {
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                } else {
                    this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
                }
            }
            --i;
        }
    }

    public void visitINVOKEVIRTUAL(InvokeInstruction o) {
        String theClass;
        String objref_classname;
        String name;
        Verifier v;
        VerificationResult vr;
        Type t = o.getType(this.cpg);
        if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(name = ((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        int i = nargs - 1;
        while (i >= 0) {
            Type fromStack = this.stack().peek(nargs - 1 - i);
            Type fromDesc = argtypes[i];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (!fromStack.equals(fromDesc)) {
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                } else {
                    this.constraintViolated(o, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
                }
            }
            --i;
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        if (!Repository.instanceOf(objref_classname = ((ObjectType)objref).getClassName(), theClass = o.getClassName(this.cpg))) {
            this.constraintViolated(o, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
        }
    }

    public void visitIOR(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIREM(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIRETURN(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitISHL(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISHR(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISTORE(Instruction o) {
    }

    public void visitISUB(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIUSHR(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIXOR(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitJSR(InstructionBranch o) {
    }

    public void visitJSR_W(InstructionBranch o) {
    }

    public void visitL2D(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2F(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2I(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLADD(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLALOAD(Instruction o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLAND(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLASTORE(Instruction o) {
        Type t;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitLCMP(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLCONST(Instruction o) {
    }

    public void visitLDC(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDC_W(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDC2_W(Instruction o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
            this.constraintViolated(o, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c + "'.");
        }
    }

    public void visitLDIV(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLLOAD(Instruction o) {
    }

    public void visitLMUL(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLNEG(Instruction o) {
        this.checkTop(o, Type.LONG);
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
        this.checkTop(o, Type.INT);
    }

    public void visitLOR(Instruction o) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLREM(Instruction o) {
        this.checkTop(o, Type.LONG);
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLRETURN(Instruction o) {
        this.checkTop(o, Type.LONG);
    }

    public void visitLSHL(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSHR(Instruction o) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSTORE(Instruction o) {
    }

    public void visitLSUB(Instruction o) {
        this.checkTop(o, Type.LONG);
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLUSHR(Instruction o) {
        this.checkTop(o, Type.INT);
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLXOR(Instruction o) {
        this.checkTop(o, Type.LONG);
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitMONITORENTER(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitMONITOREXIT(Instruction o) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o, (ReferenceType)this.stack().peek());
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
        int dimensions = o.getDimensions();
        int i = 0;
        while (i < dimensions) {
            if (this.stack().peek(i) != Type.INT) {
                this.constraintViolated(o, "The '" + dimensions + "' upper stack types should be 'int' but aren't.");
            }
            ++i;
        }
    }

    public void visitNEW(Instruction o) {
        ObjectType obj;
        Type t = o.getType(this.cpg);
        if (!(t instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(t instanceof ObjectType)) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + t + "'.");
        }
        if (!(obj = (ObjectType)t).referencesClass()) {
            this.constraintViolated(o, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'.");
        }
    }

    public void visitNEWARRAY(Instruction o) {
        this.checkTop(o, Type.INT);
    }

    public void visitNOP(Instruction o) {
    }

    public void visitPOP(Instruction o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPOP2(Instruction o) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(o, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPUTFIELD(FieldInstruction o) {
        ObjectType curr;
        ObjectType classtype;
        Type objectref = this.stack().peek(1);
        if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
            this.constraintViolated(o, "Stack next-to-top should be an object reference that's not an array reference, but is '" + objectref + "'.");
        }
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        FieldOrMethod f = null;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(field_name)) {
                f = fields[i];
                break;
            }
            ++i;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type value = this.stack().peek();
        Type t = Type.getType(f.getSignature());
        Type shouldbe = t;
        if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
            shouldbe = Type.INT;
        }
        if (t instanceof ReferenceType) {
            ReferenceType rvalue = null;
            if (value instanceof ReferenceType) {
                rvalue = (ReferenceType)value;
                this.referenceTypeIsInitialized(o, rvalue);
            } else {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
            }
            if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
            }
        } else if (shouldbe != value) {
            this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
        }
        if (f.isProtected() && ((classtype = o.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
            ObjectType objreftype;
            Type tp = this.stack().peek(1);
            if (tp == Type.NULL) {
                return;
            }
            if (!(tp instanceof ObjectType)) {
                this.constraintViolated(o, "The 'objectref' must refer to an object that's not an array. Found instead: '" + tp + "'.");
            }
            if (!(objreftype = (ObjectType)tp).equals(curr) && !objreftype.subclassOf(curr)) {
                this.constraintViolated(o, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
            }
        }
        if (f.isStatic()) {
            this.constraintViolated(o, "Referenced field '" + f + "' is static which it shouldn't be.");
        }
    }

    public void visitPUTSTATIC(FieldInstruction o) {
        String field_name = o.getFieldName(this.cpg);
        JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
        Field[] fields = jc.getFields();
        FieldOrMethod f = null;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(field_name)) {
                f = fields[i];
                break;
            }
            ++i;
        }
        if (f == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type value = this.stack().peek();
        Type t = Type.getType(f.getSignature());
        Type shouldbe = t;
        if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
            shouldbe = Type.INT;
        }
        if (t instanceof ReferenceType) {
            ReferenceType rvalue = null;
            if (value instanceof ReferenceType) {
                rvalue = (ReferenceType)value;
                this.referenceTypeIsInitialized(o, rvalue);
            } else {
                this.constraintViolated(o, "The stack top type '" + value + "' is not of a reference type as expected.");
            }
            if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                this.constraintViolated(o, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
            }
        } else if (shouldbe != value) {
            this.constraintViolated(o, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
        }
    }

    public void visitRET(RET o) {
        if (!(this.locals().get(o.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(o, "Expecting a ReturnaddressType in local variable " + o.getIndex() + ".");
        }
        if (this.locals().get(o.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    public void visitRETURN(Instruction o) {
        if (this.mg.getName().equals("<init>") && Frame._this != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
            this.constraintViolated(o, "Leaving a constructor that itself did not call a constructor.");
        }
    }

    public void visitSALOAD(Instruction o) {
        Type t;
        this.indexOfInt(o, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitSASTORE(Instruction o) {
        Type t;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitSIPUSH(Instruction o) {
    }

    public void visitSWAP(Instruction o) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitTABLESWITCH(TABLESWITCH o) {
        this.indexOfInt(o, this.stack().peek());
    }
}

