/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.IINC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.InstVisitor;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.InstructionComparator;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InstructionShort;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.TABLESWITCH;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ByteSequence;

public class Instruction
implements Cloneable,
Serializable,
Constants {
    public short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short opcode) {
        this.opcode = opcode;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public String toString(boolean verbose) {
        if (verbose) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName()).append("[").append(this.opcode).append("](size").append(Constants.iLen[this.opcode]).append(")");
            return sb.toString();
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool cp) {
        return this.toString(false);
    }

    public final Instruction copy() {
        if (InstructionConstants.INSTRUCTIONS[this.opcode] != null) {
            return this;
        }
        Instruction i = null;
        try {
            i = (Instruction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return i;
    }

    public static final Instruction readInstruction(ByteSequence bytes) throws IOException {
        Instruction constantInstruction;
        boolean wide = false;
        short opcode = (short)bytes.readUnsignedByte();
        Instruction obj = null;
        if (opcode == 196) {
            wide = true;
            opcode = (short)bytes.readUnsignedByte();
        }
        if ((constantInstruction = InstructionConstants.INSTRUCTIONS[opcode]) != null) {
            return constantInstruction;
        }
        try {
            switch (opcode) {
                case 16: {
                    obj = new InstructionByte(16, bytes.readByte());
                    break;
                }
                case 17: {
                    obj = new InstructionShort(17, bytes.readShort());
                    break;
                }
                case 18: {
                    obj = new InstructionCP(18, bytes.readUnsignedByte());
                    break;
                }
                case 19: {
                    obj = new InstructionCP(19, bytes.readUnsignedShort());
                    break;
                }
                case 20: {
                    obj = new InstructionCP(20, bytes.readUnsignedShort());
                    break;
                }
                case 21: {
                    obj = new InstructionLV(21, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 22: {
                    obj = new InstructionLV(22, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 23: {
                    obj = new InstructionLV(23, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 24: {
                    obj = new InstructionLV(24, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 25: {
                    obj = new InstructionLV(25, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 26: {
                    obj = new InstructionLV(26);
                    break;
                }
                case 27: {
                    obj = new InstructionLV(27);
                    break;
                }
                case 28: {
                    obj = new InstructionLV(28);
                    break;
                }
                case 29: {
                    obj = new InstructionLV(29);
                    break;
                }
                case 30: {
                    obj = new InstructionLV(30);
                    break;
                }
                case 31: {
                    obj = new InstructionLV(31);
                    break;
                }
                case 32: {
                    obj = new InstructionLV(32);
                    break;
                }
                case 33: {
                    obj = new InstructionLV(33);
                    break;
                }
                case 34: {
                    obj = new InstructionLV(34);
                    break;
                }
                case 35: {
                    obj = new InstructionLV(35);
                    break;
                }
                case 36: {
                    obj = new InstructionLV(36);
                    break;
                }
                case 37: {
                    obj = new InstructionLV(37);
                    break;
                }
                case 38: {
                    obj = new InstructionLV(38);
                    break;
                }
                case 39: {
                    obj = new InstructionLV(39);
                    break;
                }
                case 40: {
                    obj = new InstructionLV(40);
                    break;
                }
                case 41: {
                    obj = new InstructionLV(41);
                    break;
                }
                case 42: {
                    obj = new InstructionLV(42);
                    break;
                }
                case 43: {
                    obj = new InstructionLV(43);
                    break;
                }
                case 44: {
                    obj = new InstructionLV(44);
                    break;
                }
                case 45: {
                    obj = new InstructionLV(45);
                    break;
                }
                case 59: {
                    obj = new InstructionLV(59);
                    break;
                }
                case 60: {
                    obj = new InstructionLV(60);
                    break;
                }
                case 61: {
                    obj = new InstructionLV(61);
                    break;
                }
                case 62: {
                    obj = new InstructionLV(62);
                    break;
                }
                case 63: {
                    obj = new InstructionLV(63);
                    break;
                }
                case 64: {
                    obj = new InstructionLV(64);
                    break;
                }
                case 65: {
                    obj = new InstructionLV(65);
                    break;
                }
                case 66: {
                    obj = new InstructionLV(66);
                    break;
                }
                case 67: {
                    obj = new InstructionLV(67);
                    break;
                }
                case 68: {
                    obj = new InstructionLV(68);
                    break;
                }
                case 69: {
                    obj = new InstructionLV(69);
                    break;
                }
                case 70: {
                    obj = new InstructionLV(70);
                    break;
                }
                case 71: {
                    obj = new InstructionLV(71);
                    break;
                }
                case 72: {
                    obj = new InstructionLV(72);
                    break;
                }
                case 73: {
                    obj = new InstructionLV(73);
                    break;
                }
                case 74: {
                    obj = new InstructionLV(74);
                    break;
                }
                case 75: {
                    obj = new InstructionLV(75);
                    break;
                }
                case 76: {
                    obj = new InstructionLV(76);
                    break;
                }
                case 77: {
                    obj = new InstructionLV(77);
                    break;
                }
                case 78: {
                    obj = new InstructionLV(78);
                    break;
                }
                case 54: {
                    obj = new InstructionLV(54, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 55: {
                    obj = new InstructionLV(55, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 56: {
                    obj = new InstructionLV(56, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 57: {
                    obj = new InstructionLV(57, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 58: {
                    obj = new InstructionLV(58, wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte());
                    break;
                }
                case 132: {
                    obj = new IINC(wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte(), wide ? bytes.readShort() : (short)bytes.readByte(), wide);
                    break;
                }
                case 198: {
                    obj = new InstructionBranch(198, bytes.readShort());
                    break;
                }
                case 199: {
                    obj = new InstructionBranch(199, bytes.readShort());
                    break;
                }
                case 153: {
                    obj = new InstructionBranch(153, bytes.readShort());
                    break;
                }
                case 154: {
                    obj = new InstructionBranch(154, bytes.readShort());
                    break;
                }
                case 155: {
                    obj = new InstructionBranch(155, bytes.readShort());
                    break;
                }
                case 156: {
                    obj = new InstructionBranch(156, bytes.readShort());
                    break;
                }
                case 157: {
                    obj = new InstructionBranch(157, bytes.readShort());
                    break;
                }
                case 158: {
                    obj = new InstructionBranch(158, bytes.readShort());
                    break;
                }
                case 159: {
                    obj = new InstructionBranch(159, bytes.readShort());
                    break;
                }
                case 160: {
                    obj = new InstructionBranch(160, bytes.readShort());
                    break;
                }
                case 161: {
                    obj = new InstructionBranch(161, bytes.readShort());
                    break;
                }
                case 162: {
                    obj = new InstructionBranch(162, bytes.readShort());
                    break;
                }
                case 163: {
                    obj = new InstructionBranch(163, bytes.readShort());
                    break;
                }
                case 164: {
                    obj = new InstructionBranch(164, bytes.readShort());
                    break;
                }
                case 165: {
                    obj = new InstructionBranch(165, bytes.readShort());
                    break;
                }
                case 166: {
                    obj = new InstructionBranch(166, bytes.readShort());
                    break;
                }
                case 167: {
                    obj = new InstructionBranch(167, bytes.readShort());
                    break;
                }
                case 200: {
                    obj = new InstructionBranch(200, bytes.readInt());
                    break;
                }
                case 168: {
                    obj = new InstructionBranch(168, bytes.readShort());
                    break;
                }
                case 201: {
                    obj = new InstructionBranch(201, bytes.readInt());
                    break;
                }
                case 170: {
                    obj = new TABLESWITCH(bytes);
                    break;
                }
                case 171: {
                    obj = new LOOKUPSWITCH(bytes);
                    break;
                }
                case 169: {
                    obj = new RET(wide ? bytes.readUnsignedShort() : bytes.readUnsignedByte(), wide);
                    break;
                }
                case 187: {
                    obj = new InstructionCP(187, bytes.readUnsignedShort());
                    break;
                }
                case 178: {
                    obj = new FieldInstruction(178, bytes.readUnsignedShort());
                    break;
                }
                case 179: {
                    obj = new FieldInstruction(179, bytes.readUnsignedShort());
                    break;
                }
                case 180: {
                    obj = new FieldInstruction(180, bytes.readUnsignedShort());
                    break;
                }
                case 181: {
                    obj = new FieldInstruction(181, bytes.readUnsignedShort());
                    break;
                }
                case 182: {
                    obj = new InvokeInstruction(182, bytes.readUnsignedShort());
                    break;
                }
                case 183: {
                    obj = new InvokeInstruction(183, bytes.readUnsignedShort());
                    break;
                }
                case 184: {
                    obj = new InvokeInstruction(184, bytes.readUnsignedShort());
                    break;
                }
                case 185: {
                    obj = new INVOKEINTERFACE(bytes.readUnsignedShort(), bytes.readUnsignedByte(), bytes.readByte());
                    break;
                }
                case 188: {
                    obj = new InstructionByte(188, bytes.readByte());
                    break;
                }
                case 189: {
                    obj = new InstructionCP(189, bytes.readUnsignedShort());
                    break;
                }
                case 192: {
                    obj = new InstructionCP(192, bytes.readUnsignedShort());
                    break;
                }
                case 193: {
                    obj = new InstructionCP(193, bytes.readUnsignedShort());
                    break;
                }
                case 197: {
                    obj = new MULTIANEWARRAY(bytes.readUnsignedShort(), bytes.readByte());
                    break;
                }
                default: {
                    throw new ClassGenException("Illegal opcode detected");
                }
            }
        }
        catch (ClassGenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassGenException(e.toString());
        }
        return obj;
    }

    public int consumeStack(ConstantPool cpg) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPool cpg) {
        return Constants.stackEntriesProduced[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        byte len = Constants.iLen[this.opcode];
        if (len == 0) {
            throw new IllegalStateException("Length not right for " + this.getName().toUpperCase());
        }
        return len;
    }

    void dispose() {
    }

    public void accept(InstVisitor v) {
        switch (this.opcode) {
            case 254: {
                v.visitIMPDEP1(this);
                break;
            }
            case 255: {
                v.visitIMPDEP2(this);
                break;
            }
            case 194: {
                v.visitExceptionThrower(this);
                v.visitStackConsumer(this);
                v.visitMONITORENTER(this);
                break;
            }
            case 195: {
                v.visitExceptionThrower(this);
                v.visitStackConsumer(this);
                v.visitMONITOREXIT(this);
                break;
            }
            case 148: {
                v.visitTypedInstruction(this);
                v.visitStackProducer(this);
                v.visitStackConsumer(this);
                v.visitLCMP(this);
                break;
            }
            case 149: {
                v.visitTypedInstruction(this);
                v.visitStackProducer(this);
                v.visitStackConsumer(this);
                v.visitFCMPL(this);
                break;
            }
            case 150: {
                v.visitTypedInstruction(this);
                v.visitStackProducer(this);
                v.visitStackConsumer(this);
                v.visitFCMPG(this);
                break;
            }
            case 151: {
                v.visitTypedInstruction(this);
                v.visitStackProducer(this);
                v.visitStackConsumer(this);
                v.visitDCMPL(this);
                break;
            }
            case 152: {
                v.visitTypedInstruction(this);
                v.visitStackProducer(this);
                v.visitStackConsumer(this);
                v.visitDCMPG(this);
                break;
            }
            case 0: {
                v.visitNOP(this);
                break;
            }
            case 202: {
                v.visitBREAKPOINT(this);
                break;
            }
            case 95: {
                v.visitStackConsumer(this);
                v.visitStackProducer(this);
                v.visitStackInstruction(this);
                v.visitSWAP(this);
                break;
            }
            case 87: {
                v.visitStackConsumer(this);
                v.visitPopInstruction(this);
                v.visitStackInstruction(this);
                v.visitPOP(this);
                break;
            }
            case 88: {
                v.visitStackConsumer(this);
                v.visitPopInstruction(this);
                v.visitStackInstruction(this);
                v.visitPOP2(this);
                break;
            }
            case 93: {
                v.visitStackInstruction(this);
                v.visitDUP2_X1(this);
                break;
            }
            case 94: {
                v.visitStackInstruction(this);
                v.visitDUP2_X2(this);
                break;
            }
            case 92: {
                v.visitStackProducer(this);
                v.visitPushInstruction(this);
                v.visitStackInstruction(this);
                v.visitDUP2(this);
                break;
            }
            case 90: {
                v.visitStackInstruction(this);
                v.visitDUP_X1(this);
                break;
            }
            case 91: {
                v.visitStackInstruction(this);
                v.visitDUP_X2(this);
                break;
            }
            case 89: {
                v.visitStackProducer(this);
                v.visitPushInstruction(this);
                v.visitStackInstruction(this);
                v.visitDUP(this);
                break;
            }
            case 84: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitBASTORE(this);
                break;
            }
            case 85: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitCASTORE(this);
                break;
            }
            case 86: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitSASTORE(this);
                break;
            }
            case 82: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitDASTORE(this);
                break;
            }
            case 81: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitFASTORE(this);
                break;
            }
            case 80: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitLASTORE(this);
                break;
            }
            case 79: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitIASTORE(this);
                break;
            }
            case 83: {
                v.visitStackConsumer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitAASTORE(this);
                break;
            }
            case 53: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitSALOAD(this);
                break;
            }
            case 52: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitCALOAD(this);
                break;
            }
            case 49: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitDALOAD(this);
                break;
            }
            case 48: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitFALOAD(this);
                break;
            }
            case 47: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitLALOAD(this);
                break;
            }
            case 50: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitAALOAD(this);
                break;
            }
            case 191: {
                v.visitUnconditionalBranch(this);
                v.visitExceptionThrower(this);
                v.visitATHROW(this);
                break;
            }
            case 1: {
                v.visitStackProducer(this);
                v.visitPushInstruction(this);
                v.visitTypedInstruction(this);
                v.visitACONST_NULL(this);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitICONST(this);
                break;
            }
            case 9: 
            case 10: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitLCONST(this);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitFCONST(this);
                break;
            }
            case 14: 
            case 15: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitDCONST(this);
            }
            case 51: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitBALOAD(this);
                break;
            }
            case 46: {
                v.visitStackProducer(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitArrayInstruction(this);
                v.visitIALOAD(this);
            }
            case 16: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitBIPUSH(this);
                break;
            }
            case 17: {
                v.visitPushInstruction(this);
                v.visitStackProducer(this);
                v.visitTypedInstruction(this);
                v.visitConstantPushInstruction(this);
                v.visitSIPUSH(this);
                break;
            }
            case 18: 
            case 19: {
                v.visitStackProducer(this);
                v.visitPushInstruction(this);
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitCPInstruction(this);
                v.visitLDC(this);
                break;
            }
            case 20: {
                v.visitStackProducer(this);
                v.visitPushInstruction(this);
                v.visitTypedInstruction(this);
                v.visitCPInstruction(this);
                v.visitLDC2_W(this);
                break;
            }
            case 190: {
                v.visitExceptionThrower(this);
                v.visitStackProducer(this);
                v.visitARRAYLENGTH(this);
                break;
            }
            case 75: {
                v.visitStackConsumer(this);
                v.visitPopInstruction(this);
                v.visitStoreInstruction(this);
                v.visitTypedInstruction(this);
                v.visitLocalVariableInstruction((InstructionLV)this);
                v.visitStoreInstruction(this);
                v.visitASTORE(this);
                break;
            }
            case 42: {
                v.visitStackConsumer(this);
                v.visitPopInstruction(this);
                v.visitStoreInstruction(this);
                v.visitTypedInstruction(this);
                v.visitLocalVariableInstruction((InstructionLV)this);
                v.visitStoreInstruction(this);
                v.visitALOAD(this);
                break;
            }
            case 184: {
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitStackConsumer(this);
                v.visitStackProducer(this);
                v.visitLoadClass(this);
                v.visitCPInstruction(this);
                v.visitFieldOrMethod(this);
                v.visitInvokeInstruction((InvokeInstruction)this);
                v.visitINVOKESTATIC((InvokeInstruction)this);
                break;
            }
            case 167: {
                v.visitVariableLengthInstruction(this);
                v.visitUnconditionalBranch(this);
                v.visitBranchInstruction((InstructionBranch)this);
                v.visitGotoInstruction(this);
                v.visitGOTO(this);
                break;
            }
            case 179: {
                v.visitExceptionThrower(this);
                v.visitStackConsumer(this);
                v.visitPopInstruction(this);
                v.visitTypedInstruction(this);
                v.visitLoadClass(this);
                v.visitCPInstruction(this);
                v.visitFieldOrMethod(this);
                v.visitFieldInstruction(this);
                v.visitPUTSTATIC((FieldInstruction)this);
                break;
            }
            case 177: {
                v.visitExceptionThrower(this);
                v.visitTypedInstruction(this);
                v.visitStackConsumer(this);
                v.visitReturnInstruction(this);
                v.visitRETURN(this);
                break;
            }
            default: {
                throw new IllegalStateException("visiting not yet implemented for " + this.getName().toUpperCase());
            }
        }
    }

    public boolean equals(Object that) {
        return that instanceof Instruction ? cmp.equals(this, (Instruction)that) : false;
    }

    public Type getType() {
        return this.getType(null);
    }

    public Type getType(ConstantPool cp) {
        Type t = Constants.types[this.opcode];
        if (t != null) {
            return t;
        }
        switch (this.opcode) {
            case 172: {
                return Type.INT;
            }
            case 173: {
                return Type.LONG;
            }
            case 174: {
                return Type.FLOAT;
            }
            case 175: {
                return Type.DOUBLE;
            }
            case 176: {
                return Type.OBJECT;
            }
            case 177: {
                return Type.VOID;
            }
            case 148: {
                return Type.LONG;
            }
            case 151: 
            case 152: {
                return Type.DOUBLE;
            }
            case 149: 
            case 150: {
                return Type.FLOAT;
            }
            case 1: {
                return Type.NULL;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Type.INT;
            }
            case 46: 
            case 79: {
                return Type.INT;
            }
            case 52: 
            case 85: {
                return Type.CHAR;
            }
            case 51: 
            case 84: {
                return Type.BYTE;
            }
            case 53: 
            case 86: {
                return Type.SHORT;
            }
            case 47: 
            case 80: {
                return Type.LONG;
            }
            case 49: 
            case 82: {
                return Type.DOUBLE;
            }
            case 48: 
            case 81: {
                return Type.FLOAT;
            }
            case 50: 
            case 83: {
                return Type.OBJECT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
            case 136: 
            case 139: 
            case 142: {
                return Type.INT;
            }
            case 134: 
            case 137: 
            case 144: {
                return Type.FLOAT;
            }
            case 133: 
            case 140: 
            case 143: {
                return Type.LONG;
            }
            case 135: 
            case 138: 
            case 141: {
                return Type.DOUBLE;
            }
            case 145: {
                return Type.BYTE;
            }
            case 146: {
                return Type.CHAR;
            }
            case 147: {
                return Type.SHORT;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return Type.INT;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                return Type.DOUBLE;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                return Type.FLOAT;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return Type.LONG;
            }
        }
        throw new IllegalStateException("Not implemented yet for " + this.getName().toUpperCase());
    }

    public Number getValue() {
        if ((Constants.instFlags[this.opcode] & 2L) == 0L) {
            throw new RuntimeException(String.valueOf(this.getName()) + " is not a constant instruction");
        }
        switch (this.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new Integer(this.opcode - 3);
            }
        }
        throw new IllegalStateException("Not implemented yet for " + this.getName());
    }

    public int getIndex() {
        return -1;
    }

    public void setIndex(int i) {
        throw new IllegalStateException("Shouldnt be asking " + this.getName().toUpperCase());
    }

    public Object getValue(ConstantPool cpg) {
        throw new IllegalStateException("Shouldnt be asking " + this.getName().toUpperCase());
    }

    public boolean isLoadInstruction() {
        return (Constants.instFlags[this.opcode] & 0x20L) != 0L;
    }

    public boolean isALOAD() {
        return false;
    }

    public boolean isStoreInstruction() {
        return (Constants.instFlags[this.opcode] & 0x100L) != 0L;
    }

    public boolean isASTORE() {
        return false;
    }

    public Class[] getExceptions() {
        return Constants.instExcs[this.opcode];
    }

    public boolean containsTarget(InstructionHandle ih) {
        throw new IllegalStateException("Dont ask!!");
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        throw new IllegalStateException("Dont ask!!");
    }

    public boolean isJsrInstruction() {
        return (Constants.instFlags[this.opcode] & 0x4000L) != 0L;
    }

    public boolean isConstantInstruction() {
        return (Constants.instFlags[this.opcode] & 2L) != 0L;
    }

    public boolean isConstantPoolInstruction() {
        return (Constants.instFlags[this.opcode] & 8L) != 0L;
    }

    public boolean isStackProducer() {
        return Constants.stackEntriesProduced[this.opcode] != 0;
    }

    public boolean isStackConsumer() {
        return Constants.CONSUME_STACK[this.opcode] != 0;
    }

    public boolean isIndexedInstruction() {
        return (Constants.instFlags[this.opcode] & 0x10L) != 0L;
    }

    public boolean isArrayCreationInstruction() {
        return this.opcode == 188 || this.opcode == 189 || this.opcode == 197;
    }

    public void assertSomething(long flag) {
        if ((Constants.instFlags[this.opcode] & flag) == 0L) {
            throw new IllegalStateException("This opcode " + this.opcode + " does not have the property " + Long.toHexString(flag));
        }
    }

    public ObjectType getLoadClassType(ConstantPool cpg) {
        this.assertSomething(4L);
        Type t = this.getType(cpg);
        if (t instanceof ArrayType) {
            t = ((ArrayType)t).getBasicType();
        }
        return t instanceof ObjectType ? (ObjectType)t : null;
    }

    public boolean isReturnInstruction() {
        return (Constants.instFlags[this.opcode] & 0x8000L) != 0L;
    }

    public boolean isGoto() {
        return this.opcode == 167 || this.opcode == 200;
    }

    public boolean isLocalVariableInstruction() {
        return (Constants.instFlags[this.opcode] & 0x40L) != 0L;
    }
}

