/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.ajde.core.internal.AjdeCoreBuildNotifierAdapter;
import org.aspectj.ajde.core.internal.AjdeCoreMessageHandlerAdapter;
import org.aspectj.ajde.core.internal.OutputLocationAdapter;
import org.aspectj.ajdt.ajc.AjdtCommand;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.ajc.ConfigParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.util.LangUtil;

public class AjdeCoreBuildManager {
    private AjCompiler compiler;
    private AjdeCoreBuildNotifierAdapter currNotifier = null;
    private AjBuildManager ajBuildManager;
    private IMessageHandler msgHandlerAdapter;

    public AjdeCoreBuildManager(AjCompiler compiler) {
        this.compiler = compiler;
        this.msgHandlerAdapter = new AjdeCoreMessageHandlerAdapter(compiler.getMessageHandler());
        this.ajBuildManager = new AjBuildManager(this.msgHandlerAdapter);
        this.ajBuildManager.environmentSupportsIncrementalCompilation(true);
        IncrementalStateManager.recordIncrementalStates = true;
        IncrementalStateManager.debugIncrementalStates = false;
        AsmManager.attemptIncrementalModelRepairs = true;
    }

    public void setCustomMungerFactory(Object o) {
        this.ajBuildManager.setCustomMungerFactory(o);
    }

    public Object getCustomMungerFactory() {
        return this.ajBuildManager.getCustomMungerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBuild(boolean buildFresh) {
        if (!buildFresh) {
            buildFresh = this.updateAsmManagerInformation();
        }
        try {
            this.startNotifiers();
            this.handleMessage(new Message(this.getFormattedOptionsString(), IMessage.INFO, null, null));
            CompilationAndWeavingContext.reset();
            AjBuildConfig buildConfig = this.genAjBuildConfig();
            if (buildConfig == null) {
                return;
            }
            if (buildFresh) {
                this.ajBuildManager.batchBuild(buildConfig, this.msgHandlerAdapter);
            } else {
                this.ajBuildManager.incrementalBuild(buildConfig, this.msgHandlerAdapter);
            }
            IncrementalStateManager.recordSuccessfulBuild(this.compiler.getId(), this.ajBuildManager.getState());
        }
        catch (ConfigParser.ParseException pe) {
            this.handleMessage(new Message("Config file entry invalid, file: " + pe.getFile().getPath() + ", line number: " + pe.getLine(), IMessage.WARNING, null, null));
        }
        catch (AbortException e) {
            IMessage message = e.getIMessage();
            if (message == null) {
                this.handleMessage(new Message(LangUtil.unqualifiedClassName(e) + " thrown: " + e.getMessage(), IMessage.ERROR, e, null));
            } else {
                this.handleMessage(new Message(message.getMessage() + "\n" + CompilationAndWeavingContext.getCurrentContext(), IMessage.ERROR, e, null));
            }
        }
        catch (Throwable t) {
            this.handleMessage(new Message("Compile error: " + LangUtil.unqualifiedClassName(t) + " thrown: " + "" + t.getMessage(), IMessage.ABORT, t, null));
        }
        finally {
            this.compiler.getBuildProgressMonitor().finish(this.ajBuildManager.wasFullBuild());
        }
    }

    private void startNotifiers() {
        this.compiler.getBuildProgressMonitor().begin();
        this.currNotifier = new AjdeCoreBuildNotifierAdapter(this.compiler.getBuildProgressMonitor());
        this.ajBuildManager.setProgressListener(this.currNotifier);
    }

    private boolean updateAsmManagerInformation() {
        AjState updatedState = IncrementalStateManager.retrieveStateFor(this.compiler.getId());
        if (updatedState == null) {
            return true;
        }
        AsmManager.getDefault().setRelationshipMap(updatedState.getRelationshipMap());
        AsmManager.getDefault().setHierarchy(updatedState.getStructureModel());
        return false;
    }

    private String getFormattedOptionsString() {
        ICompilerConfiguration compilerConfig = this.compiler.getCompilerConfiguration();
        return "Building with settings: \n-> output paths: " + this.formatCollection(compilerConfig.getOutputLocationManager().getAllOutputLocations()) + "\n-> classpath: " + compilerConfig.getClasspath() + "\n-> -inpath " + this.formatCollection(compilerConfig.getInpath()) + "\n-> -outjar " + this.formatOptionalString(compilerConfig.getOutJar()) + "\n-> -aspectpath " + this.formatCollection(compilerConfig.getAspectPath()) + "\n-> -sourcePathResources " + this.formatMap(compilerConfig.getSourcePathResources()) + "\n-> non-standard options: " + compilerConfig.getNonStandardOptions() + "\n-> javaoptions:" + this.formatMap(compilerConfig.getJavaOptionsMap());
    }

    private String formatCollection(Collection options) {
        if (options == null) {
            return "<default>";
        }
        if (options.isEmpty()) {
            return "none";
        }
        StringBuffer formattedOptions = new StringBuffer();
        Iterator it = options.iterator();
        while (it.hasNext()) {
            String o = it.next().toString();
            if (formattedOptions.length() > 0) {
                formattedOptions.append(", ");
            }
            formattedOptions.append(o);
        }
        return formattedOptions.toString();
    }

    private String formatMap(Map options) {
        if (options == null) {
            return "<default>";
        }
        if (options.isEmpty()) {
            return "none";
        }
        return options.toString();
    }

    private String formatOptionalString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public AjBuildConfig genAjBuildConfig() {
        String message;
        File configFile = new File(this.compiler.getId());
        String[] args = null;
        if (configFile.exists() && configFile.isFile()) {
            args = new String[]{"@" + configFile.getAbsolutePath()};
        } else {
            List l = this.compiler.getCompilerConfiguration().getProjectSourceFiles();
            if (l == null) {
                return null;
            }
            args = new String[l.size()];
            int counter = 0;
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                String element;
                args[counter] = element = (String)iter.next();
                ++counter;
            }
        }
        CountingMessageHandler handler = CountingMessageHandler.makeCountingMessageHandler(this.msgHandlerAdapter);
        BuildArgParser parser = new BuildArgParser(handler);
        AjBuildConfig config = new AjBuildConfig();
        parser.populateBuildConfig(config, args, false, configFile);
        this.configureCompilerOptions(config);
        SourceLocation location = null;
        if (config.getConfigFile() != null) {
            location = new SourceLocation(config.getConfigFile(), 0);
        }
        if (null != (message = parser.getOtherMessages(true))) {
            Message m = new Message(message, IMessage.ERROR, null, location);
            handler.handleMessage(m);
        }
        config.setGenerateModelMode(true);
        config.setIncrementalMode(true);
        return config;
    }

    private void checkNotAskedForJava6Compliance() {
        Map javaOptions = this.compiler.getCompilerConfiguration().getJavaOptionsMap();
        if (javaOptions != null) {
            String version = (String)javaOptions.get("org.eclipse.jdt.core.compiler.compliance");
            String sourceVersion = (String)javaOptions.get("org.eclipse.jdt.core.compiler.source");
            String targetVersion = (String)javaOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if (version != null && version.equals("1.6")) {
                String msg = "Java 6.0 compliance level is unsupported";
                Message m = new Message(msg, IMessage.ERROR, null, null);
                this.compiler.getMessageHandler().handleMessage(m);
            } else if (sourceVersion != null && sourceVersion.equals("1.6")) {
                String msg = "Java 6.0 source level is unsupported";
                Message m = new Message(msg, IMessage.ERROR, null, null);
                this.compiler.getMessageHandler().handleMessage(m);
            } else if (targetVersion != null && targetVersion.equals("1.6")) {
                String msg = "Java 6.0 target level is unsupported";
                Message m = new Message(msg, IMessage.ERROR, null, null);
                this.compiler.getMessageHandler().handleMessage(m);
            }
        }
    }

    private void configureCompilerOptions(AjBuildConfig config) {
        String outJar;
        String propcp = this.compiler.getCompilerConfiguration().getClasspath();
        if (!LangUtil.isEmpty(propcp)) {
            StringTokenizer st = new StringTokenizer(propcp, File.pathSeparator);
            List configClasspath = config.getClasspath();
            ArrayList<String> toAdd = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                if (configClasspath.contains(entry)) continue;
                toAdd.add(entry);
            }
            if (0 < toAdd.size()) {
                ArrayList<String> both = new ArrayList<String>(configClasspath.size() + toAdd.size());
                both.addAll(configClasspath);
                both.addAll(toAdd);
                config.setClasspath(both);
            }
        }
        if (config.getOutputJar() == null && !LangUtil.isEmpty(outJar = this.compiler.getCompilerConfiguration().getOutJar())) {
            config.setOutputJar(new File(outJar));
        }
        IOutputLocationManager outputLocationManager = this.compiler.getCompilerConfiguration().getOutputLocationManager();
        if (config.getCompilationResultDestinationManager() == null && outputLocationManager != null) {
            config.setCompilationResultDestinationManager(new OutputLocationAdapter(outputLocationManager));
        }
        this.join(config.getInpath(), this.compiler.getCompilerConfiguration().getInpath());
        if (config.getInpath() != null) {
            config.setInPath(config.getInpath());
        }
        config.setSourcePathResources(this.compiler.getCompilerConfiguration().getSourcePathResources());
        this.join(config.getAspectpath(), this.compiler.getCompilerConfiguration().getAspectPath());
        Map jom = this.compiler.getCompilerConfiguration().getJavaOptionsMap();
        if (jom != null) {
            String version = (String)jom.get("org.eclipse.jdt.core.compiler.compliance");
            if (version != null && (version.equals("1.5") || version.equals("1.6"))) {
                config.setBehaveInJava5Way(true);
            }
            config.getOptions().set(jom);
        }
        this.configureNonStandardOptions(config);
    }

    private void join(Collection target, Collection source) {
        if (null == target || null == source) {
            return;
        }
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (target.contains(next)) continue;
            target.add(next);
        }
    }

    private void configureNonStandardOptions(AjBuildConfig config) {
        String nonStdOptions = this.compiler.getCompilerConfiguration().getNonStandardOptions();
        if (LangUtil.isEmpty(nonStdOptions)) {
            return;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int ind = nonStdOptions.indexOf(34);
        int ind2 = nonStdOptions.indexOf(34, ind + 1);
        if (ind > -1 && ind2 > -1) {
            String pre = nonStdOptions.substring(0, ind);
            String quoted = nonStdOptions.substring(ind + 1, ind2);
            String post = nonStdOptions.substring(ind2 + 1, nonStdOptions.length());
            tokens.addAll(this.tokenizeString(pre));
            tokens.add(quoted);
            tokens.addAll(this.tokenizeString(post));
        } else {
            tokens.addAll(this.tokenizeString(nonStdOptions));
        }
        String[] args = tokens.toArray(new String[0]);
        CountingMessageHandler counter = CountingMessageHandler.makeCountingMessageHandler(this.msgHandlerAdapter);
        AjBuildConfig altConfig = AjdtCommand.genBuildConfig(args, counter);
        if (counter.hasErrors()) {
            return;
        }
        config.installGlobals(altConfig);
    }

    private List tokenizeString(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(str);
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken());
        }
        return tokens;
    }

    private void handleMessage(Message msg) {
        this.compiler.getMessageHandler().handleMessage(msg);
    }
}

