/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.cli;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.jruby.GlobDirectoryWalker;
import org.asciidoctor.jruby.cli.AsciidoctorCliOptions;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.jruby.Main;
import org.jruby.runtime.builtin.IRubyObject;

public class AsciidoctorInvoker {
    public void invoke(String ... parameters) {
        AsciidoctorCliOptions asciidoctorCliOptions = new AsciidoctorCliOptions();
        JCommander jCommander = new JCommander((Object)asciidoctorCliOptions, parameters);
        if (asciidoctorCliOptions.isHelp() || parameters.length == 0) {
            jCommander.setProgramName("asciidoctor");
            jCommander.usage();
        } else {
            JRubyAsciidoctor asciidoctor = this.buildAsciidoctorJInstance(asciidoctorCliOptions);
            if (asciidoctorCliOptions.isVersion()) {
                System.out.println("AsciidoctorJ " + this.getAsciidoctorJVersion() + " (Asciidoctor " + asciidoctor.asciidoctorVersion() + ") [https://asciidoctor.org]");
                IRubyObject rubyVersionString = JRubyRuntimeContext.get(asciidoctor).evalScriptlet("\"#{JRUBY_VERSION} (#{RUBY_VERSION})\"");
                System.out.println("Runtime Environment: jruby " + rubyVersionString);
                return;
            }
            List<File> inputFiles = this.getInputFiles(asciidoctorCliOptions);
            if (inputFiles.isEmpty()) {
                System.err.println("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
                throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + asciidoctorCliOptions.getParameters() + "' missing or cannot be read");
            }
            Options options = asciidoctorCliOptions.parse();
            if (asciidoctorCliOptions.isRequire()) {
                for (String require : asciidoctorCliOptions.getRequire()) {
                    RubyUtils.requireLibrary(asciidoctor.getRubyRuntime(), require);
                }
            }
            this.setTimingsMode(asciidoctor, asciidoctorCliOptions, options);
            this.setVerboseLevel(asciidoctor, asciidoctorCliOptions);
            String output = this.renderInput(asciidoctor, options, inputFiles);
            if (asciidoctorCliOptions.isTimings()) {
                Map optionsMap = options.map();
                IRubyObject timings = (IRubyObject)optionsMap.get("timings");
                timings.callMethod(JRubyRuntimeContext.get(asciidoctor).getCurrentContext(), "print_report");
            }
            if (!"".equals(output.trim())) {
                System.out.println(output);
            }
        }
    }

    private String getAsciidoctorJVersion() {
        InputStream in = this.getClass().getResourceAsStream("/META-INF/asciidoctorj-version.properties");
        if (in == null) {
            return "N/A";
        }
        Properties versionProps = new Properties();
        try {
            versionProps.load(in);
            return versionProps.getProperty("version.asciidoctorj");
        }
        catch (IOException e) {
            return "N/A";
        }
    }

    private void setTimingsMode(Asciidoctor asciidoctor, AsciidoctorCliOptions asciidoctorCliOptions, Options options) {
        if (asciidoctorCliOptions.isTimings()) {
            options.setOption("timings", (Object)JRubyRuntimeContext.get(asciidoctor).evalScriptlet("Asciidoctor::Timings.new"));
        }
    }

    private void setVerboseLevel(JRubyAsciidoctor asciidoctor, AsciidoctorCliOptions asciidoctorCliOptions) {
        if (asciidoctorCliOptions.isVerbose()) {
            RubyUtils.setGlobalVariable(asciidoctor.getRubyRuntime(), "VERBOSE", "true");
        } else if (asciidoctorCliOptions.isQuiet()) {
            RubyUtils.setGlobalVariable(asciidoctor.getRubyRuntime(), "VERBOSE", "nil");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JRubyAsciidoctor buildAsciidoctorJInstance(AsciidoctorCliOptions asciidoctorCliOptions) {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            if (asciidoctorCliOptions.isClassPaths()) {
                URLClassLoader tccl = this.createUrlClassLoader(asciidoctorCliOptions.getClassPaths());
                Thread.currentThread().setContextClassLoader(tccl);
            }
            JRubyAsciidoctor asciidoctor = asciidoctorCliOptions.isLoadPaths() ? JRubyAsciidoctor.create(asciidoctorCliOptions.getLoadPaths()) : JRubyAsciidoctor.create((String)null);
            JRubyAsciidoctor jRubyAsciidoctor = asciidoctor;
            return jRubyAsciidoctor;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    private URLClassLoader createUrlClassLoader(List<String> classPaths) {
        ArrayList<URL> cpUrls = new ArrayList<URL>();
        for (String cp : classPaths) {
            try {
                GlobDirectoryWalker globDirectoryWalker = new GlobDirectoryWalker(cp);
                for (File f : globDirectoryWalker.scan()) {
                    cpUrls.add(f.toURI().toURL());
                }
            }
            catch (Exception e) {
                System.err.println(String.format("asciidoctor: WARNING: Could not resolve classpath '%s': %s", cp, e.getMessage()));
            }
        }
        return new URLClassLoader(cpUrls.toArray(new URL[cpUrls.size()]));
    }

    private String renderInput(Asciidoctor asciidoctor, Options options, List<File> inputFiles) {
        StringBuilder output = new StringBuilder();
        for (File inputFile : inputFiles) {
            if (inputFile.canRead()) {
                String renderedFile = asciidoctor.convertFile(inputFile, options);
                if (renderedFile == null) continue;
                output.append(renderedFile).append(System.getProperty("line.separator"));
                continue;
            }
            System.err.println("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
            throw new IllegalArgumentException("asciidoctor: FAILED: input file(s) '" + inputFile.getAbsolutePath() + "' missing or cannot be read");
        }
        return output.toString();
    }

    private String readInputFromStdIn() {
        Scanner in = new Scanner(System.in);
        String content = in.nextLine();
        in.close();
        return content;
    }

    private List<File> getInputFiles(AsciidoctorCliOptions asciidoctorCliOptions) {
        List<String> parameters = asciidoctorCliOptions.getParameters();
        if (parameters.isEmpty()) {
            System.err.println("asciidoctor: FAILED: input file missing");
            throw new IllegalArgumentException("asciidoctor: FAILED: input file missing");
        }
        if (parameters.contains("-")) {
            System.err.println("asciidoctor:  FAILED: input file is required instead of an argument.");
            throw new IllegalArgumentException("asciidoctor:  FAILED: input file is required instead of an argument.");
        }
        ArrayList<File> filesToBeRendered = new ArrayList<File>();
        for (String globExpression : parameters) {
            GlobDirectoryWalker globDirectoryWalker = new GlobDirectoryWalker(globExpression);
            filesToBeRendered.addAll(globDirectoryWalker.scan());
        }
        return filesToBeRendered;
    }

    public static void main(String[] args) {
        Main.processDotfile();
        new AsciidoctorInvoker().invoke(args);
    }
}

