/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import java.util.List;
import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.jruby.ast.impl.TableImpl;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;
import org.asciidoctor.maven.site.parser.processors.SinkAttributes;
import org.asciidoctor.maven.site.parser.processors.Styles;
import org.asciidoctor.maven.site.parser.processors.TitleCaptionExtractor;

public class TableNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    public TableNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "table".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        TableImpl tableNode = (TableImpl)node;
        Sink sink = this.getSink();
        sink.table(SinkAttributes.of("style", "background: #FFFFFF"));
        sink.tableRows(new int[]{1}, false);
        List header = tableNode.getHeader();
        List rows = tableNode.getBody();
        if (header.isEmpty() && rows.isEmpty()) {
            return;
        }
        if (!header.isEmpty()) {
            sink.tableRow();
            for (Row headerRow : header) {
                for (Cell cell : headerRow.getCells()) {
                    sink.tableHeaderCell();
                    sink.rawText(cell.getText());
                    sink.tableHeaderCell_();
                }
            }
            sink.tableRow_();
        }
        for (Row row : rows) {
            sink.tableRow();
            for (Cell cell : row.getCells()) {
                sink.tableCell();
                sink.rawText(cell.getText());
                sink.tableCell_();
            }
            sink.tableRow_();
        }
        sink.tableRows_();
        this.processCaption(node, sink);
        sink.table_();
    }

    private void processCaption(StructuralNode node, Sink sink) {
        String tableCaption = (String)node.getAttribute((Object)"table-caption");
        String caption = node.getCaption();
        String title = TitleCaptionExtractor.getText(node);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sink.tableCaption(SinkAttributes.of("style", Styles.CAPTION + "; text-align: left"));
            sink.rawText(title);
            sink.tableCaption_();
        }
    }
}

