/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site.parser.processors;

import org.apache.maven.doxia.sink.Sink;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.maven.site.parser.NodeProcessor;
import org.asciidoctor.maven.site.parser.NodeSinker;
import org.asciidoctor.maven.site.parser.processors.AbstractSinkNodeProcessor;

public class ListItemNodeProcessor
extends AbstractSinkNodeProcessor
implements NodeProcessor {
    public ListItemNodeProcessor(Sink sink, NodeSinker nodeSinker) {
        super(sink, nodeSinker);
    }

    @Override
    public boolean applies(StructuralNode node) {
        return "list_item".equals(node.getNodeName());
    }

    @Override
    public void process(StructuralNode node) {
        ListItem item = (ListItem)node;
        Sink sink = this.getSink();
        ListType listType = ListItemNodeProcessor.getListType(item);
        switch (listType) {
            case ordered: {
                sink.numberedListItem();
                break;
            }
            case unordered: {
                sink.listItem();
            }
        }
        String text = item.getText();
        sink.rawText(text == null ? "" : text);
        node.getBlocks().forEach(this::sink);
        switch (listType) {
            case ordered: {
                sink.numberedListItem_();
                break;
            }
            case unordered: {
                sink.listItem_();
            }
        }
    }

    private static ListType getListType(ListItem item) {
        String marker = item.getMarker();
        if (marker == null) {
            return ListType.description;
        }
        if (marker.startsWith("*") || marker.startsWith("-")) {
            return ListType.ordered;
        }
        return ListType.unordered;
    }

    static enum ListType {
        ordered,
        unordered,
        description;

    }
}

